/*
 * Decompiled with CFR 0.152.
 */
package jsat.math.optimization.oned;

import jsat.math.Function;

public class Brent {
    private static final double goldenRatio = (Math.sqrt(5.0) - 1.0) / 2.0;

    public static double findMin(double min, double max, Function f, double eps, int maxSteps) {
        double a = min;
        double b = max;
        double fa = f.f(a);
        double fb = f.f(b);
        double c = b - goldenRatio * (b - a);
        double d = a + goldenRatio * (b - a);
        double fc = f.f(c);
        double fd = f.f(d);
        while (Math.abs(c - d) > eps && maxSteps-- > 0) {
            if (fc < fd) {
                b = d;
                fb = fd;
                d = c;
                fd = fc;
                c = b - goldenRatio * (b - a);
                fc = f.f(c);
                continue;
            }
            a = c;
            fa = fc;
            c = d;
            fc = fd;
            d = a + goldenRatio * (b - a);
            fd = f.f(d);
        }
        return (a + b) / 2.0;
    }
}

