/*
 * Decompiled with CFR 0.152.
 */
package jsat.utils;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import jsat.utils.ClosedHashingUtil;

public final class IntDoubleMap
extends AbstractMap<Integer, Double> {
    private float loadFactor;
    private int used = 0;
    private byte[] status;
    private int[] keys;
    private double[] table;
    private static final long EXTRA_INDEX_INFO = Long.MIN_VALUE;

    public IntDoubleMap() {
        this(32);
    }

    public IntDoubleMap(int capacity) {
        this(capacity, 0.75f);
    }

    public IntDoubleMap(Map<Integer, Double> collection) {
        this(Math.max(1, collection.size()));
        for (Map.Entry<Integer, Double> entry : collection.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public IntDoubleMap(int capacity, float loadFactor) {
        if (capacity < 1) {
            throw new IllegalArgumentException("Capacity must be a positive value, not " + capacity);
        }
        if (loadFactor <= 0.0f || loadFactor >= 1.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("loadFactor must be in (0, 1), not " + loadFactor);
        }
        this.loadFactor = loadFactor;
        int size = ClosedHashingUtil.getNextPow2TwinPrime((int)Math.max((float)capacity / loadFactor, 4.0f));
        this.status = new byte[size];
        this.keys = new int[size];
        this.table = new double[size];
    }

    @Override
    public int size() {
        return this.used;
    }

    public int[] getRawKeyTable() {
        return this.keys;
    }

    public double[] getRawValueTable() {
        return this.table;
    }

    public byte[] getRawStatusTable() {
        return this.status;
    }

    @Override
    public Double put(Integer key, Double value) {
        double prev = this.put((int)key, (double)value);
        if (Double.isNaN(prev)) {
            return null;
        }
        return prev;
    }

    @Override
    public double put(int key, double value) {
        if (Double.isNaN(value)) {
            throw new IllegalArgumentException("NaN is not an allowable value");
        }
        long pair_index = this.getIndex(key);
        int deletedIndex = (int)(pair_index >>> 32);
        int valOrFreeIndex = (int)(pair_index & 0xFFFFFFFFFFFFFFFFL);
        if (this.status[valOrFreeIndex] == 1) {
            double prev = this.table[valOrFreeIndex];
            this.table[valOrFreeIndex] = value;
            return prev;
        }
        double prev = Double.NaN;
        int i = valOrFreeIndex;
        if (deletedIndex >= 0) {
            i = deletedIndex;
        }
        this.status[i] = 1;
        this.keys[i] = key;
        this.table[i] = value;
        ++this.used;
        this.enlargeIfNeeded();
        return prev;
    }

    public double increment(int key, double delta) {
        if (Double.isNaN(delta)) {
            throw new IllegalArgumentException("NaN is not an allowable value");
        }
        long pair_index = this.getIndex(key);
        int deletedIndex = (int)(pair_index >>> 32);
        int valOrFreeIndex = (int)(pair_index & 0xFFFFFFFFFFFFFFFFL);
        if (this.status[valOrFreeIndex] == 1) {
            int n = valOrFreeIndex;
            double d = this.table[n] + delta;
            this.table[n] = d;
            return d;
        }
        int i = valOrFreeIndex;
        if (deletedIndex >= 0) {
            i = deletedIndex;
        }
        this.status[i] = 1;
        this.keys[i] = key;
        double toReturn = this.table[i] = delta;
        ++this.used;
        this.enlargeIfNeeded();
        return toReturn;
    }

    public double get(int key) {
        long pair_index = this.getIndex(key);
        int valOrFreeIndex = (int)(pair_index & 0xFFFFFFFFFFFFFFFFL);
        if (this.status[valOrFreeIndex] == 1) {
            return this.table[valOrFreeIndex];
        }
        return Double.NaN;
    }

    @Override
    public Double get(Object key) {
        if (key == null) {
            return null;
        }
        if (key instanceof Integer) {
            double d = this.get((Integer)key);
            if (Double.isNaN(d)) {
                return null;
            }
            return d;
        }
        throw new ClassCastException("Key not of integer type");
    }

    @Override
    public Double remove(Object key) {
        if (key instanceof Integer) {
            double oldValue = this.remove((Integer)key);
            if (Double.isNaN(oldValue)) {
                return null;
            }
            return oldValue;
        }
        return null;
    }

    public double remove(int key) {
        long pair_index = this.getIndex(key);
        int valOrFreeIndex = (int)(pair_index & 0xFFFFFFFFFFFFFFFFL);
        if (this.status[valOrFreeIndex] == 0) {
            return Double.NaN;
        }
        double toRet = this.table[valOrFreeIndex];
        this.status[valOrFreeIndex] = 2;
        --this.used;
        return toRet;
    }

    @Override
    public void clear() {
        this.used = 0;
        Arrays.fill(this.status, (byte)0);
    }

    private void enlargeIfNeeded() {
        if ((float)this.used < (float)this.keys.length * this.loadFactor) {
            return;
        }
        byte[] oldSatus = this.status;
        int[] oldKeys = this.keys;
        double[] oldTable = this.table;
        int newSize = ClosedHashingUtil.getNextPow2TwinPrime(this.status.length * 3 / 2);
        this.status = new byte[newSize];
        this.keys = new int[newSize];
        this.table = new double[newSize];
        this.used = 0;
        for (int oldIndex = 0; oldIndex < oldSatus.length; ++oldIndex) {
            if (oldSatus[oldIndex] != 1) continue;
            this.put(oldKeys[oldIndex], oldTable[oldIndex]);
        }
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof Integer) {
            return this.containsKey((Integer)key);
        }
        return false;
    }

    public boolean containsKey(int key) {
        int index = (int)(this.getIndex(key) & 0xFFFFFFFFFFFFFFFFL);
        return this.status[index] == 1;
    }

    private long getIndex(int key) {
        long extraInfo = Long.MIN_VALUE;
        int hash = IntDoubleMap.h(key) & 0xFFFFFFFF;
        int i = hash % this.keys.length;
        byte satus_i = this.status[i];
        if (this.keys[i] == key && satus_i != 2 || satus_i == 0) {
            return extraInfo | (long)i;
        }
        if (extraInfo == Long.MIN_VALUE && satus_i == 2) {
            extraInfo = (long)i << 32;
        }
        int c = 1 + hash % (this.keys.length - 2);
        while (true) {
            if ((i -= c) < 0) {
                i += this.keys.length;
            }
            satus_i = this.status[i];
            if (this.keys[i] == key && satus_i != 2 || satus_i == 0) {
                return extraInfo | (long)i;
            }
            if (extraInfo != Long.MIN_VALUE || satus_i != 2) continue;
            extraInfo = (long)i << 32;
        }
    }

    public static int h(int key) {
        key = (key >>> 16 ^ key) & 0x45F9F3B;
        key = (key >>> 16 ^ key) & 0x45F9F3B;
        key = key >>> 16 ^ key;
        return key;
    }

    @Override
    public Set<Map.Entry<Integer, Double>> entrySet() {
        return new EntrySet(this);
    }

    private final class EntrySet
    extends AbstractSet<Map.Entry<Integer, Double>> {
        final IntDoubleMap parentRef;

        public EntrySet(IntDoubleMap parent) {
            this.parentRef = parent;
        }

        @Override
        public Iterator<Map.Entry<Integer, Double>> iterator() {
            int START;
            for (START = 0; START < IntDoubleMap.this.status.length && IntDoubleMap.this.status[START] != 1; ++START) {
            }
            if (START == IntDoubleMap.this.status.length) {
                return Collections.emptyIterator();
            }
            final int startPos = START;
            return new Iterator<Map.Entry<Integer, Double>>(){
                int pos;
                int prevPos;
                {
                    this.pos = startPos;
                    this.prevPos = -1;
                }

                @Override
                public boolean hasNext() {
                    return this.pos < IntDoubleMap.this.status.length;
                }

                @Override
                public Map.Entry<Integer, Double> next() {
                    this.prevPos = this.pos++;
                    final int oldPos = this.prevPos;
                    while (this.pos < IntDoubleMap.this.status.length && IntDoubleMap.this.status[this.pos] != 1) {
                        ++this.pos;
                    }
                    return new Map.Entry<Integer, Double>(){

                        @Override
                        public Integer getKey() {
                            return IntDoubleMap.this.keys[oldPos];
                        }

                        @Override
                        public Double getValue() {
                            return IntDoubleMap.this.table[oldPos];
                        }

                        @Override
                        public Double setValue(Double value) {
                            double old = IntDoubleMap.this.table[oldPos];
                            ((IntDoubleMap)IntDoubleMap.this).table[oldPos] = value;
                            return old;
                        }
                    };
                }

                @Override
                public void remove() {
                    EntrySet.this.parentRef.remove(IntDoubleMap.this.keys[this.prevPos]);
                }
            };
        }

        @Override
        public int size() {
            return IntDoubleMap.this.used;
        }
    }
}

