/*
 * Decompiled with CFR 0.152.
 */
package jsat.utils;

public class StringUtils {
    public static int parseInt(CharSequence s, int start, int end, int radix) {
        boolean negative = false;
        int val = 0;
        for (int i = start; i < end; ++i) {
            char c = s.charAt(i);
            if (c == '-') {
                if (i == start) {
                    negative = true;
                    continue;
                }
                throw new NumberFormatException("Negative sign did not occur at begining of sequence");
            }
            if (c == '+') {
                if (i == start) {
                    negative = false;
                    continue;
                }
                throw new NumberFormatException("Positive sign did not occur at begining of sequence");
            }
            int digit = Character.digit(c, radix);
            if (digit < 0) {
                throw new NumberFormatException("Non digit character '" + c + "' encountered");
            }
            val *= radix;
            val += digit;
        }
        if (negative) {
            return -val;
        }
        return val;
    }

    public static int parseInt(CharSequence s, int start, int end) {
        return StringUtils.parseInt(s, start, end, 10);
    }

    public static double parseDouble(CharSequence s, int start, int end) {
        if (end - start == 3 && s.length() >= end && s.charAt(start) == 'N' && s.subSequence(start, end).toString().equals("NaN")) {
            return Double.NaN;
        }
        States state = States.SIGN;
        int pos = start;
        int sign = 1;
        long mantissa = 0L;
        int mantisaIncrements = 0;
        int implicitExponent = 0;
        int expoSign = 1;
        int explicitExponent = 0;
        block10: while (pos < end) {
            char c = s.charAt(pos);
            switch (state) {
                case SIGN: {
                    if (c == '-') {
                        sign = -1;
                        ++pos;
                    } else if (c == '+') {
                        ++pos;
                    } else if (!Character.isDigit(c)) {
                        throw new NumberFormatException();
                    }
                    state = States.LEADING_ZEROS_MANTISSA;
                    continue block10;
                }
                case LEADING_ZEROS_MANTISSA: {
                    if (c == '0') {
                        ++pos;
                        continue block10;
                    }
                    if (c == '.') {
                        ++pos;
                        state = States.LEADING_ZEROS_FRAC;
                        continue block10;
                    }
                    if (Character.isDigit(c)) {
                        state = States.MANTISSA_INT_PART;
                        continue block10;
                    }
                    if (c == 'e' || c == 'E') {
                        state = States.MANTISSA_FRAC_PART;
                        continue block10;
                    }
                    throw new NumberFormatException();
                }
                case LEADING_ZEROS_FRAC: {
                    if (c == '0') {
                        ++pos;
                        --implicitExponent;
                        continue block10;
                    }
                    if (Character.isDigit(c)) {
                        state = States.MANTISSA_FRAC_PART;
                        continue block10;
                    }
                    throw new NumberFormatException();
                }
                case MANTISSA_INT_PART: {
                    if (c == '.') {
                        ++pos;
                        state = States.MANTISSA_FRAC_PART;
                        continue block10;
                    }
                    if (Character.isDigit(c)) {
                        if (mantisaIncrements < 18) {
                            mantissa = mantissa * 10L + (long)Character.digit(c, 10);
                            mantisaIncrements = (byte)(mantisaIncrements + 1);
                        } else {
                            ++implicitExponent;
                        }
                        ++pos;
                        continue block10;
                    }
                    state = States.MANTISSA_FRAC_PART;
                    continue block10;
                }
                case MANTISSA_FRAC_PART: {
                    if (Character.isDigit(c)) {
                        if (mantisaIncrements < 18) {
                            mantissa = mantissa * 10L + (long)Character.digit(c, 10);
                            --implicitExponent;
                            mantisaIncrements = (byte)(mantisaIncrements + 1);
                        }
                        ++pos;
                        continue block10;
                    }
                    if (c == 'e' || c == 'E') {
                        ++pos;
                        state = States.EXPO_SIGN;
                        continue block10;
                    }
                    throw new NumberFormatException();
                }
                case EXPO_SIGN: {
                    if (c == '-') {
                        expoSign = -1;
                        ++pos;
                    } else if (c == '+') {
                        ++pos;
                    } else if (!Character.isDigit(c)) {
                        throw new NumberFormatException();
                    }
                    state = States.EXPO_LEADING_ZERO;
                    continue block10;
                }
                case EXPO_LEADING_ZERO: {
                    if (c == '0') {
                        ++pos;
                        continue block10;
                    }
                    if (Character.isDigit(c)) {
                        state = States.EXPO;
                        continue block10;
                    }
                    throw new NumberFormatException();
                }
                case EXPO: {
                    if (Character.isDigit(c)) {
                        explicitExponent = explicitExponent * 10 + Character.digit(c, 10);
                        ++pos;
                        continue block10;
                    }
                    throw new NumberFormatException();
                }
            }
        }
        int finalExpo = expoSign * explicitExponent + implicitExponent;
        if (mantissa == 0L) {
            if (sign == -1) {
                return -0.0;
            }
            return 0.0;
        }
        if (finalExpo == 0) {
            return (long)sign * mantissa;
        }
        return (double)sign * ((double)mantissa * Math.pow(10.0, finalExpo));
    }

    private static enum States {
        SIGN,
        LEADING_ZEROS_MANTISSA,
        LEADING_ZEROS_FRAC,
        MANTISSA_INT_PART,
        MANTISSA_FRAC_PART,
        EXPO_SIGN,
        EXPO_LEADING_ZERO,
        EXPO;

    }
}

