/*
 * Decompiled with CFR 0.152.
 */
package jsat.utils.concurrent;

import java.util.concurrent.atomic.AtomicLong;

public final class AtomicDouble {
    private final AtomicLong base = new AtomicLong();

    public AtomicDouble(double value) {
        this.set(value);
    }

    public void set(double val) {
        this.base.set(Double.doubleToRawLongBits(val));
    }

    public double get() {
        return Double.longBitsToDouble(this.base.get());
    }

    public double getAndAdd(double delta) {
        double newVal;
        double orig;
        while (!this.compareAndSet(orig = this.get(), newVal = orig + delta)) {
        }
        return orig;
    }

    public final double addAndGet(double delta) {
        double newVal;
        double orig;
        while (!this.compareAndSet(orig = this.get(), newVal = orig + delta)) {
        }
        return newVal;
    }

    public boolean compareAndSet(double expect, double update) {
        return this.base.compareAndSet(Double.doubleToRawLongBits(expect), Double.doubleToRawLongBits(update));
    }

    public boolean weakCompareAndSet(double expect, double update) {
        return this.base.weakCompareAndSet(Double.doubleToRawLongBits(expect), Double.doubleToRawLongBits(update));
    }

    public String toString() {
        return "" + this.get();
    }
}

