/*
 * Decompiled with CFR 0.152.
 */
package jsat.utils.concurrent;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import jsat.utils.Pair;

public class ConcurrentCacheLRU<K, V> {
    private final ConcurrentHashMap<K, Pair<V, AtomicLong>> cache;
    private final int maxEntries;

    public ConcurrentCacheLRU(int max_entries) {
        this.maxEntries = max_entries;
        this.cache = new ConcurrentHashMap(max_entries);
    }

    public V putIfAbsentAndGet(K key, V value) {
        Pair<V, AtomicLong> pair = this.cache.putIfAbsent(key, new Pair<V, AtomicLong>(value, new AtomicLong(System.currentTimeMillis())));
        this.evictOld();
        if (pair == null) {
            return null;
        }
        return pair.getFirstItem();
    }

    private void evictOld() {
        while (this.cache.size() > this.maxEntries) {
            Object oldest_key = null;
            long oldest_time = Long.MAX_VALUE;
            for (Map.Entry<K, Pair<V, AtomicLong>> entry : this.cache.entrySet()) {
                if (entry.getValue().getSecondItem().get() >= oldest_time) continue;
                oldest_time = entry.getValue().getSecondItem().get();
                oldest_key = entry.getKey();
            }
            if (this.cache.size() <= this.maxEntries) continue;
            this.cache.remove(oldest_key);
        }
    }

    public void put(K key, V value) {
        this.cache.put(key, new Pair<V, AtomicLong>(value, new AtomicLong(System.currentTimeMillis())));
        this.evictOld();
    }

    public V get(K key) {
        Pair<V, AtomicLong> pair = this.cache.get(key);
        if (pair == null) {
            return null;
        }
        pair.getSecondItem().set(System.currentTimeMillis());
        return pair.getFirstItem();
    }
}

