/*
 * Decompiled with CFR 0.152.
 */
package jsat.utils.random;

import java.util.Random;

public class XOR128
extends Random {
    private static final long serialVersionUID = -5218902638864900490L;
    private long x;
    private long y;
    private long z;
    private long w;

    public XOR128() {
    }

    public XOR128(long seed) {
        super(seed);
    }

    @Override
    public synchronized void setSeed(long seed) {
        super.setSeed(seed);
        this.x = super.next(32);
        this.x <<= 32;
        this.x += (long)super.next(32);
        this.y = super.next(32);
        this.y <<= 32;
        this.y += (long)super.next(32);
        this.z = super.next(32);
        this.z <<= 32;
        this.z += (long)super.next(32);
        this.w = super.next(32);
        this.w <<= 32;
        this.w += (long)super.next(32);
    }

    @Override
    protected int next(int bits) {
        return (int)(this.nextLong() >>> 64 - bits);
    }

    @Override
    public long nextLong() {
        long t = this.x ^ this.x << 11;
        this.x = this.y;
        this.y = this.z;
        this.z = this.w;
        this.w = this.w ^ this.w >>> 19 ^ (t ^ t >>> 8);
        return this.w;
    }

    @Override
    public double nextDouble() {
        long l = this.nextLong() >>> 11;
        return (double)l / 9.007199254740992E15;
    }
}

