/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.jideoss.ui;

import com.formdev.flatlaf.FlatClientProperties;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.UIScale;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.BasicJideTabbedPaneUI;
import com.jidesoft.swing.JideTabbedPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;

public class FlatJideTabbedPaneUI
extends BasicJideTabbedPaneUI {
    protected Color underlineColor;
    protected Color disabledUnderlineColor;
    protected Color hoverColor;
    protected Color focusColor;
    protected Color contentAreaColor;
    protected int tabHeight;
    protected int tabSelectionHeight;
    protected int contentSeparatorHeight;
    protected boolean hasFullBorder;
    protected boolean tabsOverlapBorder;

    public static ComponentUI createUI(JComponent c) {
        return new FlatJideTabbedPaneUI();
    }

    protected void installDefaults() {
        super.installDefaults();
        this._background = UIDefaultsLookup.getColor((Object)"JideTabbedPane.background");
        this.underlineColor = UIManager.getColor("TabbedPane.underlineColor");
        this.disabledUnderlineColor = UIManager.getColor("TabbedPane.disabledUnderlineColor");
        this.hoverColor = UIManager.getColor("TabbedPane.hoverColor");
        this.focusColor = UIManager.getColor("TabbedPane.focusColor");
        this.contentAreaColor = UIManager.getColor("TabbedPane.contentAreaColor");
        this.tabHeight = UIManager.getInt("TabbedPane.tabHeight");
        this.tabSelectionHeight = UIManager.getInt("TabbedPane.tabSelectionHeight");
        this.contentSeparatorHeight = UIManager.getInt("TabbedPane.contentSeparatorHeight");
        this.hasFullBorder = UIManager.getBoolean("TabbedPane.hasFullBorder");
        this.tabsOverlapBorder = UIManager.getBoolean("TabbedPane.tabsOverlapBorder");
        this._textIconGap = UIScale.scale((int)this._textIconGap);
        this.tabHeight = UIScale.scale((int)this.tabHeight);
        this.tabSelectionHeight = UIScale.scale((int)this.tabSelectionHeight);
    }

    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this.underlineColor = null;
        this.disabledUnderlineColor = null;
        this.hoverColor = null;
        this.focusColor = null;
        this.contentAreaColor = null;
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new BasicJideTabbedPaneUI.PropertyChangeHandler(){

            public void propertyChange(PropertyChangeEvent e) {
                super.propertyChange(e);
                String propertyName = e.getPropertyName();
                if ("selectedIndex".equals(propertyName)) {
                    FlatJideTabbedPaneUI.this.repaintTab((Integer)e.getOldValue());
                    FlatJideTabbedPaneUI.this.repaintTab((Integer)e.getNewValue());
                } else if ("JTabbedPane.hasFullBorder".equals(propertyName)) {
                    FlatJideTabbedPaneUI.this._tabPane.revalidate();
                    FlatJideTabbedPaneUI.this._tabPane.repaint();
                }
            }
        };
    }

    private void repaintTab(int tabIndex) {
        if (tabIndex < 0 || tabIndex >= this._tabPane.getTabCount()) {
            return;
        }
        Rectangle r = this.getTabBounds((JTabbedPane)this._tabPane, tabIndex);
        if (r != null) {
            this._tabPane.repaint(r);
        }
    }

    protected MouseListener createMouseListener() {
        return new BasicJideTabbedPaneUI.RolloverMouseHandler((BasicJideTabbedPaneUI)this);
    }

    protected MouseMotionListener createMouseMotionListener() {
        return new BasicJideTabbedPaneUI.RolloverMouseMotionHandler((BasicJideTabbedPaneUI)this);
    }

    protected int calculateTabHeight(int tabPlacement, int tabIndex, FontMetrics metrics) {
        return Math.max(this.tabHeight, super.calculateTabHeight(tabPlacement, tabIndex, metrics));
    }

    protected int calculateTabWidth(int tabPlacement, int tabIndex, FontMetrics metrics) {
        return Math.max(this.tabHeight, super.calculateTabWidth(tabPlacement, tabIndex, metrics));
    }

    protected Insets getTabInsets(int tabPlacement, int tabIndex) {
        return UIScale.scale((Insets)super.getTabInsets(tabPlacement, tabIndex));
    }

    protected Insets getSelectedTabPadInsets(int tabPlacement) {
        return UIScale.scale((Insets)super.getSelectedTabPadInsets(tabPlacement));
    }

    protected Insets getTabAreaInsets(int tabPlacement) {
        return UIScale.scale((Insets)super.getTabAreaInsets(tabPlacement));
    }

    protected int getTabShape() {
        return 3;
    }

    protected Insets getContentBorderInsets(int tabPlacement) {
        return FlatUIUtils.addInsets((Insets)this.getContentBorderInsets0(tabPlacement), (Insets)UIScale.scale((Insets)super.getContentBorderInsets(tabPlacement)));
    }

    private Insets getContentBorderInsets0(int tabPlacement) {
        boolean hasFullBorder = FlatClientProperties.clientPropertyBoolean((JComponent)this._tabPane, (String)"JTabbedPane.hasFullBorder", (boolean)this.hasFullBorder);
        int sh = UIScale.scale((int)this.contentSeparatorHeight);
        Insets insets = hasFullBorder ? new Insets(sh, sh, sh, sh) : new Insets(sh, 0, 0, 0);
        Insets contentBorderInsets = new Insets(0, 0, 0, 0);
        FlatJideTabbedPaneUI.rotateInsets((Insets)insets, (Insets)contentBorderInsets, (int)tabPlacement);
        return contentBorderInsets;
    }

    public void update(Graphics g, JComponent c) {
        FlatUIUtils.setRenderingHints((Graphics2D)((Graphics2D)g));
        super.update(g, c);
    }

    public void paint(Graphics g, JComponent c) {
        super.paint(g, c);
        if (!this.scrollableTabLayoutEnabled() && this._tabPane.getTabCount() > 0) {
            this.paintTabArea(g, this._tabPane.getTabPlacement(), this._tabPane.getSelectedIndex(), c);
        }
    }

    protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        boolean enabled = this._tabPane.isEnabled();
        g.setColor(enabled && this._tabPane.isEnabledAt(tabIndex) && (this._indexMouseOver == tabIndex || this._closeButtons != null && ((JideTabbedPane.NoFocusButton)this._closeButtons[tabIndex]).isMouseOver()) ? this.hoverColor : (enabled && isSelected && FlatUIUtils.isPermanentFocusOwner((Component)this._tabPane) ? this.focusColor : this._tabPane.getBackgroundAt(tabIndex)));
        g.fillRect(x, y, w, h);
    }

    protected void paintTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        if (isSelected) {
            this.paintTabSelection(g, tabPlacement, x, y, w, h);
        }
    }

    protected void paintTabSelection(Graphics g, int tabPlacement, int x, int y, int w, int h) {
        Rectangle clipBounds;
        Rectangle rectangle = clipBounds = this.scrollableTabLayoutEnabled() ? g.getClipBounds() : null;
        if (clipBounds != null) {
            Rectangle newClipBounds = new Rectangle(clipBounds);
            int contentSeparatorHeight = UIScale.scale((int)this.contentSeparatorHeight);
            switch (tabPlacement) {
                default: {
                    newClipBounds.height += contentSeparatorHeight;
                    break;
                }
                case 3: {
                    newClipBounds.y -= contentSeparatorHeight;
                    newClipBounds.height += contentSeparatorHeight;
                    break;
                }
                case 2: {
                    newClipBounds.width += contentSeparatorHeight;
                    break;
                }
                case 4: {
                    newClipBounds.x -= contentSeparatorHeight;
                    newClipBounds.width += contentSeparatorHeight;
                }
            }
            g.setClip(newClipBounds);
        }
        g.setColor(this._tabPane.isEnabled() ? this.underlineColor : this.disabledUnderlineColor);
        Insets contentInsets = this.getContentBorderInsets0(tabPlacement);
        switch (tabPlacement) {
            default: {
                int sy = y + h + contentInsets.top - this.tabSelectionHeight;
                g.fillRect(x, sy, w, this.tabSelectionHeight);
                break;
            }
            case 3: {
                g.fillRect(x, y - contentInsets.bottom, w, this.tabSelectionHeight);
                break;
            }
            case 2: {
                int sx = x + w + contentInsets.left - this.tabSelectionHeight;
                g.fillRect(sx, y, this.tabSelectionHeight, h);
                break;
            }
            case 4: {
                g.fillRect(x - contentInsets.right, y, this.tabSelectionHeight, h);
            }
        }
        if (clipBounds != null) {
            g.setClip(clipBounds);
        }
    }

    protected void paintContentBorder(Graphics g, int tabPlacement, int selectedIndex) {
        if (this._tabPane.getTabCount() <= 0) {
            return;
        }
        Insets insets = this._tabPane.getInsets();
        Insets tabAreaInsets = this.getTabAreaInsets(tabPlacement);
        int x = insets.left;
        int y = insets.top;
        int w = this._tabPane.getWidth() - insets.right - insets.left;
        int h = this._tabPane.getHeight() - insets.top - insets.bottom;
        Dimension lsize = this.isTabLeadingComponentVisible() ? this._tabLeadingComponent.getPreferredSize() : new Dimension();
        Dimension tsize = this.isTabTrailingComponentVisible() ? this._tabTrailingComponent.getPreferredSize() : new Dimension();
        switch (tabPlacement) {
            case 2: {
                x += Math.max(this.calculateTabAreaWidth(tabPlacement, this._runCount, this._maxTabWidth), Math.max(lsize.width, tsize.width));
                if (this.tabsOverlapBorder) {
                    x -= tabAreaInsets.right;
                }
                w -= x - insets.left;
                break;
            }
            case 4: {
                w -= this.calculateTabAreaWidth(tabPlacement, this._runCount, this._maxTabWidth);
                if (!this.tabsOverlapBorder) break;
                w += tabAreaInsets.left;
                break;
            }
            case 3: {
                h -= this.calculateTabAreaHeight(tabPlacement, this._runCount, this._maxTabHeight);
                if (!this.tabsOverlapBorder) break;
                h += tabAreaInsets.top;
                break;
            }
            default: {
                y += Math.max(this.calculateTabAreaHeight(tabPlacement, this._runCount, this._maxTabHeight), Math.max(lsize.height, tsize.height));
                if (this.tabsOverlapBorder) {
                    y -= tabAreaInsets.bottom;
                }
                h -= y - insets.top;
            }
        }
        boolean hasFullBorder = FlatClientProperties.clientPropertyBoolean((JComponent)this._tabPane, (String)"JTabbedPane.hasFullBorder", (boolean)this.hasFullBorder);
        int sh = UIScale.scale((int)(this.contentSeparatorHeight * 100));
        Insets ci = new Insets(0, 0, 0, 0);
        FlatJideTabbedPaneUI.rotateInsets((Insets)(hasFullBorder ? new Insets(sh, sh, sh, sh) : new Insets(sh, 0, 0, 0)), (Insets)ci, (int)tabPlacement);
        g.setColor(this.contentAreaColor);
        Path2D.Float path = new Path2D.Float(0);
        path.append(new Rectangle2D.Float(x, y, w, h), false);
        path.append(new Rectangle2D.Float((float)x + (float)ci.left / 100.0f, (float)y + (float)ci.top / 100.0f, (float)w - (float)ci.left / 100.0f - (float)ci.right / 100.0f, (float)h - (float)ci.top / 100.0f - (float)ci.bottom / 100.0f), false);
        ((Graphics2D)g).fill(path);
        if (this.scrollableTabLayoutEnabled() && selectedIndex >= 0 && this._tabScroller != null && this._tabScroller.viewport != null) {
            Rectangle tabRect = this.getTabBounds((JTabbedPane)this._tabPane, selectedIndex);
            Shape oldClip = g.getClip();
            g.setClip(this._tabScroller.viewport.getBounds());
            this.paintTabSelection(g, tabPlacement, tabRect.x, tabRect.y, tabRect.width, tabRect.height);
            g.setClip(oldClip);
        }
    }

    protected void paintFocusIndicator(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
    }
}

