/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rtree.fbs;

import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.rtree.Entries;
import com.github.davidmoten.rtree.Entry;
import com.github.davidmoten.rtree.fbs.generated.Bounds_;
import com.github.davidmoten.rtree.fbs.generated.BoxDouble_;
import com.github.davidmoten.rtree.fbs.generated.BoxFloat_;
import com.github.davidmoten.rtree.fbs.generated.CircleDouble_;
import com.github.davidmoten.rtree.fbs.generated.CircleFloat_;
import com.github.davidmoten.rtree.fbs.generated.Entry_;
import com.github.davidmoten.rtree.fbs.generated.Geometry_;
import com.github.davidmoten.rtree.fbs.generated.LineDouble_;
import com.github.davidmoten.rtree.fbs.generated.LineFloat_;
import com.github.davidmoten.rtree.fbs.generated.Node_;
import com.github.davidmoten.rtree.fbs.generated.PointDouble_;
import com.github.davidmoten.rtree.fbs.generated.PointFloat_;
import com.github.davidmoten.rtree.geometry.Circle;
import com.github.davidmoten.rtree.geometry.Geometries;
import com.github.davidmoten.rtree.geometry.Geometry;
import com.github.davidmoten.rtree.geometry.Line;
import com.github.davidmoten.rtree.geometry.Point;
import com.github.davidmoten.rtree.geometry.Rectangle;
import com.github.davidmoten.rtree.internal.Util;
import com.google.flatbuffers.FlatBufferBuilder;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import rx.functions.Func1;

final class FlatBuffersHelper {
    private FlatBuffersHelper() {
    }

    static <T, S extends Geometry> int addEntries(List<Entry<T, S>> entries, FlatBufferBuilder builder, Func1<? super T, byte[]> serializer) {
        int b;
        int[] entries2 = new int[entries.size()];
        for (int i = 0; i < entries.size(); ++i) {
            Geometry c;
            int geomType;
            int geom;
            S g = entries.get(i).geometry();
            if (g instanceof Point) {
                Point p = (Point)g;
                if (p.isDoublePrecision()) {
                    geom = PointDouble_.createPointDouble_(builder, p.x(), p.y());
                    geomType = 4;
                } else {
                    geom = PointFloat_.createPointFloat_(builder, (float)p.x(), (float)p.y());
                    geomType = 0;
                }
            } else if (g instanceof Rectangle) {
                Rectangle b2 = (Rectangle)g;
                if (b2.isDoublePrecision()) {
                    geom = BoxDouble_.createBoxDouble_(builder, b2.x1(), b2.y1(), b2.x2(), b2.y2());
                    geomType = 5;
                } else {
                    geom = BoxFloat_.createBoxFloat_(builder, (float)b2.x1(), (float)b2.y1(), (float)b2.x2(), (float)b2.y2());
                    geomType = 1;
                }
            } else if (g instanceof Circle) {
                c = (Circle)g;
                if (c.isDoublePrecision()) {
                    geom = CircleDouble_.createCircleDouble_(builder, c.x(), c.y(), c.radius());
                    geomType = 6;
                } else {
                    geom = CircleFloat_.createCircleFloat_(builder, (float)c.x(), (float)c.y(), (float)c.radius());
                    geomType = 2;
                }
            } else if (g instanceof Line) {
                c = (Line)g;
                if (c.isDoublePrecision()) {
                    geom = LineDouble_.createLineDouble_(builder, c.x1(), c.y1(), c.x2(), c.y2());
                    geomType = 7;
                } else {
                    geom = LineFloat_.createLineFloat_(builder, (float)c.x1(), (float)c.y1(), (float)c.x2(), (float)c.y2());
                    geomType = 3;
                }
            } else {
                throw new RuntimeException("unexpected");
            }
            Geometry_.startGeometry_(builder);
            if (geomType == 1) {
                Geometry_.addBoxFloat(builder, geom);
            } else if (geomType == 5) {
                Geometry_.addBoxDouble(builder, geom);
            } else if (geomType == 0) {
                Geometry_.addPointFloat(builder, geom);
            } else if (geomType == 4) {
                Geometry_.addPointDouble(builder, geom);
            } else if (geomType == 2) {
                Geometry_.addCircleFloat(builder, geom);
            } else if (geomType == 6) {
                Geometry_.addCircleDouble(builder, geom);
            } else if (geomType == 3) {
                Geometry_.addLineFloat(builder, geom);
            } else if (geomType == 7) {
                Geometry_.addLineDouble(builder, geom);
            } else {
                throw new RuntimeException("unexpected");
            }
            Geometry_.addType(builder, (byte)geomType);
            int geo = Geometry_.endGeometry_(builder);
            int obj = Entry_.createObjectVector(builder, (byte[])serializer.call(entries.get(i).value()));
            entries2[i] = Entry_.createEntry_(builder, geo, obj);
        }
        int ents = Node_.createEntriesVector(builder, entries2);
        Rectangle mbb = Util.mbr(entries);
        Bounds_.startBounds_(builder);
        if (mbb.isDoublePrecision()) {
            b = BoxDouble_.createBoxDouble_(builder, mbb.x1(), mbb.y1(), mbb.x2(), mbb.y2());
            Bounds_.addBoxDouble(builder, b);
            Bounds_.addType(builder, (byte)1);
        } else {
            b = BoxFloat_.createBoxFloat_(builder, (float)mbb.x1(), (float)mbb.y1(), (float)mbb.x2(), (float)mbb.y2());
            Bounds_.addBoxFloat(builder, b);
            Bounds_.addType(builder, (byte)0);
        }
        int bounds = Bounds_.endBounds_(builder);
        Node_.startNode_(builder);
        Node_.addMbb(builder, bounds);
        Node_.addEntries(builder, ents);
        return Node_.endNode_(builder);
    }

    static <T, S extends Geometry> List<Entry<T, S>> createEntries(Node_ node, Func1<byte[], ? extends T> deserializer) {
        int numEntries = node.entriesLength();
        ArrayList<Entry<T, S>> entries = new ArrayList<Entry<T, S>>(numEntries);
        Preconditions.checkArgument((numEntries > 0 ? 1 : 0) != 0);
        Entry_ entry = new Entry_();
        Geometry_ geom = new Geometry_();
        for (int i = 0; i < numEntries; ++i) {
            Entry<? extends T, S> ent = FlatBuffersHelper.createEntry(node, deserializer, entry, geom, i);
            entries.add(ent);
        }
        return entries;
    }

    private static <T, S extends Geometry> Entry<T, S> createEntry(Node_ node, Func1<byte[], ? extends T> deserializer, Entry_ entry, Geometry_ geom, int i) {
        node.entries(entry, i);
        entry.geometry(geom);
        S g = FlatBuffersHelper.toGeometry(geom);
        return Entries.entry(FlatBuffersHelper.parseObject(deserializer, entry), g);
    }

    static <T, S extends Geometry> Entry<T, S> createEntry(Node_ node, Func1<byte[], ? extends T> deserializer, int i) {
        return FlatBuffersHelper.createEntry(node, deserializer, new Entry_(), new Geometry_(), i);
    }

    static <T> T parseObject(Func1<byte[], ? extends T> deserializer, Entry_ entry) {
        ByteBuffer bb = entry.objectAsByteBuffer();
        if (bb == null) {
            return null;
        }
        byte[] bytes = Arrays.copyOfRange(bb.array(), bb.position(), bb.limit());
        Object t = deserializer.call((Object)bytes);
        return (T)t;
    }

    static <S extends Geometry> S toGeometry(Geometry_ g) {
        Geometry result;
        byte type = g.type();
        if (type == 1) {
            result = FlatBuffersHelper.createBox(g.boxFloat());
        } else if (type == 5) {
            result = FlatBuffersHelper.createBox(g.boxDouble());
        } else if (type == 0) {
            PointFloat_ p = g.pointFloat();
            result = Geometries.point(p.x(), p.y());
        } else if (type == 4) {
            PointDouble_ p = g.pointDouble();
            result = Geometries.point(p.x(), p.y());
        } else if (type == 2) {
            CircleFloat_ c = g.circleFloat();
            result = Geometries.circle(c.x(), c.y(), c.radius());
        } else if (type == 6) {
            CircleDouble_ c = g.circleDouble();
            result = Geometries.circle(c.x(), c.y(), c.radius());
        } else if (type == 3) {
            result = FlatBuffersHelper.createLine(g.lineFloat());
        } else if (type == 7) {
            result = FlatBuffersHelper.createLine(g.lineDouble());
        } else {
            throw new RuntimeException("unexpected");
        }
        return (S)result;
    }

    private static Geometry createBox(BoxDouble_ b) {
        return Geometries.rectangle(b.minX(), b.minY(), b.maxX(), b.maxY());
    }

    private static Geometry createBox(BoxFloat_ b) {
        return Geometries.rectangle(b.minX(), b.minY(), b.maxX(), b.maxY());
    }

    static Rectangle createBox(Bounds_ b) {
        if (b.type() == 1) {
            BoxDouble_ r = b.boxDouble();
            return Geometries.rectangle(r.minX(), r.minY(), r.maxX(), r.maxY());
        }
        BoxFloat_ r = b.boxFloat();
        return Geometries.rectangle(r.minX(), r.minY(), r.maxX(), r.maxY());
    }

    static Line createLine(BoxFloat_ b) {
        return Geometries.line(b.minX(), b.minY(), b.maxX(), b.maxY());
    }

    static Line createLine(BoxDouble_ b) {
        return Geometries.line(b.minX(), b.minY(), b.maxX(), b.maxY());
    }
}

