/*
 * Decompiled with CFR 0.152.
 */
package com.github.fracpete.bootstrapp.core;

import com.github.fracpete.bootstrapp.core.ZipUtils;
import com.github.fracpete.requests4j.Requests;
import com.github.fracpete.requests4j.response.FileResponse;
import com.github.fracpete.requests4j.response.Response;
import com.github.fracpete.resourceextractor4j.Content;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.SystemUtils;

public class Maven {
    public static final String HOME_DIR_ENV = "BOOTSTRAPP_HOME";
    public static final String URL_FILE = "apache-maven.url";
    public static final String DIR_FILE = "apache-maven.dir";
    public static final String EXECUTABLES_FILE = "apache-maven.executables";
    protected static String VERSION = null;
    protected static String HOMEDIR = null;
    protected static Logger LOGGER = Logger.getLogger(Maven.class.getName());

    public static synchronized String version() {
        if (VERSION == null) {
            List lines = Content.readLines((String)"com/github/fracpete/bootstrapp/apache-maven.dir");
            VERSION = lines != null && lines.size() > 0 ? (String)lines.get(0) : "unknown";
        }
        return VERSION;
    }

    public static synchronized String homeDir() {
        if (HOMEDIR == null) {
            String dir;
            if (System.getenv(HOME_DIR_ENV) != null) {
                dir = System.getenv(HOME_DIR_ENV);
            } else {
                dir = System.getProperty("user.home");
                if (!SystemUtils.IS_OS_WINDOWS) {
                    dir = dir + "/.local/share";
                }
                dir = dir + "/bootstrapp/" + Maven.version();
            }
            HOMEDIR = dir;
        }
        return HOMEDIR;
    }

    public static String initRemoteMaven() {
        File dir = new File(Maven.homeDir());
        if (dir.exists() && dir.isDirectory()) {
            return null;
        }
        String res = "com/github/fracpete/bootstrapp/apache-maven.url";
        String url = Content.readString((String)res);
        if (url == null) {
            return "Failed to read URL from resource: " + res;
        }
        url = url.trim();
        res = "com/github/fracpete/bootstrapp/apache-maven.dir";
        String dirname = Content.readString((String)res);
        if (dirname == null) {
            return "Failed to read directory from resource: " + res;
        }
        dirname = dirname.trim();
        String tmpFile = System.getProperty("java.io.tmpdir") + File.separator + "maven.zip";
        try {
            LOGGER.info("Downloading Maven from: " + url);
            FileResponse r = (FileResponse)Requests.get((String)url).allowRedirects(true).execute((Response)new FileResponse(tmpFile, 0x100000));
            if (r.ok()) {
                LOGGER.info("Finished downloading Maven.");
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to download Maven from:\n" + url + "\nto:\n" + tmpFile, e);
            return "Failed to download Maven from:\n" + url + "\nto:\n" + tmpFile;
        }
        List<String> lines = new ArrayList<String>();
        ZipUtils.decompress(new File(tmpFile), dir.getParentFile(), true, 0x100000, lines);
        if (!lines.isEmpty()) {
            StringBuilder error = new StringBuilder();
            for (String e : lines) {
                if (error.length() > 0) {
                    error.append("\n");
                }
                error.append(e);
            }
            return error.toString();
        }
        if (!SystemUtils.IS_OS_WINDOWS) {
            res = "com/github/fracpete/bootstrapp/apache-maven.executables";
            lines = Content.readLines((String)res);
            if (lines == null) {
                return "Failed to read executable files from: " + res;
            }
            for (String line : lines) {
                File file = new File(Maven.homeDir() + "/" + line);
                file.setExecutable(true);
            }
        }
        return null;
    }
}

