/*
 * Decompiled with CFR 0.152.
 */
package com.github.fracpete.bootstrapp.core;

import com.github.fracpete.resourceextractor4j.IOUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;

public class ZipUtils {
    protected static Logger LOGGER = Logger.getLogger(ZipUtils.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<File> decompress(File input, File outputDir, boolean createDirs, int bufferSize, List<String> errors) {
        ArrayList<File> result = new ArrayList<File>();
        ZipFile archive = null;
        try {
            byte[] buffer = new byte[bufferSize];
            archive = new ZipFile(input.getAbsoluteFile());
            Enumeration enm = archive.getEntries();
            while (enm.hasMoreElements()) {
                FileOutputStream fos;
                BufferedOutputStream out;
                BufferedInputStream in;
                block23: {
                    block22: {
                        String msg;
                        File outFile;
                        ZipArchiveEntry entry = (ZipArchiveEntry)enm.nextElement();
                        if (entry.isDirectory() && !createDirs) continue;
                        if (entry.isDirectory() && createDirs) {
                            outFile = new File(outputDir.getAbsolutePath() + File.separator + entry.getName());
                            if (outFile.mkdirs()) continue;
                            msg = "Failed to create directory '" + outFile.getAbsolutePath() + "'!";
                            LOGGER.log(Level.SEVERE, msg);
                            errors.add(msg);
                            continue;
                        }
                        in = null;
                        out = null;
                        fos = null;
                        String outName = null;
                        try {
                            int len;
                            outName = outputDir.getAbsolutePath() + File.separator;
                            outName = createDirs ? outName + entry.getName() : outName + new File(entry.getName()).getName();
                            outFile = new File(outName).getParentFile();
                            if (!outFile.exists() && !outFile.mkdirs()) {
                                msg = "Failed to create directory '" + outFile.getAbsolutePath() + "', skipping extraction of '" + outName + "'!";
                                LOGGER.log(Level.SEVERE, msg);
                                errors.add(msg);
                                IOUtils.closeQuietly((InputStream)in);
                                break block22;
                            }
                            in = new BufferedInputStream(archive.getInputStream(entry));
                            fos = new FileOutputStream(outName);
                            out = new BufferedOutputStream(fos, bufferSize);
                            for (long read = 0L; read < entry.getSize(); read += (long)len) {
                                len = in.read(buffer);
                                out.write(buffer, 0, len);
                            }
                            result.add(new File(outName));
                            IOUtils.closeQuietly((InputStream)in);
                            break block23;
                        }
                        catch (Exception e) {
                            msg = "Error extracting '" + entry.getName() + "' to '" + outName + "': ";
                            LOGGER.log(Level.SEVERE, msg, e);
                            errors.add(msg + "\n" + e);
                            continue;
                        }
                    }
                    IOUtils.closeQuietly((OutputStream)out);
                    IOUtils.closeQuietly((OutputStream)fos);
                    continue;
                }
                IOUtils.closeQuietly((OutputStream)out);
                IOUtils.closeQuietly((OutputStream)fos);
                continue;
                finally {
                    IOUtils.closeQuietly(in);
                    IOUtils.closeQuietly(out);
                    IOUtils.closeQuietly(fos);
                }
            }
            return result;
        }
        catch (Exception e) {
            String msg = "Error occurred: ";
            LOGGER.log(Level.SEVERE, msg, e);
            errors.add(msg + "\n" + e);
            return result;
        }
        finally {
            if (archive != null) {
                try {
                    archive.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

