/*
 * Decompiled with CFR 0.152.
 */
package com.github.fracpete.bootstrapp;

import com.github.fracpete.bootstrapp.core.Maven;
import com.github.fracpete.bootstrapp.core.Template;
import com.github.fracpete.processoutput4j.core.StreamingProcessOwner;
import com.github.fracpete.processoutput4j.core.impl.SimpleStreamingProcessOwner;
import com.github.fracpete.processoutput4j.output.StreamingProcessOutput;
import com.github.fracpete.resourceextractor4j.Content;
import com.github.fracpete.simpleargparse4j.ArgumentParser;
import com.github.fracpete.simpleargparse4j.ArgumentParserException;
import com.github.fracpete.simpleargparse4j.Namespace;
import com.github.fracpete.simpleargparse4j.Option;
import java.io.File;
import java.io.FilenameFilter;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationRequest;

public class Main {
    protected File m_MavenHome;
    protected transient File m_ActMavenHome;
    protected File m_MavenUserSettings;
    protected File m_JavaHome;
    protected transient File m_ActJavaHome;
    protected File m_OutputDir;
    protected File m_OutputDirMaven;
    protected List<String> m_JVM;
    protected List<String> m_Dependencies;
    protected List<File> m_DependencyFiles;
    protected List<File> m_ExternalJars;
    protected List<String> m_Exclusions;
    protected List<String> m_Repositories;
    protected File m_PomTemplate;
    protected transient File m_ActPomTemplate;
    protected String m_Name;
    protected String m_Version;
    protected boolean m_Clean;
    protected String m_MainClass;
    protected boolean m_Sources;
    protected List<File> m_ExternalSources;
    protected boolean m_Scripts;
    protected boolean m_SpringBoot;
    protected boolean m_Debian;
    protected File m_DebianSnippet;
    protected boolean m_Redhat;
    protected File m_RedhatSnippet;
    protected boolean m_Docker;
    protected String m_DockerBaseImage;
    protected File m_DockerSnippet;
    protected boolean m_Launch;
    protected boolean m_CompressDirStructure;
    protected Logger m_Logger;
    protected boolean m_HelpRequested;

    public Main() {
        this.initialize();
    }

    protected void initialize() {
        this.m_MavenHome = null;
        this.m_MavenUserSettings = null;
        this.m_JavaHome = null;
        this.m_OutputDir = null;
        this.m_OutputDirMaven = null;
        this.m_JVM = null;
        this.m_Dependencies = null;
        this.m_DependencyFiles = null;
        this.m_ExternalJars = null;
        this.m_Exclusions = null;
        this.m_Repositories = null;
        this.m_PomTemplate = null;
        this.m_Name = "bootstrapp-harness";
        this.m_Version = "0.0.1";
        this.m_Clean = false;
        this.m_Sources = false;
        this.m_ExternalSources = null;
        this.m_Scripts = false;
        this.m_Launch = false;
        this.m_SpringBoot = false;
        this.m_Debian = false;
        this.m_DebianSnippet = null;
        this.m_Redhat = false;
        this.m_RedhatSnippet = null;
        this.m_Docker = false;
        this.m_DockerBaseImage = null;
        this.m_DockerSnippet = null;
        this.m_CompressDirStructure = false;
        this.m_Logger = null;
        this.m_HelpRequested = false;
    }

    protected Logger getLogger() {
        if (this.m_Logger == null) {
            this.m_Logger = Logger.getLogger(this.getClass().getName());
        }
        return this.m_Logger;
    }

    public Main mavenHome(File dir) {
        this.m_MavenHome = dir;
        return this;
    }

    public File getMavenHome() {
        return this.m_MavenHome;
    }

    public Main mavenUserSettings(File dir) {
        this.m_MavenUserSettings = dir;
        return this;
    }

    public File getMavenUserSettings() {
        return this.m_MavenUserSettings;
    }

    public Main javaHome(File dir) {
        this.m_JavaHome = dir;
        return this;
    }

    public File getJavaHome() {
        return this.m_JavaHome;
    }

    public Main outputDir(File dir) {
        this.m_OutputDir = dir;
        return this;
    }

    public File getOutputDir() {
        return this.m_OutputDir;
    }

    public Main name(String name) {
        this.m_Name = name;
        return this;
    }

    public String getName() {
        return this.m_Name;
    }

    public Main version(String version) {
        this.m_Version = version;
        return this;
    }

    public String getVersion() {
        return this.m_Version;
    }

    public Main dependencies(List<String> dependencies) {
        this.m_Dependencies = dependencies;
        return this;
    }

    public Main dependencies(String ... dependencies) {
        this.m_Dependencies = dependencies != null ? new ArrayList<String>(Arrays.asList(dependencies)) : null;
        return this;
    }

    public List<String> getDependencies() {
        return this.m_Dependencies;
    }

    public Main dependencyFiles(List<File> files) {
        this.m_DependencyFiles = files;
        return this;
    }

    public Main dependencyFiles(File ... files) {
        this.m_DependencyFiles = files != null ? new ArrayList<File>(Arrays.asList(files)) : null;
        return this;
    }

    public List<File> getDependencyFiles() {
        return this.m_DependencyFiles;
    }

    public List<String> getAllDependencies() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.m_Dependencies != null) {
            result.addAll(this.m_Dependencies);
        }
        if (this.m_DependencyFiles != null) {
            for (File depFile : this.m_DependencyFiles) {
                try {
                    this.getLogger().info("Reading dependency file: " + depFile);
                    List<String> lines = Files.readAllLines(depFile.toPath());
                    for (String line : lines) {
                        if ((line = line.trim()).isEmpty() || !line.contains(":")) continue;
                        result.add(line);
                    }
                }
                catch (Exception e) {
                    this.getLogger().log(Level.SEVERE, "Failed to read dependency file: " + depFile, e);
                }
            }
        }
        return result;
    }

    public Main externalJars(List<File> external) {
        this.m_ExternalJars = external;
        return this;
    }

    public Main externalJars(File ... external) {
        if (external == null) {
            this.m_ExternalJars = null;
        } else {
            this.externalJars(Arrays.asList(external));
        }
        return this;
    }

    public List<File> getExternalJars() {
        return this.m_ExternalJars;
    }

    public Main exclusions(List<String> exclusions) {
        this.m_Exclusions = exclusions;
        return this;
    }

    public Main exclusions(String ... exclusions) {
        this.m_Exclusions = exclusions != null ? new ArrayList<String>(Arrays.asList(exclusions)) : null;
        return this;
    }

    public List<String> getExclusions() {
        return this.m_Exclusions;
    }

    public Main repositories(List<String> repositories) {
        this.m_Repositories = repositories;
        return this;
    }

    public Main repositories(String ... repositories) {
        this.m_Repositories = repositories != null ? new ArrayList<String>(Arrays.asList(repositories)) : null;
        return this;
    }

    public List<String> getRepositories() {
        return this.m_Repositories;
    }

    public Main clean(boolean clean) {
        this.m_Clean = clean;
        return this;
    }

    public boolean getClean() {
        return this.m_Clean;
    }

    public Main sources(boolean sources) {
        this.m_Sources = sources;
        return this;
    }

    public boolean getSources() {
        return this.m_Sources;
    }

    public Main externalSources(List<File> external) {
        this.m_ExternalSources = external;
        return this;
    }

    public Main externalSources(File ... external) {
        if (external == null) {
            this.m_ExternalSources = null;
        } else {
            this.externalSources(Arrays.asList(external));
        }
        return this;
    }

    public List<File> getExternalSources() {
        return this.m_ExternalSources;
    }

    public Main pomTemplate(File template) {
        this.m_PomTemplate = template;
        return this;
    }

    public File getPomTemplate() {
        return this.m_PomTemplate;
    }

    public Main jvm(List<String> options) {
        this.m_JVM = options;
        return this;
    }

    public Main jvm(String ... options) {
        this.m_JVM = options != null ? new ArrayList<String>(Arrays.asList(options)) : null;
        return this;
    }

    public List<String> getJvm() {
        return this.m_JVM;
    }

    public Main mainClass(String dir) {
        this.m_MainClass = dir;
        return this;
    }

    public String getMainClass() {
        return this.m_MainClass;
    }

    public Main scripts(boolean scripts) {
        this.m_Scripts = scripts;
        return this;
    }

    public boolean getScripts() {
        return this.m_Scripts;
    }

    public Main springBoot(boolean springBoot) {
        this.m_SpringBoot = springBoot;
        return this;
    }

    public boolean getSpringBoot() {
        return this.m_SpringBoot;
    }

    public Main debian(boolean debian) {
        this.m_Debian = debian;
        return this;
    }

    public boolean getDebian() {
        return this.m_Debian;
    }

    public Main debianSnippet(File snippet) {
        this.m_DebianSnippet = snippet;
        return this;
    }

    public File getDebianSnippet() {
        return this.m_DebianSnippet;
    }

    public Main redhat(boolean redhat) {
        this.m_Redhat = redhat;
        return this;
    }

    public boolean getRedhat() {
        return this.m_Redhat;
    }

    public Main redhatSnippet(File snippet) {
        this.m_RedhatSnippet = snippet;
        return this;
    }

    public File getRedhatSnippet() {
        return this.m_RedhatSnippet;
    }

    public Main docker(boolean docker) {
        this.m_Docker = docker;
        return this;
    }

    public boolean getDocker() {
        return this.m_Docker;
    }

    public Main dockerBaseImage(String image) {
        this.m_DockerBaseImage = image;
        return this;
    }

    public String getDockerBaseImage() {
        return this.m_DockerBaseImage;
    }

    public Main dockerSnippet(File snippet) {
        this.m_DockerSnippet = snippet;
        return this;
    }

    public File getDockerSnippet() {
        return this.m_DockerSnippet;
    }

    public Main compressDirStructure(boolean compress) {
        this.m_CompressDirStructure = compress;
        return this;
    }

    public boolean getCompressDirStructure() {
        return this.m_CompressDirStructure;
    }

    public Main launch(boolean launch) {
        this.m_Launch = launch;
        return this;
    }

    public boolean getLaunch() {
        return this.m_Launch;
    }

    protected ArgumentParser getParser() {
        ArgumentParser parser = new ArgumentParser("Bootstrapping Java applications with Maven dependencies and/or jar files.");
        parser.addOption("-m", "--maven_home").required(false).type(Option.Type.EXISTING_DIR).dest("maven_home").metaVar("DIR").help("The directory with a local Maven installation to use instead of the downloaded one.");
        parser.addOption("-u", "--maven_user_settings").required(false).type(Option.Type.EXISTING_FILE).dest("maven_user_settings").metaVar("FILE").help("The file with the maven user settings to use other than $HOME/.m2/settings.xml.");
        parser.addOption("-j", "--java_home").required(false).type(Option.Type.EXISTING_DIR).dest("java_home").metaVar("DIR").help("The Java home to use for the Maven execution.");
        parser.addOption("-n", "--name").required(false).setDefault("bootstrapp-harness").dest("name").help("The name to use for the project in the pom.xml. Also used as library directory and executable name when generating Debian/Redhat packages.");
        parser.addOption("-V", "--version").required(false).setDefault("0.0.1").dest("version").help("The version to use for the project in the pom.xml");
        parser.addOption("-d", "--dependency").required(false).multiple(true).dest("dependencies").metaVar("DEPENDENCY").help("The maven dependencies to use for bootstrapping the application (group:artifact:version), e.g.: nz.ac.waikato.cms.weka:weka-dev:3.9.4");
        parser.addOption("-D", "--dependency_file").required(false).multiple(true).type(Option.Type.EXISTING_FILE).dest("dependency_files").metaVar("DEPENDENCY_FILE").help("The file(s) with maven dependencies to use for bootstrapping the application (group:artifact:version), one dependency per line.");
        parser.addOption("-J", "--external-jar").required(false).multiple(true).type(Option.Type.EXISTING_FILE_OR_DIRECTORY).dest("external_jars").metaVar("JAR_OR_DIR").help("The external jar or directory with jar files to also include in the application.");
        parser.addOption("-x", "--exclusion").required(false).multiple(true).dest("exclusions").metaVar("EXCLUSION").help("The maven artifacts to exclude from all the dependencies ('group:artifact').");
        parser.addOption("-r", "--repository").required(false).multiple(true).dest("repositories").metaVar("REPOSITORY").help("The maven repository to use for bootstrapping the application (id;name;url), e.g.: bedatadriven;bedatadriven public repo;https://nexus.bedatadriven.com/content/groups/public/");
        parser.addOption("-C", "--clean").type(Option.Type.BOOLEAN).setDefault(false).dest("clean").help("If enabled, the 'clean' goals gets executed.");
        parser.addOption("-s", "--sources").type(Option.Type.BOOLEAN).setDefault(false).dest("sources").help("If enabled, source jars of the Maven artifacts will get downloaded as well and stored in a separated directory.");
        parser.addOption("-S", "--external-source").required(false).multiple(true).type(Option.Type.EXISTING_FILE_OR_DIRECTORY).dest("external_sources").metaVar("JAR_OR_DIR").help("The external source jar or directory with source jar files to also include in the application.");
        parser.addOption("-p", "--pom_template").required(false).type(Option.Type.EXISTING_FILE).dest("pom_template").metaVar("FILE").help("The alternative template for the pom.xml to use.");
        parser.addOption("-o", "--output_dir").required(true).type(Option.Type.DIRECTORY).dest("output_dir").metaVar("DIR").help("The directory to output the bootstrapped application in.");
        parser.addOption("-c", "--main_class").required(false).dest("main_class").metaVar("CLASSNAME").help("The main class to execute after bootstrapping the application.");
        parser.addOption("-v", "--jvm").required(false).multiple(true).dest("jvm").help("The parameters to pass to the JVM before launching the application.");
        parser.addOption("-e", "--scripts").type(Option.Type.BOOLEAN).setDefault(false).dest("scripts").help("If enabled, shell/batch scripts get generated to launch the main class.");
        parser.addOption("-l", "--launch").type(Option.Type.BOOLEAN).setDefault(false).dest("launch").help("If enabled, the supplied main class will get launched.");
        parser.addOption("-b", "--spring_boot").type(Option.Type.BOOLEAN).setDefault(false).dest("spring_boot").help("If enabled, a spring-boot jar is generated utilizing the main class (single jar with all dependencies contained).");
        parser.addOption("--deb").type(Option.Type.BOOLEAN).setDefault(false).dest("debian").help("If enabled, a Debian .deb package is generated. Required tools: fakeroot, dpkg-deb");
        parser.addOption("--deb_snippet").type(Option.Type.EXISTING_FILE).required(false).dest("debian_snippet").metaVar("FILE").help("The custom Maven pom.xml snippet for generating a Debian package.");
        parser.addOption("--rpm").type(Option.Type.BOOLEAN).setDefault(false).dest("redhat").help("If enabled, a Redhat .rpm package is generated.");
        parser.addOption("--rpm_snippet").type(Option.Type.EXISTING_FILE).required(false).dest("rpm_snippet").metaVar("FILE").help("The custom Maven pom.xml snippet for generating a Redhat package.");
        parser.addOption("--docker").type(Option.Type.BOOLEAN).setDefault(false).dest("docker").help("If enabled, a Dockerfile is generated.");
        parser.addOption("--docker_base_image").required(false).dest("docker_base_image").metaVar("IMAGE").help("The base image to use for the docker image, e.g., 'openjdk:11-jdk-slim-buster'.");
        parser.addOption("--docker_snippet").type(Option.Type.EXISTING_FILE).required(false).dest("docker_snippet").metaVar("FILE").help("The file with custom docker instructions.");
        parser.addOption("-z", "--compress_dir_structure").type(Option.Type.BOOLEAN).setDefault(false).dest("compress_dir_structure").help("If enabled, the directory structure gets compressed (ie 'target' left out). However, side-effect in combination with '--clean' is that the 'pom.xml' disappears.");
        return parser;
    }

    protected boolean setOptions(Namespace ns) {
        this.mavenHome(ns.getFile("maven_home"));
        this.mavenUserSettings(ns.getFile("maven_user_settings"));
        this.javaHome(ns.getFile("java_home"));
        this.outputDir(ns.getFile("output_dir"));
        this.jvm(ns.getList("jvm"));
        this.name(ns.getString("name"));
        this.version(ns.getString("version"));
        this.dependencies(ns.getList("dependencies"));
        this.dependencyFiles(ns.getList("dependency_files"));
        this.externalJars(ns.getList("external_jars"));
        this.exclusions(ns.getList("exclusions"));
        this.repositories(ns.getList("repositories"));
        this.clean(ns.getBoolean("clean"));
        this.sources(ns.getBoolean("sources"));
        this.externalSources(ns.getList("external_sources"));
        this.pomTemplate(ns.getFile("pom_template"));
        this.mainClass(ns.getString("main_class"));
        this.scripts(ns.getBoolean("scripts"));
        this.springBoot(ns.getBoolean("spring_boot"));
        this.debian(ns.getBoolean("debian"));
        this.debianSnippet(ns.getFile("debian_snippet"));
        this.redhat(ns.getBoolean("redhat"));
        this.redhatSnippet(ns.getFile("redhat_snippet"));
        this.docker(ns.getBoolean("docker"));
        this.dockerBaseImage(ns.getString("docker_base_image"));
        this.dockerSnippet(ns.getFile("docker_snippet"));
        this.launch(ns.getBoolean("launch"));
        this.compressDirStructure(ns.getBoolean("compress_dir_structure"));
        return true;
    }

    public boolean getHelpRequested() {
        return this.m_HelpRequested;
    }

    public boolean setOptions(String[] options) {
        Namespace ns;
        this.m_HelpRequested = false;
        ArgumentParser parser = this.getParser();
        try {
            ns = parser.parseArgs(options);
        }
        catch (ArgumentParserException e) {
            parser.handleError(e);
            this.m_HelpRequested = parser.getHelpRequested();
            return this.m_HelpRequested;
        }
        return this.setOptions(ns);
    }

    protected String initMavenHome() {
        if (this.m_MavenHome == null) {
            String result = Maven.initRemoteMaven();
            if (result != null) {
                return result;
            }
            this.m_ActMavenHome = new File(Maven.homeDir());
        } else {
            this.m_ActMavenHome = this.m_MavenHome;
        }
        if (!this.m_ActMavenHome.exists()) {
            return "Maven home does not exist: " + this.m_ActMavenHome;
        }
        if (!this.m_ActMavenHome.isDirectory()) {
            return "Maven home is not a directory: " + this.m_ActMavenHome;
        }
        System.setProperty("maven.home", this.m_ActMavenHome.getAbsolutePath());
        return null;
    }

    protected String initJavaHome() {
        this.m_ActJavaHome = this.m_JavaHome == null ? new File(System.getProperty("java.home")) : this.m_JavaHome;
        if (!this.m_ActJavaHome.exists()) {
            return "Java home does not exist: " + this.m_ActJavaHome;
        }
        if (!this.m_ActJavaHome.isDirectory()) {
            return "Java home is not a directory: " + this.m_ActJavaHome;
        }
        return null;
    }

    protected String initOutputDir() {
        if (!this.m_OutputDir.exists() && !this.m_OutputDir.mkdirs()) {
            return "Failed to create output directory: " + this.m_OutputDir;
        }
        if (!this.m_OutputDir.isDirectory()) {
            return "Output directory is not a directory: " + this.m_OutputDir;
        }
        this.m_OutputDirMaven = this.m_CompressDirStructure ? new File(this.m_OutputDir.getAbsolutePath()) : new File(this.m_OutputDir.getAbsolutePath() + "/target");
        return null;
    }

    protected List<File> toJars(List<File> list) {
        ArrayList<File> result = new ArrayList<File>();
        for (File ext : this.m_ExternalJars) {
            if (ext.isDirectory()) {
                File[] files = ext.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.toLowerCase().endsWith(".jar");
                    }
                });
                if (files == null) continue;
                result.addAll(Arrays.asList(files));
                continue;
            }
            result.add(ext);
        }
        return result;
    }

    protected String initPomTemplate() {
        String result;
        String buildPlugin;
        List<String> lines;
        Template.Configuration config = new Template.Configuration();
        config.outputDirMaven = this.m_OutputDirMaven;
        config.dependencies = this.getAllDependencies();
        config.exclusions = this.getExclusions();
        config.repositories = this.getRepositories();
        config.noSources = !this.m_Sources;
        config.noSpringBoot = !this.m_SpringBoot;
        config.mainClass = this.m_MainClass;
        config.name = this.m_Name;
        config.version = this.m_Version;
        if (this.m_ExternalJars != null) {
            config.externalJars = this.toJars(this.m_ExternalJars);
        }
        if (this.m_ExternalSources != null) {
            config.externalSources = this.toJars(this.m_ExternalSources);
        }
        StringBuilder buildPlugins = new StringBuilder();
        if (this.m_Debian) {
            if (this.m_DebianSnippet != null) {
                try {
                    lines = Files.readAllLines(this.m_DebianSnippet.toPath());
                    for (String line : lines) {
                        buildPlugins.append(line).append("\n");
                    }
                }
                catch (Exception e) {
                    this.getLogger().log(Level.SEVERE, "Failed to load Debian maven snippet: " + this.m_DebianSnippet, e);
                    return "Failed to load Debian maven snippet: " + this.m_DebianSnippet;
                }
            } else {
                buildPlugin = this.m_Sources ? Content.readString((String)"com/github/fracpete/bootstrapp/debian.build_incl_sources") : Content.readString((String)"com/github/fracpete/bootstrapp/debian.build");
                buildPlugins.append(buildPlugin);
            }
        }
        if (this.m_Redhat) {
            if (this.m_RedhatSnippet != null) {
                try {
                    lines = Files.readAllLines(this.m_RedhatSnippet.toPath());
                    for (String line : lines) {
                        buildPlugins.append(line).append("\n");
                    }
                }
                catch (Exception e) {
                    this.getLogger().log(Level.SEVERE, "Failed to load Redhat maven snippet: " + this.m_RedhatSnippet, e);
                    return "Failed to load Redhat maven snippet: " + this.m_RedhatSnippet;
                }
            } else {
                buildPlugin = this.m_Sources ? Content.readString((String)"com/github/fracpete/bootstrapp/redhat.build_incl_sources") : Content.readString((String)"com/github/fracpete/bootstrapp/redhat.build");
                buildPlugins.append(buildPlugin);
            }
        }
        if (buildPlugins.length() > 0) {
            config.buildPlugins = buildPlugins.toString();
        }
        if (this.m_PomTemplate == null) {
            result = Template.configureBundledTemplate(this.m_OutputDir, config);
        } else {
            if (!this.m_PomTemplate.exists()) {
                return "pom.xml template does not exist: " + this.m_PomTemplate;
            }
            if (this.m_PomTemplate.isDirectory()) {
                return "pom.xml template points to a directory: " + this.m_PomTemplate;
            }
            result = Template.configureTemplate(this.m_PomTemplate, this.m_OutputDir, config);
        }
        if (result == null) {
            this.m_ActPomTemplate = new File(this.m_OutputDir.getAbsolutePath() + "/pom.xml");
        }
        return result;
    }

    protected String executeMaven() {
        ArrayList<String> goals = new ArrayList<String>();
        if (this.m_Clean) {
            goals.add("clean");
        }
        goals.add("package");
        if (this.m_Debian) {
            goals.add("deb:package");
        }
        DefaultInvocationRequest request = new DefaultInvocationRequest();
        request.setPomFile(this.m_ActPomTemplate);
        request.setGoals(goals);
        request.setJavaHome(this.m_ActJavaHome);
        if (this.m_MavenUserSettings != null) {
            request.setUserSettingsFile(this.m_MavenUserSettings);
        }
        DefaultInvoker invoker = new DefaultInvoker();
        invoker.setMavenHome(this.m_ActMavenHome);
        try {
            invoker.execute((InvocationRequest)request);
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to bootstrap the application!", e);
            return "Failed to bootstrap the application: " + e;
        }
        return null;
    }

    protected List<String> buildLaunchCommand(String javaBinary, String libDir) {
        ArrayList<String> result = new ArrayList<String>();
        result.add(javaBinary);
        if (this.m_JVM != null) {
            result.addAll(this.m_JVM);
        }
        result.add("-cp");
        result.add(libDir);
        result.add(this.m_MainClass);
        return result;
    }

    protected String createShellScript() {
        if (this.m_MainClass != null) {
            File dir = new File(this.m_OutputDirMaven.getAbsolutePath() + "/bin");
            if (!dir.exists() && !dir.mkdirs()) {
                return "Failed to create directory for shell script: " + dir;
            }
            List<String> cmd = this.buildLaunchCommand("java", "\"$CP\"");
            File file = new File(dir.getAbsolutePath() + "/start.sh");
            StringBuilder script = new StringBuilder();
            script.append("#!/bin/bash\n");
            script.append("#\n");
            script.append("# Start script for " + this.m_Name + "\n");
            script.append("#\n");
            script.append("BASEDIR=`dirname $0`/..\n");
            script.append("BASEDIR=`(cd \"$BASEDIR\"; pwd)`\n");
            script.append("LIB=\"$BASEDIR\"/lib\n");
            script.append("CP=\"$LIB/*\"\n");
            for (String c : cmd) {
                script.append(c).append(" ");
            }
            script.append("\n");
            try {
                Files.write(file.toPath(), script.toString().getBytes(), StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                file.setExecutable(true);
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, "Failed to write shell script to: " + file, e);
                return "Failed to write shell script to '" + file + "': " + e;
            }
        }
        return null;
    }

    protected String createBatchScript() {
        if (this.m_MainClass != null) {
            File dir = new File(this.m_OutputDirMaven.getAbsolutePath() + "/bin");
            if (!dir.exists() && !dir.mkdirs()) {
                return "Failed to create directory for batch script: " + dir;
            }
            List<String> cmd = this.buildLaunchCommand("java", "\"%CP%\"");
            File file = new File(dir.getAbsolutePath() + "/start.bat");
            StringBuilder script = new StringBuilder();
            script.append("@echo off\n");
            script.append("\n");
            script.append("REM Start script for " + this.m_Name + "\n");
            script.append("\n");
            script.append("set BASEDIR=%~dp0\\..\n");
            script.append("set LIB=%BASEDIR%\\lib\n");
            script.append("set CP=%LIB%\\*\n");
            for (String c : cmd) {
                script.append(c).append(" ");
            }
            script.append("\n");
            try {
                Files.write(file.toPath(), script.toString().getBytes(), StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, "Failed to write batch script to: " + file, e);
                return "Failed to write batch script to '" + file + "': " + e;
            }
        }
        return null;
    }

    protected String createScripts() {
        String result = this.createShellScript();
        if (result != null) {
            return result;
        }
        result = this.createBatchScript();
        if (result != null) {
            return result;
        }
        return null;
    }

    protected String createLaunchScript() {
        if (this.m_MainClass == null) {
            return "Cannot create launch script for Debian/Redhat packages without a main class!";
        }
        File dir = new File(this.m_OutputDir.getAbsolutePath());
        if (!dir.exists() && !dir.mkdirs()) {
            return "Failed to create directory for launch script: " + dir;
        }
        List<String> cmd = this.buildLaunchCommand("java", "\"$CP\"");
        File file = new File(dir.getAbsolutePath() + "/launch");
        StringBuilder script = new StringBuilder();
        script.append("#!/bin/bash\n");
        script.append("#\n");
        script.append("# Start script for " + this.m_Name + "\n");
        script.append("#\n");
        script.append("CP=\"/usr/lib/" + this.m_Name + "/*\"\n");
        for (String c : cmd) {
            script.append(c).append(" ");
        }
        script.append("\n");
        try {
            Files.write(file.toPath(), script.toString().getBytes(), StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            file.setExecutable(true);
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to write launch script to: " + file, e);
            return "Failed to write launch script to '" + file + "': " + e;
        }
        return null;
    }

    protected String launchMainClass() {
        if (this.m_MainClass != null) {
            List<String> cmd = this.buildLaunchCommand(this.m_ActJavaHome.getAbsolutePath() + "/bin/java", this.m_OutputDirMaven.getAbsolutePath() + "/lib/*");
            ProcessBuilder builder = new ProcessBuilder(cmd);
            try {
                StreamingProcessOutput output = new StreamingProcessOutput((StreamingProcessOwner)new SimpleStreamingProcessOwner());
                output.monitor(builder);
                int exitCode = output.getExitCode();
                if (exitCode != 0) {
                    return "Failed to launch class (" + builder.command() + "): " + exitCode;
                }
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, "Failed to launch class!", e);
                return "Failed to launch class: " + e;
            }
        }
        return null;
    }

    protected String createDockerScript() {
        File dir;
        if (this.m_MainClass == null) {
            return "Cannot create launch script for Docker without a main class!";
        }
        if (this.m_Name == null || this.m_Name.isEmpty()) {
            return "No name supplied (used for start script and directory for libraries)!";
        }
        String name = this.m_Name;
        if (this.m_Version != null && !this.m_Version.isEmpty()) {
            name = name + "-" + this.m_Version;
        }
        if (!(dir = new File(this.m_OutputDir.getAbsolutePath())).exists() && !dir.mkdirs()) {
            return "Failed to create directory for launch script: " + dir;
        }
        List<String> cmd = this.buildLaunchCommand("java", "\"/bootstrapp/" + name + "/lib/*\"");
        File file = new File(dir.getAbsolutePath() + "/" + name + ".sh");
        StringBuilder script = new StringBuilder();
        script.append("#!/bin/bash\n");
        script.append("#\n");
        script.append("# Start script for " + this.m_Name + "\n");
        script.append("#\n");
        for (String c : cmd) {
            script.append(c).append(" ");
        }
        script.append("\n");
        try {
            Files.write(file.toPath(), script.toString().getBytes(), StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            file.setExecutable(true);
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to write launch script to: " + file, e);
            return "Failed to write launch script to '" + file + "': " + e;
        }
        return null;
    }

    protected String initDockerfile() {
        if (this.m_DockerBaseImage == null) {
            return "No Docker base image provided!";
        }
        if (this.m_Name == null || this.m_Name.isEmpty()) {
            return "No name supplied (used for start script and directory for libraries)!";
        }
        String name = this.m_Name;
        if (this.m_Version != null && !this.m_Version.isEmpty()) {
            name = name + "-" + this.m_Version;
        }
        File file = new File(this.m_OutputDir.getAbsolutePath() + "/Dockerfile");
        ArrayList<String> content = new ArrayList<String>();
        content.add("FROM " + this.m_DockerBaseImage);
        content.add("");
        if (this.m_DockerSnippet != null) {
            try {
                content.add("# additional instructions");
                List<String> lines = Files.readAllLines(this.m_DockerSnippet.toPath());
                if (lines != null) {
                    content.addAll(lines);
                    content.add("");
                }
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, "Failed to load Docker snippet: " + this.m_DockerSnippet, e);
                return "Failed to load Docker snippet: " + this.m_DockerSnippet;
            }
        }
        String dirPrefix = this.m_CompressDirStructure ? "" : "target/";
        content.add("# copy libraries");
        content.add("COPY " + dirPrefix + "lib/* /bootstrapp/" + name + "/lib/");
        if (this.m_Sources) {
            content.add("COPY " + dirPrefix + "src/* /bootstrapp/" + name + "/src/");
        }
        String startScript = null;
        if (this.m_MainClass != null) {
            startScript = "/bootstrapp/" + name + ".sh";
            content.add("# for launching main class");
            content.add("COPY " + name + ".sh " + startScript);
        }
        try {
            Files.write(file.toPath(), content, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to write Dockerfile to: " + file, e);
            return "Failed to write Dockerfile to: " + file;
        }
        System.out.println();
        System.out.println("You can now generate the docker image with the following commands:");
        System.out.println("cd " + this.m_OutputDir.getAbsolutePath());
        System.out.println("[sudo] docker build -t <imagename> .");
        System.out.println();
        if (startScript != null) {
            System.out.println("The main class can be launched with '" + startScript + "' inside the container.");
            System.out.println();
        }
        return null;
    }

    protected String doExecute() {
        this.m_ActMavenHome = null;
        this.m_ActJavaHome = null;
        this.m_ActPomTemplate = null;
        String result = this.initMavenHome();
        if (result != null) {
            return result;
        }
        result = this.initJavaHome();
        if (result != null) {
            return result;
        }
        result = this.initOutputDir();
        if (result != null) {
            return result;
        }
        result = this.initPomTemplate();
        if (result != null) {
            return result;
        }
        if ((this.m_Debian || this.m_Redhat) && (result = this.createLaunchScript()) != null) {
            return result;
        }
        result = this.executeMaven();
        if (result != null) {
            return result;
        }
        if (this.getScripts() && (result = this.createScripts()) != null) {
            return result;
        }
        if (this.getLaunch() && (result = this.launchMainClass()) != null) {
            return result;
        }
        if (this.getDocker()) {
            result = this.createDockerScript();
            if (result != null) {
                return result;
            }
            result = this.initDockerfile();
            if (result != null) {
                return result;
            }
        }
        return null;
    }

    public String execute() {
        String result = this.doExecute();
        if (result != null) {
            this.getLogger().severe(result);
        }
        return result;
    }

    public static void main(String[] args) {
        Main main = new Main();
        if (!main.setOptions(args)) {
            System.err.println("Failed to parse options!");
            System.exit(1);
        } else if (main.getHelpRequested()) {
            System.exit(0);
        }
        String result = main.execute();
        if (result != null) {
            System.err.println("Failed to perform bootstrapping:\n" + result);
            System.exit(2);
        }
    }
}

