/*
 * Decompiled with CFR 0.152.
 */
package com.github.fracpete.bootstrapp.core;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.logging.Logger;

public class Template {
    public static final String TEMPLATE_FILE = "template.xml";
    public static final String DEBIANBUILD_FILE = "debian.build";
    public static final String DEBIANBUILDSRC_FILE = "debian.build_incl_sources";
    public static final String REDHATBUILD_FILE = "redhat.build";
    public static final String REDHATBUILDSRC_FILE = "redhat.build_incl_sources";
    public static final String PH_DEPENDENCIES = "<!-- dependencies -->";
    public static final String PH_REPOSITORIES = "<!-- repositories -->";
    public static final String PH_OUTPUTDIR = "<!-- outputdir -->";
    public static final String PH_NOSOURCES = "<!-- nosources -->";
    public static final String PH_NOSPRINGBOOT = "<!-- nospringboot -->";
    public static final String PH_MAINCLASS = "<!-- mainclass -->";
    public static final String PH_PACKAGING = "<!-- packaging -->";
    public static final String PH_NAME = "<!-- name -->";
    public static final String PH_VERSION = "<!-- version -->";
    public static final String PH_BUILDPLUGINS = "<!-- buildplugins -->";
    public static final String DEFAULT_NAME = "bootstrapp-harness";
    public static final String DEFAULT_VERSION = "0.0.1";
    protected static Logger LOGGER = Logger.getLogger(Template.class.getName());

    public static String configureBundledTemplate(File outputDir, Configuration config) {
        try {
            String path = com.github.fracpete.resourceextractor4j.Files.extractTo((String)"com/github/fracpete/bootstrapp", (String)TEMPLATE_FILE, (String)System.getProperty("java.io.tmpdir"));
            String result = Template.configureTemplate(new File(path), outputDir, config);
            File file = new File(path);
            if (file.exists()) {
                file.delete();
            }
            return result;
        }
        catch (Exception e) {
            return "Failed to configure bundled template: " + e;
        }
    }

    public static String configureTemplate(File template, File outputDir, Configuration config) {
        String[] parts;
        StringBuilder excls = new StringBuilder();
        if (config.exclusions != null) {
            excls.append("      <exclusions>");
            for (String exclusion : config.exclusions) {
                parts = exclusion.split(":");
                if (parts.length == 2) {
                    excls.append("        <exclusion>\n");
                    excls.append("          <groupId>").append(parts[0]).append("</groupId>\n");
                    excls.append("          <artifactId>").append(parts[1]).append("</artifactId>\n");
                    excls.append("        </exclusion>\n");
                    continue;
                }
                LOGGER.warning("Skipping exclusion as it does not conform to format 'group:artifact': " + exclusion);
            }
            excls.append("      </exclusions>");
        }
        String exclsStr = excls.toString();
        StringBuilder deps = new StringBuilder();
        deps.append("  <dependencies>\n");
        for (String dependency : config.dependencies) {
            parts = dependency.split(":");
            if (parts.length == 3) {
                deps.append("    <dependency>\n");
                deps.append("      <groupId>").append(parts[0]).append("</groupId>\n");
                deps.append("      <artifactId>").append(parts[1]).append("</artifactId>\n");
                deps.append("      <version>").append(parts[2]).append("</version>\n");
                if (!exclsStr.isEmpty()) {
                    deps.append(exclsStr);
                }
                deps.append("    </dependency>\n");
                continue;
            }
            LOGGER.warning("Skipping dependency as it does not conform to format 'group:artifact:version': " + dependency);
        }
        if (config.externalJars != null) {
            for (File externalJar : config.externalJars) {
                deps.append("    <dependency>\n");
                deps.append("      <groupId>bootstrapp</groupId>\n");
                deps.append("      <artifactId>ext-" + externalJar.getName().toLowerCase().replace(".jar", "") + "</artifactId>\n");
                deps.append("      <version>0.0.0</version>\n");
                deps.append("      <scope>system</scope>\n");
                deps.append("      <systemPath>" + externalJar.getAbsolutePath() + "</systemPath>\n");
                deps.append("    </dependency>\n");
            }
        }
        if (config.externalSources != null) {
            for (File externalSource : config.externalSources) {
                deps.append("    <dependency>\n");
                deps.append("      <groupId>bootstrapp</groupId>\n");
                deps.append("      <artifactId>ext-" + externalSource.getName().toLowerCase().replace(".jar", "") + "</artifactId>\n");
                deps.append("      <version>0.0.0</version>\n");
                deps.append("      <scope>system</scope>\n");
                deps.append("      <classifier>sources</classifier>\n");
                deps.append("      <systemPath>" + externalSource.getAbsolutePath() + "</systemPath>\n");
                deps.append("    </dependency>\n");
            }
        }
        deps.append("  </dependencies>\n");
        String depsStr = deps.toString();
        if (config.dependencies.size() == 0) {
            LOGGER.warning("No dependencies supplied!");
        }
        StringBuilder repos = new StringBuilder();
        if (config.repositories != null && config.repositories.size() > 0) {
            repos.append("  <repositories>\n");
            for (String repo : config.repositories) {
                parts = repo.split(";");
                if (parts.length != 3) continue;
                repos.append("    <repository>\n");
                repos.append("      <id>").append(parts[0]).append("</id>\n");
                repos.append("      <name>").append(parts[1]).append("</name>\n");
                repos.append("      <url>").append(parts[2]).append("</url>\n");
                repos.append("    </repository>\n");
            }
            repos.append("  </repositories>\n");
        }
        String reposStr = repos.toString();
        try {
            boolean modified = false;
            List<String> lines = Files.readAllLines(template.toPath());
            for (int i = 0; i < lines.size(); ++i) {
                if (!lines.get(i).contains("<!-- ")) continue;
                String line = lines.get(i);
                line = line.replace(PH_NAME, config.name);
                line = line.replace(PH_VERSION, config.version);
                line = line.replace(PH_DEPENDENCIES, depsStr);
                line = line.replace(PH_REPOSITORIES, reposStr);
                line = line.replace(PH_OUTPUTDIR, config.outputDirMaven.getAbsolutePath());
                line = line.replace(PH_NOSOURCES, "" + config.noSources);
                line = line.replace(PH_NOSPRINGBOOT, "" + config.noSpringBoot);
                line = line.replace(PH_PACKAGING, config.noSpringBoot ? "pom" : "jar");
                if (config.mainClass != null) {
                    line = line.replace(PH_MAINCLASS, "" + config.mainClass);
                }
                if (config.buildPlugins != null) {
                    line = line.replace(PH_BUILDPLUGINS, "" + config.buildPlugins);
                }
                if (lines.get(i).equals(line)) continue;
                lines.set(i, line);
                modified = true;
            }
            if (!modified) {
                LOGGER.warning("Template file did not contain any placeholders, not modified!");
            }
            Files.write(new File(outputDir.getAbsolutePath() + "/pom.xml").toPath(), lines, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (Exception e) {
            return "Failed to configure template file '" + template + "': " + e;
        }
        return null;
    }

    public static class Configuration {
        public File outputDirMaven;
        public List<String> dependencies;
        public List<String> exclusions;
        public List<String> repositories;
        public List<File> externalJars;
        public List<File> externalSources;
        public boolean noSources;
        public boolean noSpringBoot;
        public String mainClass;
        public String name;
        public String version;
        public String buildPlugins;
    }
}

