/*
 * Decompiled with CFR 0.152.
 */
package weka.core.code;

import weka.core.Utils;
import weka.core.code.AbstractConverter;

public class StringArray
extends AbstractConverter {
    private static final long serialVersionUID = 684439147675462945L;

    @Override
    public String getName() {
        return "String array";
    }

    @Override
    public boolean handles(String cmd) {
        return true;
    }

    @Override
    public String convert(String cmd) {
        StringBuilder result = new StringBuilder();
        try {
            String[] options = Utils.splitOptions((String)cmd);
            result.append("String[] options = new String[").append(options.length).append("];");
            for (int i = 0; i < options.length; ++i) {
                result.append("\n");
                result.append("options[").append(i).append("] = \"");
                result.append(Utils.backQuoteChars((String)options[i]));
                result.append("\";");
            }
        }
        catch (Exception e) {
            System.err.println("Failed to parse command-line!");
            e.printStackTrace();
            return null;
        }
        return result.toString();
    }
}

