/*
 * Decompiled with CFR 0.152.
 */
package weka.core.code;

import weka.core.Utils;
import weka.core.code.AbstractConverter;
import weka.core.code.CodeHelper;
import weka.core.code.Instantiation;

public class TestClass
extends AbstractConverter {
    private static final long serialVersionUID = -4724000142023362577L;

    @Override
    public String getName() {
        return "Test class";
    }

    @Override
    public boolean handles(String cmd) {
        return new Instantiation().handles(cmd);
    }

    protected String convert(String cmd, boolean quiet) {
        StringBuilder result;
        block4: {
            result = new StringBuilder();
            try {
                Class cls = CodeHelper.classFromCommand(cmd);
                String cmdOptions = CodeHelper.optionsStringFromCommand(cmd);
                result.append("import " + cls.getName() + ";\n");
                result.append("import weka.core.Utils;\n");
                result.append("\n");
                result.append("public class OptionsTest {\n");
                result.append("\n");
                result.append("  public static void main(String[] args) throws Exception {\n");
                result.append("    ");
                result.append(cls.getSimpleName() + " " + cls.getSimpleName().toLowerCase() + " = new " + cls.getName() + "();");
                if (CodeHelper.isOptionHandler(cmd) && cmdOptions.trim().length() > 0) {
                    result.append("\n    " + cls.getSimpleName().toLowerCase() + ".setOptions(Utils.splitOptions(\"" + Utils.backQuoteChars((String)cmdOptions) + "\"));");
                }
                result.append("\n  }\n");
                result.append("}\n");
            }
            catch (Exception e) {
                result = null;
                if (quiet) break block4;
                System.err.println("Failed to process command-line: " + cmd);
                e.printStackTrace();
            }
        }
        if (result == null) {
            return null;
        }
        return result.toString();
    }

    @Override
    public String convert(String cmd) {
        return this.convert(cmd, false);
    }
}

