/*
 * Decompiled with CFR 0.152.
 */
package weka.core.converters;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Range;
import weka.core.RevisionUtils;
import weka.core.SelectedTag;
import weka.core.Tag;
import weka.core.Utils;
import weka.core.converters.AbstractFileLoader;
import weka.core.converters.BatchConverter;
import weka.core.converters.CommonCsvFormats;
import weka.core.converters.CommonCsvQuoteModes;
import weka.core.converters.IncrementalConverter;
import weka.core.converters.URLSourcedLoader;

public class CommonCSVLoader
extends AbstractFileLoader
implements BatchConverter,
IncrementalConverter,
URLSourcedLoader,
OptionHandler {
    private static final long serialVersionUID = 3764533621135196582L;
    public static final String FILE_EXTENSION = ".csv";
    public static final String FILE_EXTENSION_TEXT = ".txt";
    public static final String FILE_EXTENSION_TSV = ".tsv";
    protected int m_Format = 1;
    protected boolean m_UseCustomFieldSeparator = false;
    public static final String DEFAULT_CUSTOM_FIELD_SEPARATOR = ",";
    protected String m_CustomFieldSeparator = ",";
    protected boolean m_UseCustomQuoteCharacter = false;
    public static final String DEFAULT_CUSTOM_QUOTE_CHARACTER = "\"";
    protected String m_CustomQuoteCharacter = "\"";
    protected boolean m_UseCustomQuoteMode = false;
    public static final int DEFAULT_CUSTOM_QUOTE_MODE = 2;
    protected int m_CustomQuoteMode = 2;
    protected boolean m_UseCustomEscapeCharacter = false;
    public static final String DEFAULT_CUSTOM_ESCAPE_CHARACTER = "";
    protected String m_CustomEscapeCharacter = "";
    protected boolean m_NoHeader = false;
    public static final String DEFAULT_CUSTOM_HEADER = "";
    protected String m_CustomHeader = "";
    protected Range m_NominalRange = new Range();
    protected List<String> m_nominalLabelSpecs = new ArrayList<String>();
    protected Range m_StringRange = new Range();
    protected Range m_DateRange = new Range();
    public static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    protected String m_DateFormat = "yyyy-MM-dd'T'HH:mm:ss";
    public static final String DEFAULT_MISSING_VALUE = "";
    protected String m_MissingValue = "";
    public static final int DEFAULT_NUM_ROWS_TYPE_DETECTION = 100;
    protected int m_NumRowsTypeDetection = 100;
    protected String m_URL = "http://";
    protected transient Reader m_sourceReader = null;
    protected Instances m_Data;
    protected transient List<CSVRecord> m_Records;
    protected transient CSVParser m_Parser;
    protected AttributeType[] m_Types;
    protected int m_FirstDataRow;

    public String globalInfo() {
        return "Reads files in common CSV formats.\nFor tab-delimited files, choose TDF as format.\nFor other formats, you can specify a custom field separator.";
    }

    public String getFileExtension() {
        return FILE_EXTENSION;
    }

    public String[] getFileExtensions() {
        return new String[]{FILE_EXTENSION, FILE_EXTENSION_TSV, FILE_EXTENSION_TEXT};
    }

    public String getFileDescription() {
        return "Common CSV files";
    }

    public void setFormat(SelectedTag value) {
        if (value.getTags() == CommonCsvFormats.TAGS_FORMATS) {
            this.m_Format = value.getSelectedTag().getID();
        }
    }

    public SelectedTag getFormat() {
        return new SelectedTag(this.m_Format, CommonCsvFormats.TAGS_FORMATS);
    }

    public String formatTipText() {
        return "The format of the CSV file.";
    }

    public void setUseCustomFieldSeparator(boolean value) {
        this.m_UseCustomFieldSeparator = value;
    }

    public boolean getUseCustomFieldSeparator() {
        return this.m_UseCustomFieldSeparator;
    }

    public String useCustomFieldSeparatorTipText() {
        return "If enabled, makes use of the supplied field separator.";
    }

    public void setCustomFieldSeparator(String value) {
        if (value.length() == 1) {
            this.m_CustomFieldSeparator = value;
        } else {
            System.err.println("Field separator must be 1 character long!");
        }
    }

    public String getCustomFieldSeparator() {
        return this.m_CustomFieldSeparator;
    }

    public String customFieldSeparatorTipText() {
        return "The field separator, when using custom one is enabled.";
    }

    public void setUseCustomQuoteCharacter(boolean value) {
        this.m_UseCustomQuoteCharacter = value;
    }

    public boolean getUseCustomQuoteCharacter() {
        return this.m_UseCustomQuoteCharacter;
    }

    public String useCustomQuoteCharacterTipText() {
        return "If enabled, makes use of the supplied quote character.";
    }

    public void setCustomQuoteCharacter(String value) {
        if (value.length() == 1) {
            this.m_CustomQuoteCharacter = value;
        } else {
            System.err.println("Quote character must be 1 character long!");
        }
    }

    public String getCustomQuoteCharacter() {
        return this.m_CustomQuoteCharacter;
    }

    public String customQuoteCharacterTipText() {
        return "The quote character, when using custom one is enabled.";
    }

    public void setUseCustomQuoteMode(boolean value) {
        this.m_UseCustomQuoteMode = value;
    }

    public boolean getUseCustomQuoteMode() {
        return this.m_UseCustomQuoteMode;
    }

    public String useCustomQuoteModeTipText() {
        return "If enabled, makes use of the supplied quote mode.";
    }

    public void setCustomQuoteMode(SelectedTag value) {
        if (value.getTags() == CommonCsvQuoteModes.TAGS_QUOTEMODES) {
            this.m_CustomQuoteMode = value.getSelectedTag().getID();
        }
    }

    public SelectedTag getCustomQuoteMode() {
        return new SelectedTag(this.m_CustomQuoteMode, CommonCsvQuoteModes.TAGS_QUOTEMODES);
    }

    public String customQuoteModeTipText() {
        return "The quote mode, when using custom one is enabled.";
    }

    public void setUseCustomEscapeCharacter(boolean value) {
        this.m_UseCustomEscapeCharacter = value;
    }

    public boolean getUseCustomEscapeCharacter() {
        return this.m_UseCustomEscapeCharacter;
    }

    public String useCustomEscapeCharacterTipText() {
        return "If enabled, makes use of the supplied escape character.";
    }

    public void setCustomEscapeCharacter(String value) {
        this.m_CustomEscapeCharacter = value;
    }

    public String getCustomEscapeCharacter() {
        return this.m_CustomEscapeCharacter;
    }

    public String customEscapeCharacterTipText() {
        return "The escape character, when using custom one is enabled.";
    }

    public void setNoHeader(boolean value) {
        this.m_NoHeader = value;
    }

    public boolean getNoHeader() {
        return this.m_NoHeader;
    }

    public String noHeaderTipText() {
        return "If enabled, assumes no header row in the spreadsheet.";
    }

    public void setCustomHeader(String value) {
        this.m_CustomHeader = value;
    }

    public String getCustomHeader() {
        return this.m_CustomHeader;
    }

    public String customHeaderTipText() {
        return "The comma-separated list of column names, ignored if empty.";
    }

    public void setNominalRange(Range value) {
        this.m_NominalRange = value;
    }

    public Range getNominalRange() {
        return this.m_NominalRange;
    }

    public String nominalRangeTipText() {
        return "The range of attributes to treat as nominal.";
    }

    public void setNominalLabelSpecs(Object[] specs) {
        this.m_nominalLabelSpecs.clear();
        for (Object spec : specs) {
            this.m_nominalLabelSpecs.add(spec.toString());
        }
    }

    public Object[] getNominalLabelSpecs() {
        return this.m_nominalLabelSpecs.toArray(new String[0]);
    }

    public String nominalLabelSpecsTipText() {
        return "Optional specification of legal labels for nominal attributes. May be specified multiple times. Batch mode can determine this automatically (and so can incremental mode if the first in memory buffer load of instances contains an example of each legal value). The spec contains two parts separated by a \":\". The first part can be a range of attribute indexes or a comma-separated list off attruibute names; the second part is a comma-separated list of labels. E.g \"1,2,4-6:red,green,blue\" or \"att1,att2:red,green,blue\"";
    }

    public void setStringRange(Range value) {
        this.m_StringRange = value;
    }

    public Range getStringRange() {
        return this.m_StringRange;
    }

    public String stringRangeTipText() {
        return "The range of attributes to treat as string.";
    }

    public void setDateRange(Range value) {
        this.m_DateRange = value;
    }

    public Range getDateRange() {
        return this.m_DateRange;
    }

    public String dateRangeTipText() {
        return "The range of attributes to treat as date.";
    }

    public void setDateFormat(String value) {
        try {
            new SimpleDateFormat(value);
            this.m_DateFormat = value;
        }
        catch (Exception e) {
            System.err.println("Failed to parse date format: " + value);
            e.printStackTrace();
        }
    }

    public String getDateFormat() {
        return this.m_DateFormat;
    }

    public String dateFormatTipText() {
        return "The format for parsing the date attribute(s).";
    }

    public void setMissingValue(String value) {
        this.m_MissingValue = value;
    }

    public String getMissingValue() {
        return this.m_MissingValue;
    }

    public String missingValueTipText() {
        return "The string to interpret as missing value.";
    }

    public void setNumRowsTypeDetection(int value) {
        if (value > 0) {
            this.m_NumRowsTypeDetection = value;
        } else {
            System.err.println("Number of rows for type detection must be >0!");
        }
    }

    public int getNumRowsTypeDetection() {
        return this.m_NumRowsTypeDetection;
    }

    public String numRowsTypeDetectionTipText() {
        return "The number of rows to use for detecting numeric columns.";
    }

    public Enumeration listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tThe CSV format to use\n\t(default: DEFAULT)", "F", 1, "-F " + Tag.toOptionList((Tag[])CommonCsvFormats.TAGS_FORMATS)));
        result.addElement(new Option("\tWhether to use custom field separator\n\t(default: no)", "use-custom-field-separator", 0, "-use-custom-field-separator"));
        result.addElement(new Option("\tThe custom field separator\n\t(default: ,)", "custom-field-separator", 1, "-custom-field-separator <separator-char>"));
        result.addElement(new Option("\tWhether to use custom quote character\n\t(default: no)", "use-custom-quote-character", 0, "-use-custom-quote-character"));
        result.addElement(new Option("\tThe custom quote character\n\t(default: \")", "custom-quote-character", 1, "-custom-quote-character <quote-char>"));
        result.addElement(new Option("\tWhether to use custom quote mode\n\t(default: no)", "use-custom-quote-mode", 0, "-use-custom-quote-mode"));
        result.addElement(new Option("\tThe custom quote mode\n\t(default: MINIMAL)", "custom-quote-mode", 1, "-custom-quote-mode " + Tag.toOptionList((Tag[])CommonCsvQuoteModes.TAGS_QUOTEMODES)));
        result.addElement(new Option("\tWhether to use custom escape character\n\t(default: no)", "use-custom-escape-character", 0, "-use-custom-escape-character"));
        result.addElement(new Option("\tThe custom escape character\n\t(default: )", "custom-escape-character", 1, "-custom-escape-character <escape-char>"));
        result.addElement(new Option("\tWhether there is no header row in the spreadsheet\n\t(default: assumes header row present)", "no-header", 0, "-no-header"));
        result.addElement(new Option("\tThe attribute range to treat as nominal\n\t(default: none)", "nominal", 1, "-nominal <range>"));
        result.add(new Option("\tOptional specification of legal labels for nominal\n\tattributes. May be specified multiple times.\n\tThe spec contains two parts separated by a \":\".\n\tThe first part can be a range of attribute indexes or\n\ta comma-separated list off attruibute names;\n\tthe second part is a comma-separated list of labels. E.g.:\n\t\"1,2,4-6:red,green,blue\" or \"att1,att2:red,green,blue\"", "nominal-label-spec", 1, "-nominal-label-spec <nominal label spec>"));
        result.addElement(new Option("\tThe attribute range to treat as string\n\t(default: none)", "string", 1, "-string <range>"));
        result.addElement(new Option("\tThe attribute range to treat as date\n\t(default: none)", "date", 1, "-date <range>"));
        result.addElement(new Option("\tThe format to use for parsing the date attribute(s)\n\tsee: https://docs.oracle.com/en/java/javase/11/docs/api/java.base/java/time/format/DateTimeFormatter.html\n\t(default: yyyy-MM-dd'T'HH:mm:ss)", "date-format", 1, "-date-format <format>"));
        result.addElement(new Option("\tThe string to interpret as missing value\n\t(default: '')", "missing-value", 1, "-missing-value <string>"));
        result.addElement(new Option("\tThe number of rows to use for detecting numeric rows\n\t(default: '100')", "num-rows-type-detection", 1, "-num-rows-type-detection <int>"));
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String tmp = Utils.getOption((char)'F', (String[])options);
        if (!tmp.isEmpty()) {
            this.setFormat(new SelectedTag(tmp, CommonCsvFormats.TAGS_FORMATS));
        } else {
            this.setFormat(new SelectedTag(1, CommonCsvFormats.TAGS_FORMATS));
        }
        this.setUseCustomFieldSeparator(Utils.getFlag((String)"use-custom-field-separator", (String[])options));
        tmp = Utils.getOption((String)"custom-field-separator", (String[])options);
        if (!tmp.isEmpty() && tmp.length() == 1) {
            this.setCustomFieldSeparator(tmp);
        } else {
            this.setCustomFieldSeparator(DEFAULT_CUSTOM_FIELD_SEPARATOR);
        }
        this.setUseCustomQuoteCharacter(Utils.getFlag((String)"use-custom-quote-character", (String[])options));
        tmp = Utils.getOption((String)"custom-quote-character", (String[])options);
        if (!tmp.isEmpty() && tmp.length() == 1) {
            this.setCustomQuoteCharacter(tmp);
        } else {
            this.setCustomQuoteCharacter(DEFAULT_CUSTOM_QUOTE_CHARACTER);
        }
        this.setUseCustomQuoteMode(Utils.getFlag((String)"use-custom-quote-mode", (String[])options));
        tmp = Utils.getOption((String)"custom-quote-mode", (String[])options);
        if (!tmp.isEmpty()) {
            this.setCustomQuoteMode(new SelectedTag(tmp, CommonCsvQuoteModes.TAGS_QUOTEMODES));
        } else {
            this.setCustomQuoteMode(new SelectedTag(2, CommonCsvQuoteModes.TAGS_QUOTEMODES));
        }
        this.setUseCustomEscapeCharacter(Utils.getFlag((String)"use-custom-escape-character", (String[])options));
        tmp = Utils.getOption((String)"custom-escape-character", (String[])options);
        this.setCustomEscapeCharacter(tmp);
        this.setNoHeader(Utils.getFlag((String)"no-header", (String[])options));
        tmp = Utils.getOption((String)"custom-header", (String[])options);
        if (!tmp.isEmpty()) {
            this.setCustomHeader(tmp);
        } else {
            this.setCustomHeader("");
        }
        tmp = Utils.getOption((String)"nominal", (String[])options);
        if (!tmp.isEmpty()) {
            this.setNominalRange(new Range(tmp));
        } else {
            this.setNominalRange(new Range());
        }
        this.m_nominalLabelSpecs.clear();
        while (!(tmp = Utils.getOption((String)"nominal-label-spec", (String[])options)).isEmpty()) {
            this.m_nominalLabelSpecs.add(tmp);
        }
        tmp = Utils.getOption((String)"string", (String[])options);
        if (!tmp.isEmpty()) {
            this.setStringRange(new Range(tmp));
        } else {
            this.setStringRange(new Range());
        }
        tmp = Utils.getOption((String)"date", (String[])options);
        if (!tmp.isEmpty()) {
            this.setDateRange(new Range(tmp));
        } else {
            this.setDateRange(new Range());
        }
        tmp = Utils.getOption((String)"date-format", (String[])options);
        if (!tmp.isEmpty()) {
            this.setDateFormat(tmp);
        } else {
            this.setDateFormat(DEFAULT_DATE_FORMAT);
        }
        tmp = Utils.getOption((String)"missing-value", (String[])options);
        if (!tmp.isEmpty()) {
            this.setMissingValue(tmp);
        } else {
            this.setMissingValue("");
        }
        tmp = Utils.getOption((String)"num-rows-type-detection", (String[])options);
        if (!tmp.isEmpty()) {
            this.setNumRowsTypeDetection(Integer.parseInt(tmp));
        } else {
            this.setNumRowsTypeDetection(100);
        }
        Utils.checkForRemainingOptions((String[])options);
    }

    public String[] getOptions() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("-F");
        result.add(this.getFormat().getSelectedTag().getIDStr());
        if (this.getUseCustomFieldSeparator()) {
            result.add("-use-custom-field-separator");
            result.add("-custom-field-separator");
            result.add(this.getCustomFieldSeparator());
        }
        if (this.getUseCustomQuoteCharacter()) {
            result.add("-use-custom-quote-character");
            result.add("-custom-quote-character");
            result.add(this.getCustomQuoteCharacter());
        }
        if (this.getUseCustomQuoteMode()) {
            result.add("-use-custom-quote-mode");
            result.add("-custom-quote-mode");
            result.add(this.getCustomQuoteMode().getSelectedTag().getIDStr());
        }
        if (this.getUseCustomEscapeCharacter()) {
            result.add("-use-custom-escape-character");
            result.add("-custom-escape-character");
            result.add(this.getCustomEscapeCharacter());
        }
        if (this.getNoHeader()) {
            result.add("-no-header");
        }
        if (!this.getCustomHeader().isEmpty()) {
            result.add("-custom-header");
            result.add(this.getCustomHeader());
        }
        if (!this.getNominalRange().getRanges().isEmpty()) {
            result.add("-nominal");
            result.add(this.getNominalRange().getRanges());
            for (String spec : this.m_nominalLabelSpecs) {
                result.add("-nominal-label-spec");
                result.add(spec);
            }
        }
        if (!this.getStringRange().getRanges().isEmpty()) {
            result.add("-string");
            result.add(this.getStringRange().getRanges());
        }
        if (!this.getDateRange().getRanges().isEmpty()) {
            result.add("-date");
            result.add(this.getDateRange().getRanges());
            result.add("-date-format");
            result.add(this.getDateFormat());
        }
        result.add("-missing-value");
        result.add(this.getMissingValue());
        result.add("-num-rows-type-detection");
        result.add("" + this.getNumRowsTypeDetection());
        return result.toArray(new String[0]);
    }

    public void reset() throws IOException {
        this.m_structure = null;
        this.m_Data = null;
        this.setRetrieval(0);
        if (this.m_File != null) {
            this.setFile(new File(this.m_File));
        } else if (this.m_URL != null && !this.m_URL.equals("http://")) {
            this.setURL(this.m_URL);
        }
    }

    public void setSource(File file) throws IOException {
        this.m_structure = null;
        this.m_Data = null;
        this.setRetrieval(0);
        if (file == null) {
            throw new IOException("Source file object is null!");
        }
        try {
            if (file.getName().endsWith(FILE_EXTENSION_COMPRESSED)) {
                this.setSource(new GZIPInputStream(new FileInputStream(file)));
            } else {
                this.setSource(new FileInputStream(file));
            }
        }
        catch (FileNotFoundException ex) {
            throw new IOException("File not found");
        }
        this.m_sourceFile = file;
        this.m_File = file.getAbsolutePath();
    }

    public void setSource(URL url) throws IOException {
        this.m_structure = null;
        this.m_Data = null;
        this.setRetrieval(0);
        this.setSource(url.openStream());
        this.m_URL = url.toString();
    }

    public void setURL(String url) throws IOException {
        this.m_URL = url;
        this.setSource(new URL(url));
    }

    public String retrieveURL() {
        return this.m_URL;
    }

    public void setSource(InputStream in) throws IOException {
        this.m_File = new File(System.getProperty("user.dir")).getAbsolutePath();
        this.m_URL = "http://";
        this.m_sourceReader = new BufferedReader(new InputStreamReader(in));
        this.m_Data = null;
    }

    protected boolean isNumeric(String s) {
        try {
            Double.parseDouble(s);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected List<String> customColumnNames(int max) {
        ArrayList<String> result = new ArrayList<String>();
        if (!this.m_CustomHeader.isEmpty()) {
            result.addAll(Arrays.asList(this.m_CustomHeader.split(DEFAULT_CUSTOM_FIELD_SEPARATOR)));
        }
        if (max > -1) {
            int start;
            for (int i = start = result.size(); i < max; ++i) {
                result.add("att-" + (i + 1));
            }
        }
        return result;
    }

    protected void initInstances(ArrayList<Attribute> atts, int capacity) {
        String relation = this.m_sourceFile != null ? this.m_sourceFile.getName() : "CommonCSV";
        this.m_Data = new Instances(relation, atts, capacity);
        this.m_structure = new Instances(this.m_Data, 0);
    }

    protected void initParser() throws IOException {
        CSVFormat format = CommonCsvFormats.getFormat(this.m_Format);
        if (this.m_Format != 10 && this.m_UseCustomFieldSeparator) {
            format = format.withDelimiter(this.m_CustomFieldSeparator.charAt(0));
        }
        if (this.m_UseCustomQuoteCharacter) {
            format = format.withQuote(this.m_CustomQuoteCharacter.charAt(0));
        }
        if (this.m_UseCustomQuoteMode) {
            format = format.withQuoteMode(CommonCsvQuoteModes.getQuoteMode(this.m_CustomQuoteMode));
        }
        if (this.m_UseCustomEscapeCharacter && this.m_CustomEscapeCharacter.length() == 1) {
            format = format.withEscape(this.m_CustomEscapeCharacter.charAt(0));
        }
        format.withAllowMissingColumnNames();
        this.m_Parser = format.parse(this.m_sourceReader);
        this.m_Records = new ArrayList<CSVRecord>();
        Iterator iter = this.m_Parser.iterator();
        while (iter.hasNext() && this.m_Records.size() < this.m_NumRowsTypeDetection) {
            this.m_Records.add((CSVRecord)iter.next());
        }
    }

    protected CSVRecord nextRecord() {
        while (this.m_Records != null && this.m_FirstDataRow > 0 && this.m_Records.size() > 0) {
            this.m_Records.remove(0);
            --this.m_FirstDataRow;
        }
        if (this.m_Records != null && this.m_Records.size() > 0) {
            return this.m_Records.remove(0);
        }
        CSVRecord record = null;
        if (this.m_Parser != null) {
            Iterator iter = this.m_Parser.iterator();
            if (this.m_FirstDataRow > 0) {
                while (this.m_FirstDataRow > 0 && iter.hasNext()) {
                    record = (CSVRecord)iter.next();
                    --this.m_FirstDataRow;
                    if (record != null) continue;
                    this.m_FirstDataRow = 0;
                    break;
                }
            }
            if (record == null && iter.hasNext()) {
                record = (CSVRecord)iter.next();
            }
        }
        return record;
    }

    protected boolean initStructure() throws IOException {
        ArrayList<String> labels;
        String cell;
        int n;
        int i;
        int numRows = this.m_Records.size();
        this.m_FirstDataRow = this.m_NoHeader ? 0 : 1;
        ArrayList<Attribute> atts = new ArrayList<Attribute>();
        if (numRows == 0) {
            if (this.m_NoHeader) {
                List<String> names = this.customColumnNames(-1);
                if (names.size() == 0) {
                    throw new IOException("No rows in CSV file and no custom header defined!");
                }
                for (int i2 = 0; i2 < names.size(); ++i2) {
                    atts.add(new Attribute(names.get(i2)));
                }
                this.initInstances(atts, 0);
                return false;
            }
            throw new IOException("No rows in CSV file!");
        }
        if (numRows == 1 && !this.m_NoHeader) {
            for (int i3 = 0; i3 < this.m_Records.get(0).size(); ++i3) {
                atts.add(new Attribute(this.m_Records.get(0).get(i3)));
            }
            this.initInstances(atts, 0);
            return false;
        }
        ArrayList<String> names = new ArrayList<String>();
        if (this.m_NoHeader) {
            names.addAll(this.customColumnNames(this.m_Records.get(0).size()));
        } else {
            names.addAll(this.customColumnNames(-1));
            for (i = names.size(); i < this.m_Records.get(0).size(); ++i) {
                names.add(this.m_Records.get(0).get(i));
            }
        }
        HashSet<String> namesSet = new HashSet<String>();
        for (i = 0; i < names.size(); ++i) {
            String nameTmp = (String)names.get(i);
            if (!nameTmp.isEmpty() && !namesSet.contains(nameTmp)) {
                namesSet.add(nameTmp);
                continue;
            }
            n = 1;
            while (nameTmp.isEmpty() || namesSet.contains(nameTmp)) {
                ++n;
                if (((String)names.get(i)).isEmpty()) {
                    nameTmp = "att-" + n;
                    continue;
                }
                nameTmp = (String)names.get(i) + "-" + n;
            }
            System.err.println("Column #" + i + " required disambiguating: '" + (String)names.get(i) + "' -> '" + nameTmp + "'");
            namesSet.add(nameTmp);
            names.set(i, nameTmp);
        }
        HashMap<String, Integer> attIndex = new HashMap<String, Integer>();
        for (String name : names) {
            attIndex.put(name, attIndex.size());
        }
        this.m_Types = new AttributeType[this.m_Records.get(0).size()];
        this.m_NominalRange.setUpper(this.m_Types.length - 1);
        this.m_StringRange.setUpper(this.m_Types.length - 1);
        this.m_DateRange.setUpper(this.m_Types.length - 1);
        boolean hasNominalValues = false;
        HashMap<Integer, AbstractCollection> nominalValues = new HashMap<Integer, AbstractCollection>();
        HashMap<Integer, Boolean> sortLabels = new HashMap<Integer, Boolean>();
        for (i = 0; i < this.m_Types.length; ++i) {
            this.m_Types[i] = AttributeType.NUMERIC;
            if (this.m_NominalRange.isInRange(i)) {
                this.m_Types[i] = AttributeType.NOMINAL;
                hasNominalValues = true;
                continue;
            }
            if (this.m_StringRange.isInRange(i)) {
                this.m_Types[i] = AttributeType.STRING;
                continue;
            }
            if (!this.m_DateRange.isInRange(i)) continue;
            this.m_Types[i] = AttributeType.DATE;
        }
        if (numRows == 1 && !this.m_NoHeader) {
            for (i = 0; i < names.size(); ++i) {
                atts.add(new Attribute((String)names.get(i)));
            }
            this.initInstances(atts, 0);
            return false;
        }
        for (n = this.m_FirstDataRow; n < this.m_Records.size(); ++n) {
            boolean noNumeric = true;
            for (i = 0; i < this.m_Types.length && i < this.m_Records.get(n).size(); ++i) {
                if (this.m_Types[i] != AttributeType.NUMERIC) continue;
                noNumeric = false;
                cell = this.m_Records.get(n).get(i);
                if (cell.equals(this.m_MissingValue) || this.isNumeric(cell)) continue;
                this.m_Types[i] = AttributeType.STRING;
            }
            if (noNumeric) break;
        }
        if (hasNominalValues) {
            for (n = this.m_FirstDataRow; n < this.m_Records.size(); ++n) {
                for (i = 0; i < this.m_Types.length && i < this.m_Records.get(n).size(); ++i) {
                    if (this.m_Types[i] != AttributeType.NOMINAL) continue;
                    if (!nominalValues.containsKey(i)) {
                        nominalValues.put(i, new HashSet());
                        sortLabels.put(i, true);
                    }
                    if ((cell = this.m_Records.get(n).get(i)).equals(this.m_MissingValue)) continue;
                    ((Collection)nominalValues.get(i)).add(cell);
                }
            }
        }
        for (String labelSpec : this.m_nominalLabelSpecs) {
            String[] parts = labelSpec.split(":");
            if (parts.length != 2) {
                throw new IllegalStateException("Invalid label specification (required: 'indices/names:list,of,labels'): " + labelSpec);
            }
            labels = new ArrayList<String>(Arrays.asList(parts[1].split(DEFAULT_CUSTOM_FIELD_SEPARATOR)));
            try {
                Range specRange = new Range(parts[0]);
                specRange.setUpper(this.m_Types.length + 1);
                for (int index : specRange.getSelection()) {
                    nominalValues.put(index, labels);
                    sortLabels.put(index, false);
                    this.m_Types[index] = AttributeType.NOMINAL;
                }
            }
            catch (Exception e) {
                String[] attList;
                for (String name : attList = parts[0].split(DEFAULT_CUSTOM_FIELD_SEPARATOR)) {
                    i = (Integer)attIndex.get(name);
                    nominalValues.put(i, labels);
                    sortLabels.put(i, false);
                    this.m_Types[i] = AttributeType.NOMINAL;
                }
            }
        }
        block23: for (i = 0; i < names.size(); ++i) {
            switch (this.m_Types[i]) {
                case NUMERIC: {
                    atts.add(new Attribute((String)names.get(i)));
                    continue block23;
                }
                case NOMINAL: {
                    labels = new ArrayList((Collection)nominalValues.get(i));
                    if (((Boolean)sortLabels.get(i)).booleanValue()) {
                        Collections.sort(labels);
                    }
                    atts.add(new Attribute((String)names.get(i), labels));
                    continue block23;
                }
                case STRING: {
                    atts.add(new Attribute((String)names.get(i), (List)null));
                    continue block23;
                }
                case DATE: {
                    atts.add(new Attribute((String)names.get(i), this.m_DateFormat));
                    continue block23;
                }
                default: {
                    throw new IllegalStateException("Unhandled attribute type: " + (Object)((Object)this.m_Types[i]));
                }
            }
        }
        this.initInstances(atts, this.m_Records.size());
        return true;
    }

    protected Instance parseNext() throws Exception {
        CSVRecord record = this.nextRecord();
        if (record == null) {
            return null;
        }
        double[] values = new double[this.m_Types.length];
        block6: for (int i = 0; i < this.m_Types.length && i < record.size(); ++i) {
            String cell = record.get(i);
            if (cell.equals(this.m_MissingValue)) {
                values[i] = Utils.missingValue();
                continue;
            }
            switch (this.m_Types[i]) {
                case NUMERIC: {
                    values[i] = Double.parseDouble(cell);
                    continue block6;
                }
                case NOMINAL: {
                    values[i] = this.m_Data.attribute(i).indexOfValue(cell);
                    continue block6;
                }
                case STRING: {
                    values[i] = this.m_Data.attribute(i).addStringValue(cell);
                    continue block6;
                }
                case DATE: {
                    values[i] = this.m_Data.attribute(i).parseDate(cell);
                    continue block6;
                }
                default: {
                    throw new IllegalStateException("Unhandled attribute type: " + (Object)((Object)this.m_Types[i]));
                }
            }
        }
        return new DenseInstance(1.0, values);
    }

    public Instances getStructure() throws IOException {
        if (this.m_sourceReader == null) {
            throw new IOException("No source has been specified");
        }
        if (this.m_structure != null) {
            return new Instances(this.m_structure, 0);
        }
        try {
            this.initParser();
            if (!this.initStructure()) {
                System.err.println("Cannot add data after initialization of structure!");
            }
            return new Instances(this.m_structure, 0);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Instances getDataSet() throws IOException {
        if (this.m_sourceReader == null) {
            throw new IOException("No source has been specified");
        }
        if (this.getRetrieval() == 2) {
            throw new IOException("Cannot mix getting Instances in both incremental and batch modes");
        }
        this.setRetrieval(1);
        if (this.m_structure == null) {
            this.getStructure();
        }
        try {
            Instance inst;
            while ((inst = this.parseNext()) != null) {
                this.m_Data.add(inst);
            }
        }
        catch (Exception e) {
            throw new IOException("Failed to parse data row!", e);
        }
        finally {
            try {
                this.m_sourceReader.close();
            }
            catch (Exception exception) {}
        }
        return this.m_Data;
    }

    public Instance getNextInstance(Instances structure) throws IOException {
        try {
            return this.parseNext();
        }
        catch (Exception e) {
            throw new IOException("Failed to parse data row!", e);
        }
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 1 $");
    }

    public static void main(String[] args) {
        CommonCSVLoader.runFileLoader((AbstractFileLoader)new CommonCSVLoader(), (String[])args);
    }

    public static enum AttributeType {
        NUMERIC,
        NOMINAL,
        STRING,
        DATE;

    }
}

