/*
 * Decompiled with CFR 0.152.
 */
package weka.core.converters;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.SelectedTag;
import weka.core.Tag;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;
import weka.core.converters.AbstractFileSaver;
import weka.core.converters.BatchConverter;
import weka.core.converters.CommonCSVLoader;
import weka.core.converters.CommonCsvFormats;
import weka.core.converters.CommonCsvQuoteModes;
import weka.core.converters.IncrementalConverter;

public class CommonCSVSaver
extends AbstractFileSaver
implements BatchConverter,
IncrementalConverter,
WeightedInstancesHandler {
    private static final long serialVersionUID = -7226404765213522043L;
    protected int m_Format = 1;
    protected boolean m_UseCustomFieldSeparator = false;
    public static final String DEFAULT_CUSTOM_FIELD_SEPARATOR = ",";
    protected String m_CustomFieldSeparator = ",";
    protected boolean m_UseCustomQuoteCharacter = false;
    public static final String DEFAULT_CUSTOM_QUOTE_CHARACTER = "\"";
    protected String m_CustomQuoteCharacter = "\"";
    protected boolean m_UseCustomQuoteMode = false;
    public static final int DEFAULT_CUSTOM_QUOTE_MODE = 2;
    protected int m_CustomQuoteMode = 2;
    protected boolean m_UseCustomEscapeCharacter = false;
    public static final String DEFAULT_CUSTOM_ESCAPE_CHARACTER = "";
    protected String m_CustomEscapeCharacter = "";
    protected boolean m_NoHeader = false;
    protected transient CSVPrinter m_Printer;

    public CommonCSVSaver() {
        this.resetOptions();
    }

    public String globalInfo() {
        return "Writes to a destination that is in the specified CSV format.";
    }

    public void setFormat(SelectedTag value) {
        if (value.getTags() == CommonCsvFormats.TAGS_FORMATS) {
            this.m_Format = value.getSelectedTag().getID();
        }
    }

    public SelectedTag getFormat() {
        return new SelectedTag(this.m_Format, CommonCsvFormats.TAGS_FORMATS);
    }

    public String formatTipText() {
        return "The format of the CSV file.";
    }

    public void setUseCustomFieldSeparator(boolean value) {
        this.m_UseCustomFieldSeparator = value;
    }

    public boolean getUseCustomFieldSeparator() {
        return this.m_UseCustomFieldSeparator;
    }

    public String useCustomFieldSeparatorTipText() {
        return "If enabled, makes use of the supplied field separator.";
    }

    public void setCustomFieldSeparator(String value) {
        if (value.length() == 1) {
            this.m_CustomFieldSeparator = value;
        } else {
            System.err.println("Field separator must be 1 character long!");
        }
    }

    public String getCustomFieldSeparator() {
        return this.m_CustomFieldSeparator;
    }

    public String customFieldSeparatorTipText() {
        return "The field separator, when using custom one is enabled.";
    }

    public void setUseCustomQuoteCharacter(boolean value) {
        this.m_UseCustomQuoteCharacter = value;
    }

    public boolean getUseCustomQuoteCharacter() {
        return this.m_UseCustomQuoteCharacter;
    }

    public String useCustomQuoteCharacterTipText() {
        return "If enabled, makes use of the supplied quote character.";
    }

    public void setCustomQuoteCharacter(String value) {
        if (value.length() == 1) {
            this.m_CustomQuoteCharacter = value;
        } else {
            System.err.println("Quote character must be 1 character long!");
        }
    }

    public String getCustomQuoteCharacter() {
        return this.m_CustomQuoteCharacter;
    }

    public String customQuoteCharacterTipText() {
        return "The quote character, when using custom one is enabled.";
    }

    public void setUseCustomQuoteMode(boolean value) {
        this.m_UseCustomQuoteMode = value;
    }

    public boolean getUseCustomQuoteMode() {
        return this.m_UseCustomQuoteMode;
    }

    public String useCustomQuoteModeTipText() {
        return "If enabled, makes use of the supplied quote mode.";
    }

    public void setCustomQuoteMode(SelectedTag value) {
        if (value.getTags() == CommonCsvQuoteModes.TAGS_QUOTEMODES) {
            this.m_CustomQuoteMode = value.getSelectedTag().getID();
        }
    }

    public SelectedTag getCustomQuoteMode() {
        return new SelectedTag(this.m_CustomQuoteMode, CommonCsvQuoteModes.TAGS_QUOTEMODES);
    }

    public String customQuoteModeTipText() {
        return "The quote mode, when using custom one is enabled.";
    }

    public void setUseCustomEscapeCharacter(boolean value) {
        this.m_UseCustomEscapeCharacter = value;
    }

    public boolean getUseCustomEscapeCharacter() {
        return this.m_UseCustomEscapeCharacter;
    }

    public String useCustomEscapeCharacterTipText() {
        return "If enabled, makes use of the supplied escape character.";
    }

    public void setCustomEscapeCharacter(String value) {
        this.m_CustomEscapeCharacter = value;
    }

    public String getCustomEscapeCharacter() {
        return this.m_CustomEscapeCharacter;
    }

    public String customEscapeCharacterTipText() {
        return "The escape character, when using custom one is enabled.";
    }

    public void setNoHeader(boolean value) {
        this.m_NoHeader = value;
    }

    public boolean getNoHeader() {
        return this.m_NoHeader;
    }

    public String noHeaderTipText() {
        return "If enabled, suppresses header output.";
    }

    public Enumeration listOptions() {
        Vector result = new Vector();
        Enumeration enm = super.listOptions();
        while (enm.hasMoreElements()) {
            result.add(enm.nextElement());
        }
        result.addElement(new Option("\tThe CSV format to use\n\t(default: DEFAULT)", "F", 1, "-F " + Tag.toOptionList((Tag[])CommonCsvFormats.TAGS_FORMATS)));
        result.addElement(new Option("\tWhether to use custom field separator\n\t(default: no)", "use-custom-field-separator", 0, "-use-custom-field-separator"));
        result.addElement(new Option("\tThe custom field separator\n\t(default: ,)", "custom-field-separator", 1, "-custom-field-separator <separator-char>"));
        result.addElement(new Option("\tWhether to use custom quote character\n\t(default: no)", "use-custom-quote-character", 0, "-use-custom-quote-character"));
        result.addElement(new Option("\tThe custom quote character\n\t(default: \")", "custom-quote-character", 1, "-custom-quote-character <quote-char>"));
        result.addElement(new Option("\tWhether to use custom quote mode\n\t(default: no)", "use-custom-quote-mode", 0, "-use-custom-quote-mode"));
        result.addElement(new Option("\tThe custom quote mode\n\t(default: MINIMAL)", "custom-quote-mode", 1, "-custom-quote-mode " + Tag.toOptionList((Tag[])CommonCsvQuoteModes.TAGS_QUOTEMODES)));
        result.addElement(new Option("\tWhether to use custom escape character\n\t(default: no)", "use-custom-escape-character", 0, "-use-custom-escape-character"));
        result.addElement(new Option("\tThe custom escape character\n\t(default: )", "custom-escape-character", 1, "-custom-escape-character <escape-char>"));
        result.addElement(new Option("\tWhether to suppress output of header row\n\t(default: outputs header)", "no-header", 0, "-no-header"));
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String tmp = Utils.getOption((char)'F', (String[])options);
        if (!tmp.isEmpty()) {
            this.setFormat(new SelectedTag(tmp, CommonCsvFormats.TAGS_FORMATS));
        } else {
            this.setFormat(new SelectedTag(1, CommonCsvFormats.TAGS_FORMATS));
        }
        this.setUseCustomFieldSeparator(Utils.getFlag((String)"use-custom-field-separator", (String[])options));
        tmp = Utils.getOption((String)"custom-field-separator", (String[])options);
        if (!tmp.isEmpty() && tmp.length() == 1) {
            this.setCustomFieldSeparator(tmp);
        } else {
            this.setCustomFieldSeparator(DEFAULT_CUSTOM_FIELD_SEPARATOR);
        }
        this.setUseCustomQuoteCharacter(Utils.getFlag((String)"use-custom-quote-character", (String[])options));
        tmp = Utils.getOption((String)"custom-quote-character", (String[])options);
        if (!tmp.isEmpty() && tmp.length() == 1) {
            this.setCustomQuoteCharacter(tmp);
        } else {
            this.setCustomQuoteCharacter(DEFAULT_CUSTOM_QUOTE_CHARACTER);
        }
        this.setUseCustomQuoteMode(Utils.getFlag((String)"use-custom-quote-mode", (String[])options));
        tmp = Utils.getOption((String)"custom-quote-mode", (String[])options);
        if (!tmp.isEmpty()) {
            this.setCustomQuoteMode(new SelectedTag(tmp, CommonCsvQuoteModes.TAGS_QUOTEMODES));
        } else {
            this.setCustomQuoteMode(new SelectedTag(2, CommonCsvQuoteModes.TAGS_QUOTEMODES));
        }
        this.setUseCustomEscapeCharacter(Utils.getFlag((String)"use-custom-escape-character", (String[])options));
        tmp = Utils.getOption((String)"custom-escape-character", (String[])options);
        this.setCustomEscapeCharacter(tmp);
        this.setNoHeader(Utils.getFlag((String)"no-header", (String[])options));
        super.setOptions(options);
        Utils.checkForRemainingOptions((String[])options);
    }

    public String[] getOptions() {
        ArrayList<String> result = new ArrayList<String>(Arrays.asList(super.getOptions()));
        result.add("-F");
        result.add(this.getFormat().getSelectedTag().getIDStr());
        if (this.getUseCustomFieldSeparator()) {
            result.add("-use-custom-field-separator");
            result.add("-custom-field-separator");
            result.add(this.getCustomFieldSeparator());
        }
        if (this.getUseCustomQuoteCharacter()) {
            result.add("-use-custom-quote-character");
            result.add("-custom-quote-character");
            result.add(this.getCustomQuoteCharacter());
        }
        if (this.getUseCustomQuoteMode()) {
            result.add("-use-custom-quote-mode");
            result.add("-custom-quote-mode");
            result.add(this.getCustomQuoteMode().getSelectedTag().getIDStr());
        }
        if (this.getUseCustomEscapeCharacter()) {
            result.add("-use-custom-escape-character");
            result.add("-custom-escape-character");
            result.add(this.getCustomEscapeCharacter());
        }
        if (this.getNoHeader()) {
            result.add("-no-header");
        }
        return result.toArray(new String[0]);
    }

    public String getFileDescription() {
        return new CommonCSVLoader().getFileDescription();
    }

    public String[] getFileExtensions() {
        return new CommonCSVLoader().getFileExtensions();
    }

    public void resetOptions() {
        super.resetOptions();
        this.m_Format = 1;
        this.setFileExtension(".csv");
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    public void resetWriter() {
        super.resetWriter();
        this.m_Printer = null;
    }

    protected void initPrinter() throws IOException {
        CSVFormat format = CommonCsvFormats.getFormat(this.m_Format);
        if (this.m_Format != 10 && this.m_UseCustomFieldSeparator) {
            format = format.withDelimiter(this.m_CustomFieldSeparator.charAt(0));
        }
        if (this.m_UseCustomQuoteCharacter) {
            format = format.withQuote(this.m_CustomQuoteCharacter.charAt(0));
        }
        if (this.m_UseCustomQuoteMode) {
            format = format.withQuoteMode(CommonCsvQuoteModes.getQuoteMode(this.m_CustomQuoteMode));
        }
        if (this.m_UseCustomEscapeCharacter && this.m_CustomEscapeCharacter.length() == 1) {
            format = format.withEscape(this.m_CustomEscapeCharacter.charAt(0));
        }
        this.m_Printer = this.getWriter() != null ? format.print((Appendable)this.getWriter()) : format.print((Appendable)System.out);
    }

    protected void writeHeader(Instances data) throws IOException {
        ArrayList<String> values = new ArrayList<String>();
        for (int i = 0; i < data.numAttributes(); ++i) {
            values.add(data.attribute(i).name());
        }
        if (!this.m_NoHeader) {
            this.m_Printer.printRecord(values);
        }
    }

    protected void writeRow(Instance inst) throws IOException {
        ArrayList<Object> values = new ArrayList<Object>();
        block5: for (int i = 0; i < inst.numAttributes(); ++i) {
            if (inst.isMissing(i)) continue;
            switch (inst.attribute(i).type()) {
                case 0: 
                case 3: {
                    values.add(inst.value(i));
                    continue block5;
                }
                case 1: 
                case 2: {
                    values.add(inst.stringValue(i));
                    continue block5;
                }
                case 4: {
                    values.add(inst.relationalValue(i).toString());
                }
            }
        }
        this.m_Printer.printRecord(values);
    }

    public void writeBatch() throws IOException {
        if (this.getInstances() == null) {
            throw new IOException("No instances to save");
        }
        if (this.getRetrieval() == 2) {
            throw new IOException("Batch and incremental saving cannot be mixed.");
        }
        this.setRetrieval(1);
        this.setWriteMode(0);
        this.initPrinter();
        Instances data = this.getInstances();
        this.writeHeader(data);
        for (int n = 0; n < data.numInstances(); ++n) {
            this.writeRow(data.instance(n));
        }
        this.m_Printer.flush();
        this.m_Printer.close();
        this.setWriteMode(1);
        this.resetWriter();
        this.setWriteMode(2);
    }

    public void writeIncremental(Instance inst) throws IOException {
        int writeMode = this.getWriteMode();
        Instances structure = this.getInstances();
        if (this.getRetrieval() == 1 || this.getRetrieval() == 0) {
            throw new IOException("Batch and incremental saving cannot be mixed.");
        }
        this.initPrinter();
        if (writeMode == 1) {
            if (structure == null) {
                this.setWriteMode(2);
                if (inst != null) {
                    System.err.println("Structure(Header Information) has to be set in advance");
                }
            } else {
                this.setWriteMode(3);
            }
            writeMode = this.getWriteMode();
        }
        if (writeMode == 2) {
            if (this.m_Printer != null) {
                this.m_Printer.flush();
                this.m_Printer.close();
            }
            this.cancel();
        }
        if (writeMode == 3) {
            this.setWriteMode(0);
            this.writeHeader(structure);
            writeMode = this.getWriteMode();
        }
        if (writeMode == 0) {
            if (structure == null) {
                throw new IOException("No instances information available.");
            }
            if (inst != null) {
                this.writeRow(inst);
                this.m_Printer.flush();
            } else {
                if (this.m_Printer != null) {
                    this.m_Printer.flush();
                    this.m_Printer.close();
                }
                this.m_incrementalCounter = 0;
                this.resetStructure();
                this.m_Printer = null;
                this.resetWriter();
            }
        }
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 1 $");
    }

    public static void main(String[] args) {
        CommonCSVSaver.runFileSaver((AbstractFileSaver)new CommonCSVSaver(), (String[])args);
    }
}

