/*
 * Decompiled with CFR 0.152.
 */
package weka.core.converters;

import org.apache.commons.csv.CSVFormat;
import weka.core.Tag;

public class CommonCsvFormats {
    public static final int DEFAULT = 1;
    public static final int EXCEL = 2;
    public static final int INFORMIX_UNLOAD = 3;
    public static final int INFORMIX_UNLOAD_CSV = 4;
    public static final int MYSQL = 5;
    public static final int ORACLE = 6;
    public static final int POSTGRESSQL_CSV = 7;
    public static final int POSTGRESSQL_TEXT = 8;
    public static final int RFC_4180 = 9;
    public static final int TDF = 10;
    public static final Tag[] TAGS_FORMATS = new Tag[]{new Tag(1, "DEFAULT", "Default"), new Tag(2, "EXCEL", "Excel"), new Tag(3, "INFORMIX", "Informix (unload)"), new Tag(4, "INFORMIXCSV", "Informix (unload CSV)"), new Tag(5, "MYSQL", "MySQL"), new Tag(6, "ORACLE", "Oracle"), new Tag(7, "POSTGRESQLCSV", "PostgreSQL (CSV)"), new Tag(8, "POSTGRESQLTXT", "PostgreSQL (Text)"), new Tag(9, "RFC4180", "RFC-4180"), new Tag(10, "TDF", "TDF (tab-delimited)")};

    public static CSVFormat getFormat(int id) {
        switch (id) {
            case 1: {
                return CSVFormat.DEFAULT;
            }
            case 2: {
                return CSVFormat.EXCEL;
            }
            case 3: {
                return CSVFormat.INFORMIX_UNLOAD;
            }
            case 4: {
                return CSVFormat.INFORMIX_UNLOAD_CSV;
            }
            case 5: {
                return CSVFormat.MYSQL;
            }
            case 6: {
                return CSVFormat.ORACLE;
            }
            case 7: {
                return CSVFormat.POSTGRESQL_CSV;
            }
            case 8: {
                return CSVFormat.POSTGRESQL_TEXT;
            }
            case 9: {
                return CSVFormat.RFC4180;
            }
            case 10: {
                return CSVFormat.TDF;
            }
        }
        throw new IllegalStateException("Unhandled format: " + id);
    }
}

