/*
 * Decompiled with CFR 0.152.
 */
package weka.core.converters;

import org.apache.commons.csv.QuoteMode;
import weka.core.Tag;

public class CommonCsvQuoteModes {
    public static final int ALL = 0;
    public static final int ALL_NON_NULL = 1;
    public static final int MINIMAL = 2;
    public static final int NON_NUMERIC = 3;
    public static final int NONE = 4;
    public static final Tag[] TAGS_QUOTEMODES = new Tag[]{new Tag(0, "ALL", "All"), new Tag(1, "ALL_NON_NULL", "All non-null"), new Tag(2, "MINIMAL", "Minimal"), new Tag(3, "NON_NUMERIC", "Non-numeric"), new Tag(4, "NONE", "None")};

    public static QuoteMode getQuoteMode(int id) {
        switch (id) {
            case 0: {
                return QuoteMode.ALL;
            }
            case 1: {
                return QuoteMode.ALL_NON_NULL;
            }
            case 2: {
                return QuoteMode.MINIMAL;
            }
            case 3: {
                return QuoteMode.NON_NUMERIC;
            }
            case 4: {
                return QuoteMode.NONE;
            }
        }
        throw new IllegalStateException("Unhandled quote mode: " + id);
    }
}

