/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute.attributeweightsmodifiers;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Range;
import weka.core.Utils;
import weka.filters.unsupervised.attribute.attributeweightsmodifiers.AbstractAttributeWeightsModifier;

public abstract class AbstractRangeBasedAttributeWeightsModifier
extends AbstractAttributeWeightsModifier {
    private static final long serialVersionUID = -6347414272696310567L;
    protected Range m_AttributeIndices = new Range("first-last");

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tThe attribute range to work on.\nThis is a comma separated list of attribute indices, with \"first\" and \"last\" valid values.\n\tSpecify an inclusive range with \"-\".\n\tE.g: \"first-3,5,6-10,last\".\n\t(default: first-last)", "R", 1, "-R <range>"));
        result.addAll(Collections.list(super.listOptions()));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption((String)"R", (String[])options);
        if (tmpStr.length() != 0) {
            this.setAttributeIndices(tmpStr);
        } else {
            this.setAttributeIndices("first-last");
        }
        super.setOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-R");
        result.add(this.getAttributeIndices());
        Collections.addAll(result, super.getOptions());
        return result.toArray(new String[result.size()]);
    }

    public void setAttributeIndices(String value) {
        this.m_AttributeIndices.setRanges(value);
    }

    public String getAttributeIndices() {
        return this.m_AttributeIndices.getRanges();
    }

    public String attributeIndicesTipText() {
        return "Specify range of attributes to act on; this is a comma separated list of attribute indices, with \"first\" and \"last\" valid values; specify an inclusive range with \"-\"; eg: \"first-3,5,6-10,last\".";
    }

    @Override
    protected void check(Instances data) throws Exception {
        super.check(data);
        this.m_AttributeIndices.setUpper(data.numAttributes() - 1);
    }
}

