/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.instance;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Utils;
import weka.filters.SimpleBatchFilter;
import weka.filters.unsupervised.instance.instanceweightsmodifiers.InstanceWeightsModifier;
import weka.filters.unsupervised.instance.instanceweightsmodifiers.PassThrough;

public class ModifyInstanceWeights
extends SimpleBatchFilter {
    private static final long serialVersionUID = 9140334137670320734L;
    protected InstanceWeightsModifier m_Modifier = new PassThrough();

    public String globalInfo() {
        return "Applies a scheme for modifying the weights of the attributes.";
    }

    public Enumeration<Option> listOptions() {
        Vector<Object> result = new Vector<Object>();
        result.addElement(new Option("\tThe attribute weights modifier to use.\n\t(default: " + PassThrough.class.getName() + ")", "modifier", 1, "-modifier <classname + options>"));
        result.addAll(Collections.list(super.listOptions()));
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption((String)"modifier", (String[])options);
        if (tmpStr.length() != 0) {
            String[] classOptions = Utils.splitOptions((String)tmpStr);
            String className = classOptions[0];
            classOptions[0] = "";
            this.setModifier((InstanceWeightsModifier)Utils.forName(InstanceWeightsModifier.class, (String)className, (String[])classOptions));
        } else {
            this.setModifier(new PassThrough());
        }
        super.setOptions(options);
    }

    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-modifier");
        result.add(Utils.toCommandLine((Object)this.getModifier()));
        Collections.addAll(result, super.getOptions());
        return result.toArray(new String[result.size()]);
    }

    public void setModifier(InstanceWeightsModifier value) {
        this.m_Modifier = value;
    }

    public InstanceWeightsModifier getModifier() {
        return this.m_Modifier;
    }

    public String modifierTipText() {
        return "The weights modifier to apply to the data.";
    }

    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        return this.m_Modifier.determineOutputFormat(inputFormat);
    }

    protected Instances process(Instances instances) throws Exception {
        return this.m_Modifier.modifyInstanceWeights(instances);
    }
}

