/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.instance.instanceweightsmodifiers;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Utils;
import weka.filters.unsupervised.instance.instanceweightsmodifiers.InstanceWeightsModifier;

public abstract class AbstractInstanceWeightsModifier
implements Serializable,
OptionHandler,
InstanceWeightsModifier,
CapabilitiesHandler {
    private static final long serialVersionUID = -7927301115335139138L;
    protected boolean m_DoNotCheckCapabilities = false;

    public abstract String globalInfo();

    public Enumeration<Option> listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tIf set, modifier capabilities are not checked\n\t(use with caution).", "do-not-check-capabilities", 0, "-do-not-check-capabilities"));
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        this.setDoNotCheckCapabilities(Utils.getFlag((String)"do-not-check-capabilities", (String[])options));
        Utils.checkForRemainingOptions((String[])options);
    }

    public String[] getOptions() {
        Vector<String> options = new Vector<String>();
        if (this.getDoNotCheckCapabilities()) {
            options.add("-do-not-check-capabilities");
        }
        return options.toArray(new String[options.size()]);
    }

    public void setDoNotCheckCapabilities(boolean value) {
        this.m_DoNotCheckCapabilities = value;
    }

    public boolean getDoNotCheckCapabilities() {
        return this.m_DoNotCheckCapabilities;
    }

    public String doNotCheckCapabilitiesTipText() {
        return "If set, modifier capabilities are not checked (use with caution to reduce runtime).";
    }

    public Capabilities getCapabilities() {
        Capabilities result = new Capabilities((CapabilitiesHandler)this);
        result.enableAll();
        result.setMinimumNumberInstances(0);
        return result;
    }

    public Capabilities getCapabilities(Instances data) {
        Capabilities result = this.getCapabilities();
        if (data.classIndex() == -1) {
            Capabilities classes = result.getClassCapabilities();
            Iterator iter = classes.capabilities();
            while (iter.hasNext()) {
                Capabilities.Capability cap = (Capabilities.Capability)iter.next();
                if (cap == Capabilities.Capability.NO_CLASS) continue;
                result.disable(cap);
                result.disableDependency(cap);
            }
        } else {
            result.disable(Capabilities.Capability.NO_CLASS);
            result.disableDependency(Capabilities.Capability.NO_CLASS);
        }
        return result;
    }

    protected void check(Instances data) throws Exception {
        if (data == null) {
            throw new IllegalStateException("No data provided!");
        }
        if (!this.m_DoNotCheckCapabilities) {
            try {
                this.getCapabilities(data).testWithFail(data);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    protected abstract Instances doModify(Instances var1) throws Exception;

    @Override
    public Instances modifyInstanceWeights(Instances data) throws Exception {
        this.check(data);
        return this.doModify(data);
    }
}

