/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.instance.instanceweightsmodifiers;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Utils;
import weka.filters.unsupervised.instance.instanceweightsmodifiers.AbstractRangeBasedInstanceWeightsModifier;

public class FixedValue
extends AbstractRangeBasedInstanceWeightsModifier {
    private static final long serialVersionUID = 4432458832078542477L;
    protected double m_Weight = 1.0;

    @Override
    public String globalInfo() {
        return "Uses a user-supplied instance weight on all the instances in the defined range.";
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tThe instance weight to use.\n\t(default: 1.0)", "weight", 1, "-weight <number>"));
        result.addAll(Collections.list(super.listOptions()));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption((String)"weight", (String[])options);
        if (tmpStr.length() != 0) {
            this.setWeight(Double.parseDouble(tmpStr));
        } else {
            this.setWeight(1.0);
        }
        super.setOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-weight");
        result.add("" + this.getWeight());
        Collections.addAll(result, super.getOptions());
        return result.toArray(new String[result.size()]);
    }

    public void setWeight(double value) {
        this.m_Weight = value;
    }

    public double getWeight() {
        return this.m_Weight;
    }

    public String weightTipText() {
        return "The weight to use.";
    }

    @Override
    public Instances determineOutputFormat(Instances inputFormat) throws Exception {
        return new Instances(inputFormat, 0);
    }

    @Override
    protected Instances doModify(Instances data) throws Exception {
        Instances result = new Instances(this.determineOutputFormat(data), data.numInstances());
        for (int i = 0; i < data.numInstances(); ++i) {
            Instance inst = (Instance)data.instance(i).copy();
            if (this.m_RowIndices.isInRange(i)) {
                inst.setWeight(this.m_Weight);
            }
            result.add(inst);
        }
        return result;
    }
}

