/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.instance.instanceweightsmodifiers;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.SingleIndex;
import weka.core.Utils;
import weka.filters.unsupervised.instance.instanceweightsmodifiers.AbstractInstanceWeightsModifier;

public class FromAttribute
extends AbstractInstanceWeightsModifier {
    private static final long serialVersionUID = -5716918435393494286L;
    protected SingleIndex m_AttributeIndex = new SingleIndex("last");

    @Override
    public String globalInfo() {
        return "Uses the values from a numeric attribute as instance weights.";
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tSpecify the index of the attribute with the weights. First and last\n\tare valid indexes.(default: last)", "C", 1, "-C <index>"));
        result.addAll(Collections.list(super.listOptions()));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption((char)'C', (String[])options);
        if (tmpStr.isEmpty()) {
            tmpStr = "last";
        }
        this.setAttributeIndex(tmpStr);
        super.setOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-C");
        result.add("" + this.getAttributeIndex());
        Collections.addAll(result, super.getOptions());
        return result.toArray(new String[result.size()]);
    }

    public void setAttributeIndex(String value) {
        this.m_AttributeIndex.setSingleIndex(value);
    }

    public String getAttributeIndex() {
        return this.m_AttributeIndex.getSingleIndex();
    }

    public String attributeIndexTipText() {
        return "The position (starting from 1) of the attribute with the weights (first and last are valid indices).";
    }

    @Override
    protected void check(Instances data) throws Exception {
        super.check(data);
        this.m_AttributeIndex.setUpper(data.numAttributes() - 1);
        if (this.m_AttributeIndex.getIndex() == -1) {
            throw new IllegalArgumentException("Attribute index not valid: " + this.m_AttributeIndex.getSingleIndex());
        }
        if (!data.attribute(this.m_AttributeIndex.getIndex()).isNumeric()) {
            throw new IllegalArgumentException("Attribute is not numeric: " + this.m_AttributeIndex.getSingleIndex());
        }
    }

    @Override
    public Instances determineOutputFormat(Instances inputFormat) throws Exception {
        return new Instances(inputFormat, 0);
    }

    @Override
    protected Instances doModify(Instances data) throws Exception {
        Instances result = new Instances(this.determineOutputFormat(data), data.numInstances());
        int index = this.m_AttributeIndex.getIndex();
        for (int i = 0; i < data.numInstances(); ++i) {
            Instance inst = (Instance)data.instance(i).copy();
            inst.setWeight(inst.value(index));
            result.add(inst);
        }
        return result;
    }
}

