/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.instance.instanceweightsmodifiers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Utils;
import weka.filters.unsupervised.instance.instanceweightsmodifiers.AbstractInstanceWeightsModifier;

public class FromFile
extends AbstractInstanceWeightsModifier {
    private static final long serialVersionUID = -5716918435393494286L;
    protected File m_WeightsFile = new File(".");

    @Override
    public String globalInfo() {
        return "Uses the weights stored in a file (one weight per line).";
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tThe file with weights (one per line)\n\t(default: .)", "weights", 1, "-weights <file>"));
        result.addAll(Collections.list(super.listOptions()));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption((String)"weights", (String[])options);
        if (tmpStr.isEmpty()) {
            tmpStr = ".";
        }
        this.setWeightsFile(new File(tmpStr));
        super.setOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-weights");
        result.add("" + this.getWeightsFile());
        Collections.addAll(result, super.getOptions());
        return result.toArray(new String[result.size()]);
    }

    public void setWeightsFile(File value) {
        this.m_WeightsFile = value;
    }

    public File getWeightsFile() {
        return this.m_WeightsFile;
    }

    public String weightsFileTipText() {
        return "The file with the weights (one per line).";
    }

    @Override
    protected void check(Instances data) throws Exception {
        super.check(data);
        if (!this.m_WeightsFile.exists()) {
            throw new IllegalArgumentException("Weights file does not exist: " + this.m_WeightsFile);
        }
        if (this.m_WeightsFile.isDirectory()) {
            throw new IllegalArgumentException("Weights file points to a directory: " + this.m_WeightsFile);
        }
    }

    @Override
    public Instances determineOutputFormat(Instances inputFormat) throws Exception {
        return new Instances(inputFormat, 0);
    }

    protected List<Double> loadWeights() throws Exception {
        ArrayList<Double> result = new ArrayList<Double>();
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(this.m_WeightsFile));
            while ((line = reader.readLine()) != null) {
                result.add(Double.parseDouble(line));
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
        return result;
    }

    @Override
    protected Instances doModify(Instances data) throws Exception {
        List<Double> weights = this.loadWeights();
        if (weights.size() < data.numInstances()) {
            throw new IllegalStateException("Not enough weights: " + weights.size() + " < " + data.numInstances());
        }
        if (weights.size() > data.numInstances()) {
            System.err.println("More weights than rows: " + weights.size() + " > " + data.numInstances());
        }
        Instances result = new Instances(this.determineOutputFormat(data), data.numInstances());
        for (int i = 0; i < data.numInstances(); ++i) {
            Instance inst = (Instance)data.instance(i).copy();
            inst.setWeight(weights.get(i).doubleValue());
            result.add(inst);
        }
        return result;
    }
}

