/*
 * Decompiled with CFR 0.152.
 */
package net.sf.debianmaven;

import com.github.fracpete.processoutput4j.core.StreamingProcessOutputType;
import com.github.fracpete.processoutput4j.core.StreamingProcessOwner;
import com.github.fracpete.processoutput4j.output.CollectingProcessOutput;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;

public abstract class AbstractDebianMojo
extends AbstractMojo {
    private static final String SKIP_DEB_PROPERTY = "skipDeb";
    private static final String RUN_DEB_PROPERTY = "runDeb";
    protected String packageName;
    private String packageVersion;
    protected String packageRevision;
    protected String packageArchitecture;
    protected String maintainerName;
    protected String maintainerEmail;
    protected File sourceDir;
    protected File targetDir;
    protected File stageDir;
    private File snapshotRevisionFile = null;
    private static final DateFormat datefmt = new SimpleDateFormat("yyyyMMddHHmm");
    private String snapshotRevision = null;

    protected String processVersion(String version) {
        if (this.snapshotRevision == null) {
            Date revtime = this.snapshotRevisionFile != null ? new Date(this.snapshotRevisionFile.lastModified()) : new Date();
            this.snapshotRevision = "+" + datefmt.format(revtime);
        }
        return version.replaceAll("-SNAPSHOT", this.snapshotRevision);
    }

    protected String[] processVersion(String[] versions) {
        String[] result = new String[versions.length];
        for (int i = 0; i < versions.length; ++i) {
            result[i] = this.processVersion(versions[i]);
        }
        return result;
    }

    protected File newFile(File dir, String name) {
        return new File(dir.getAbsolutePath() + File.separator + name);
    }

    protected String getPackageVersion() {
        return this.processVersion(this.packageVersion);
    }

    protected File getPackageFile() {
        return this.newFile(this.targetDir, String.format("%s_%s-%s_all.deb", this.packageName, this.getPackageVersion(), this.packageRevision));
    }

    protected void runProcess(String[] cmd, boolean throw_on_failure) throws IOException, MojoExecutionException {
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        builder.command(cmd);
        this.getLog().info((CharSequence)("Start process: " + Arrays.asList(cmd)));
        try {
            CollectingProcessOutput output = new CollectingProcessOutput();
            output.monitor(builder);
            int exitval = output.getExitCode();
            if (exitval != 0) {
                this.getLog().warn((CharSequence)("Exit code: " + exitval));
                this.getLog().warn((CharSequence)("stderr:\n" + output.getStdErr()));
                this.getLog().warn((CharSequence)("stdout:\n" + output.getStdOut()));
                if (throw_on_failure) {
                    throw new MojoExecutionException("Process returned non-zero exit code: " + Arrays.asList(cmd));
                }
            }
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    protected abstract void executeDebMojo() throws MojoExecutionException;

    public final void execute() throws MojoExecutionException {
        if (System.getProperties().containsKey(RUN_DEB_PROPERTY)) {
            this.getLog().info((CharSequence)"debian-maven execution forced (-DrunDeb)");
            this.executeDebMojo();
        } else if (System.getProperties().containsKey(SKIP_DEB_PROPERTY)) {
            this.getLog().info((CharSequence)"debian-maven execution skipped (-DskipDeb)");
        } else if (!System.getProperty("os.name").equals("Linux")) {
            this.getLog().warn((CharSequence)"debian-maven execution skipped (non-linux OS)");
        } else {
            this.executeDebMojo();
        }
    }

    public static class LogOutput
    implements StreamingProcessOwner {
        private Log log;

        public LogOutput(Log log) {
            this.log = log;
        }

        public StreamingProcessOutputType getOutputType() {
            return StreamingProcessOutputType.BOTH;
        }

        public void processOutput(String line, boolean stdout) {
            if (stdout) {
                this.log.info((CharSequence)line);
            } else {
                this.log.error((CharSequence)line);
            }
        }
    }
}

