/*
 * Decompiled with CFR 0.152.
 */
package net.sf.debianmaven;

import com.github.fracpete.processoutput4j.output.CollectingProcessOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import net.sf.debianmaven.AbstractDebianMojo;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections15.multimap.MultiHashMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public class PackageMojo
extends AbstractDebianMojo {
    protected String packagePriority;
    protected String packageSection;
    protected String packageTitle;
    protected String packageDescription;
    protected String[] packageDependencies;
    protected String projectUrl;
    protected String projectOrganization;
    @Deprecated
    protected String includeJar;
    @Deprecated
    protected String[] includeJars;
    @Deprecated
    protected String excludeAllJars;
    protected Set<String> includeArtifacts;
    protected Set<String> excludeArtifacts;
    protected Set<String> excludeArtifactsRegExp;
    protected Set<Pattern> excludeArtifactsPattern;
    protected boolean excludeAllArtifacts;
    protected boolean excludeAllDependencies;
    protected boolean includeAttachedArtifacts;
    private MavenProject project;

    private File createTargetLibDir() {
        File targetLibDir = new File(this.stageDir, "usr/lib/" + this.packageName);
        targetLibDir.mkdirs();
        return targetLibDir;
    }

    private void createSymlink(File symlink, String target) throws MojoExecutionException, IOException {
        if (symlink.exists()) {
            symlink.delete();
        }
        this.runProcess(new String[]{"ln", "-s", target, symlink.toString()}, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeIncludeFile(File targetLibDir, String artifactId, String version, Collection<String> dependencies) throws IOException, MojoExecutionException {
        if (dependencies == null) {
            dependencies = Collections.emptySet();
        }
        File deplist = new File(targetLibDir, String.format("%s-%s.inc", artifactId, version));
        try (FileWriter out = new FileWriter(deplist);){
            out.write(String.format("artifacts=%s\n", StringUtils.join(new HashSet<String>(dependencies), (String)":")));
        }
        this.createSymlink(new File(targetLibDir, String.format("%s.inc", artifactId)), deplist.getName());
    }

    private Set<Pattern> getExcludeArtifactsPattern() {
        if (this.excludeArtifactsPattern == null) {
            this.excludeArtifactsPattern = new HashSet<Pattern>();
            if (this.excludeArtifactsRegExp != null) {
                for (String regexp : this.excludeArtifactsRegExp) {
                    try {
                        Pattern p = Pattern.compile(regexp);
                        this.excludeArtifactsPattern.add(p);
                    }
                    catch (Exception e) {
                        this.getLog().error((CharSequence)("Failed to parse excludeArtifactsPattern '" + regexp + "'!"), (Throwable)e);
                    }
                }
            }
        }
        return this.excludeArtifactsPattern;
    }

    private boolean includeArtifact(Artifact a) {
        boolean doExclude;
        boolean bl = doExclude = this.excludeArtifacts != null && (a.getDependencyTrail() == null || Collections.disjoint(a.getDependencyTrail(), this.excludeArtifacts));
        if (!doExclude && this.getExcludeArtifactsPattern().size() > 0) {
            for (Pattern p : this.getExcludeArtifactsPattern()) {
                String aStr;
                if (!p.matcher(aStr = a.getGroupId() + ":" + a.getArtifactId() + ":" + (a.hasClassifier() ? a.getClassifier() : "")).matches()) continue;
                this.getLog().debug((CharSequence)(aStr + " excluded using pattern: " + p.pattern()));
                doExclude = true;
                break;
            }
        }
        if (doExclude) {
            return false;
        }
        if (this.includeArtifacts == null) {
            return true;
        }
        if (a.getDependencyTrail() == null) {
            return true;
        }
        return Collections.disjoint(a.getDependencyTrail(), this.includeArtifacts);
    }

    private File copyArtifact(Artifact a, File targetLibDir) throws IOException, MojoExecutionException {
        if (a.getFile() == null) {
            throw new MojoExecutionException(String.format("No file was built for required artifact: %s:%s:%s", a.getGroupId(), a.getArtifactId(), a.getVersion()));
        }
        this.getLog().info((CharSequence)String.format("Artifact: %s", a.getFile().getPath()));
        File src = a.getFile();
        File trg = new File(targetLibDir, src.getName());
        FileUtils.copyFile((File)src, (File)trg);
        String linkname = src.getName().replaceFirst("-" + a.getBaseVersion(), "");
        if (linkname.equals(src.getName())) {
            linkname = linkname.replaceFirst("-" + a.getVersion(), "");
        }
        if (!linkname.equals(src.getName())) {
            this.createSymlink(new File(targetLibDir, linkname), a.getFile().getName());
        }
        return trg;
    }

    private void copyAttachedArtifacts() throws FileNotFoundException, IOException, MojoExecutionException {
        if (!this.includeAttachedArtifacts) {
            this.getLog().info((CharSequence)"Skipping attached project artifacts.");
            return;
        }
        this.getLog().info((CharSequence)"Copying attached project artifacts.");
        File targetLibDir = this.createTargetLibDir();
        for (Artifact a : this.project.getAttachedArtifacts()) {
            this.copyArtifact(a, targetLibDir);
        }
    }

    private void copyArtifacts() throws FileNotFoundException, IOException, MojoExecutionException {
        if (this.excludeAllArtifacts) {
            this.getLog().info((CharSequence)"Skipping regular project artifacts and dependencies.");
            return;
        }
        File targetLibDir = this.createTargetLibDir();
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        if (this.project.getArtifact().getFile() != null) {
            artifacts.add(this.project.getArtifact());
        }
        if (this.excludeAllDependencies) {
            this.getLog().info((CharSequence)"Copying regular project artifacts but not dependencies.");
        } else {
            this.getLog().info((CharSequence)"Copying regular project artifacts and dependencies.");
            for (Artifact a : this.project.getArtifacts()) {
                if (!a.getScope().equals("runtime") && !a.getScope().equals("compile")) continue;
                artifacts.add(a);
            }
        }
        HashMap<String, Artifact> ids = new HashMap<String, Artifact>();
        for (Artifact a : artifacts) {
            ids.put(a.getId(), a);
        }
        MultiHashMap deps = new MultiHashMap();
        for (Artifact a : artifacts) {
            if (!this.includeArtifact(a)) continue;
            File trg = this.copyArtifact(a, targetLibDir);
            if (a.getDependencyTrail() == null) continue;
            for (String id : a.getDependencyTrail()) {
                Artifact depending = (Artifact)ids.get(id);
                if (depending == null) continue;
                deps.put((Object)depending, (Object)trg.getPath().substring(this.stageDir.getPath().length()));
            }
        }
        for (Artifact a : artifacts) {
            if (!this.includeArtifact(a)) continue;
            this.writeIncludeFile(targetLibDir, a.getArtifactId(), a.getVersion(), deps.get((Object)a));
        }
    }

    private void generateCopyright() throws IOException {
        File targetDocDir = new File(this.stageDir, "usr/share/doc/" + this.packageName);
        targetDocDir.mkdirs();
        PrintWriter out = new PrintWriter(new FileWriter(new File(targetDocDir, "copyright")));
        out.println(this.packageName);
        out.println(this.projectUrl);
        out.println();
        out.printf("Copyright %d %s\n", Calendar.getInstance().get(1), this.projectOrganization);
        out.println();
        out.println("The entire code base may be distributed under the terms of the GNU General");
        out.println("Public License (GPL).");
        out.println();
        out.println("See /usr/share/common-licenses/GPL");
        out.close();
    }

    private void generateControl(File target) throws IOException {
        this.getLog().info((CharSequence)("Generating control file: " + target));
        PrintWriter out = new PrintWriter(new FileWriter(target));
        out.println("Package: " + this.packageName);
        out.println("Version: " + this.getPackageVersion());
        if (this.packageSection != null) {
            out.println("Section: " + this.packageSection);
        }
        if (this.packagePriority != null) {
            out.println("Priority: " + this.packagePriority);
        }
        out.println("Architecture: " + this.packageArchitecture);
        if (this.packageDependencies != null && this.packageDependencies.length > 0) {
            out.println("Depends: " + StringUtils.join((Object[])this.processVersion(this.packageDependencies), (String)", "));
        }
        out.printf("Installed-Size: %d\n", 1L + FileUtils.sizeOfDirectory((File)this.stageDir) / 1024L);
        if (this.maintainerName != null || this.maintainerEmail != null) {
            out.print("Maintainer:");
            if (this.maintainerName != null) {
                out.print(" " + this.maintainerName);
            }
            if (this.maintainerEmail != null) {
                out.printf(" <%s>", this.maintainerEmail);
            }
            out.println();
        }
        if (this.projectUrl != null) {
            out.println("Homepage: " + this.projectUrl);
        }
        if (this.packageTitle != null) {
            if (this.packageTitle.length() > 60) {
                this.getLog().warn((CharSequence)"Package title will be truncated to the upper limit of 60 characters.");
                out.println("Description: " + this.packageTitle.substring(0, 60));
            } else {
                out.println("Description: " + this.packageTitle);
            }
            out.println(this.getFormattedDescription());
        }
        out.close();
    }

    private String getFormattedDescription() {
        String desc = this.packageDescription.trim();
        desc.replaceAll("\\s+", " ");
        return " " + desc;
    }

    private void generateConffiles(File target) throws IOException {
        Vector<String> conffiles = new Vector<String>();
        File configDir = new File(this.stageDir, "etc");
        if (configDir.exists()) {
            Collection files = FileUtils.listFiles((File)configDir, null, (boolean)true);
            for (File f : files) {
                if (!f.isFile()) continue;
                conffiles.add(f.toString().substring(this.stageDir.toString().length()));
            }
        }
        if (conffiles.size() > 0) {
            PrintWriter out = new PrintWriter(new FileWriter(target));
            for (String fname : conffiles) {
                out.println(fname);
            }
            out.close();
        }
    }

    private void generateMd5Sums(File target) throws IOException {
        PrintWriter out = new PrintWriter(new FileWriter(target));
        Collection files = FileUtils.listFiles((File)this.stageDir, null, (boolean)true);
        for (File f : files) {
            String fname;
            if (!f.isFile() || !f.getAbsolutePath().equals(f.getCanonicalPath()) || (fname = f.toString().substring(this.stageDir.toString().length() + 1)).startsWith("DEBIAN")) continue;
            FileInputStream fis = new FileInputStream(f);
            String md5 = DigestUtils.md5Hex((InputStream)fis);
            fis.close();
            out.printf("%s  %s\n", md5, fname);
        }
        out.close();
    }

    private void generateManPages() throws MojoExecutionException, IOException {
        File source = new File(this.sourceDir, "man");
        if (!source.exists()) {
            this.getLog().info((CharSequence)("No manual page directory found: " + source));
            return;
        }
        int npages = 0;
        Collection files = FileUtils.listFiles((File)source, null, (boolean)true);
        for (File f : files) {
            block10: {
                if (!f.isFile() || !f.getName().matches(".*[.][1-9]$")) continue;
                char section = f.getName().charAt(f.getName().length() - 1);
                File target = new File(this.stageDir, String.format("usr/share/man/man%c/%s.gz", Character.valueOf(section), f.getName()));
                target.getParentFile().mkdirs();
                String[] cmd = new String[]{"groff", "-man", "-Tascii", f.getPath()};
                ProcessBuilder builder = new ProcessBuilder(new String[0]);
                builder.command(cmd);
                builder.directory(f.getParentFile());
                this.getLog().info((CharSequence)("Start process: " + Arrays.asList(cmd)));
                try (GZIPOutputStream os = new GZIPOutputStream(new FileOutputStream(target));){
                    CollectingProcessOutput output = new CollectingProcessOutput();
                    output.monitor(builder);
                    int exitval = output.getExitCode();
                    if (exitval == 0) {
                        this.getLog().info((CharSequence)("Manual page generated: " + target.getPath()));
                        break block10;
                    }
                    this.getLog().warn((CharSequence)("Exit code: " + exitval));
                    this.getLog().warn((CharSequence)("stderr:\n" + output.getStdErr()));
                    this.getLog().warn((CharSequence)("stdout:\n" + output.getStdOut()));
                    throw new MojoExecutionException("Process returned non-zero exit code: " + Arrays.asList(cmd));
                }
            }
            ++npages;
        }
        if (npages == 0) {
            this.getLog().info((CharSequence)("No manual pages found in directory: " + source));
        }
    }

    private void generatePackage() throws IOException, MojoExecutionException {
        this.runProcess(new String[]{"fakeroot", "--", "dpkg-deb", "--build", this.stageDir.toString(), this.getPackageFile().toString()}, true);
    }

    private void checkDeprecated(boolean haveParameter, String paramName) throws MojoExecutionException {
        if (haveParameter) {
            throw new MojoExecutionException("Deprecated parameter used: " + paramName);
        }
    }

    @Override
    protected void executeDebMojo() throws MojoExecutionException {
        this.checkDeprecated(this.includeJar != null, "includeJar");
        this.checkDeprecated(this.includeJars != null && this.includeJars.length > 0, "includeJars");
        this.checkDeprecated(this.excludeAllJars != null, "excludeAllJars");
        File targetDebDir = new File(this.stageDir, "DEBIAN");
        if (!targetDebDir.exists() && !targetDebDir.mkdirs()) {
            throw new MojoExecutionException("Unable to create directory: " + targetDebDir);
        }
        try {
            this.generateManPages();
            this.copyAttachedArtifacts();
            this.copyArtifacts();
            this.generateCopyright();
            this.generateConffiles(new File(targetDebDir, "conffiles"));
            this.generateControl(new File(targetDebDir, "control"));
            this.generateMd5Sums(new File(targetDebDir, "md5sums"));
            this.generatePackage();
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)e.toString());
            throw new MojoExecutionException(e.toString());
        }
    }
}

