/*
 * Decompiled with CFR 0.152.
 */
package net.sf.debianmaven;

import edu.emory.mathcs.backport.java.util.Arrays;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import net.sf.debianmaven.AbstractRepreproMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class RepreproDeployMojo
extends AbstractRepreproMojo {
    private static final String DEFAULT_CODENAME = "experimental";
    protected String repositoryBranch;
    protected String[] codenames;
    protected boolean skipDeployMissing;

    private void runReprepro() throws IOException, MojoExecutionException {
        File pkgfile = this.getPackageFile();
        if (pkgfile.exists()) {
            ArrayList<String> codenames = new ArrayList<String>();
            if (this.repositoryBranch != null) {
                codenames.add(this.repositoryBranch);
                this.getLog().warn((CharSequence)"parameter 'repositoryBranch' is now deprecated; use 'codenames' instead");
            }
            if (this.codenames != null) {
                codenames.addAll(Arrays.asList((Object[])this.codenames));
            }
            if (codenames.isEmpty()) {
                codenames.add(DEFAULT_CODENAME);
            }
            for (String codename : codenames) {
                this.runProcess(new String[]{"reprepro", "--confdir", this.repreproConfigurationDir.toString(), "--basedir", this.repository.toString(), "includedeb", codename, pkgfile.toString()}, true);
            }
        } else {
            this.getLog().info((CharSequence)("Skipping deployment of non-existent package: " + pkgfile));
        }
    }

    @Override
    protected void executeDebMojo() throws MojoExecutionException {
        try {
            this.runReprepro();
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)e.toString());
            throw new MojoExecutionException(e.toString());
        }
    }
}

