/*
 * Decompiled with CFR 0.152.
 */
package net.sf.debianmaven;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.regex.Pattern;
import net.sf.debianmaven.FixPermission;
import org.apache.maven.plugin.logging.Log;

public class IOUtils {
    public static void applyFixPermissions(Log log, File dir, List<FixPermission> fixPermissions) throws IOException {
        log.debug((CharSequence)("Fixing permissions in: " + dir));
        for (FixPermission fixPermission : fixPermissions) {
            if (!fixPermission.appliesTo(dir)) continue;
            log.debug((CharSequence)("'" + fixPermission + "' applies to: " + dir));
            fixPermission.applyTo(dir);
        }
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    IOUtils.applyFixPermissions(log, file, fixPermissions);
                    continue;
                }
                for (FixPermission fixPermission : fixPermissions) {
                    if (!fixPermission.appliesTo(file)) continue;
                    log.debug((CharSequence)("'" + fixPermission + "' applies to: " + file));
                    fixPermission.applyTo(file);
                }
            }
        }
    }

    public static boolean copyOrMove(Log log, File sourceLocation, File targetLocation, boolean move, boolean atomic, Pattern include) throws IOException {
        if (sourceLocation.isDirectory()) {
            log.debug((CharSequence)("Entering source dir: " + sourceLocation));
            if (!(targetLocation.exists() || targetLocation.mkdirs() || targetLocation.exists())) {
                log.error((CharSequence)("Failed to create target directory: " + targetLocation));
                return false;
            }
            String[] children = sourceLocation.list();
            for (int i = 0; i < children.length; ++i) {
                if (!include.matcher(new File(sourceLocation.getAbsoluteFile(), children[i]).getAbsolutePath()).matches() || IOUtils.copyOrMove(log, new File(sourceLocation.getAbsoluteFile(), children[i]), new File(targetLocation.getAbsoluteFile(), children[i]), move, atomic, include)) continue;
                return false;
            }
            if (move) {
                return sourceLocation.delete();
            }
            return true;
        }
        Path source = FileSystems.getDefault().getPath(sourceLocation.getAbsolutePath(), new String[0]);
        if (include.matcher(source.toAbsolutePath().toString()).matches()) {
            Path target = targetLocation.isDirectory() ? FileSystems.getDefault().getPath(targetLocation.getAbsolutePath() + File.separator + sourceLocation.getName(), new String[0]) : FileSystems.getDefault().getPath(targetLocation.getAbsolutePath(), new String[0]);
            if (move) {
                log.debug((CharSequence)("Moving '" + sourceLocation + "' to '" + target + "'"));
                if (atomic) {
                    Files.move(source, target, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
                } else {
                    Files.move(source, target, StandardCopyOption.REPLACE_EXISTING);
                }
            } else {
                log.debug((CharSequence)("Copying '" + sourceLocation + "' to '" + target + "'"));
                Files.copy(source, target, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        return true;
    }
}

