/*
 * Decompiled with CFR 0.152.
 */
package net.sf.debianmaven;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class FixPermission
implements Serializable {
    private String include = null;
    private Pattern includePattern = null;
    private String permissions = null;
    private Set<PosixFilePermission> permissionsSet = null;

    public FixPermission() {
    }

    public FixPermission(String include, String permissions) throws PatternSyntaxException, IllegalArgumentException {
        this();
        this.setInclude(include);
        this.setPermissions(permissions);
    }

    public void setInclude(String value) throws PatternSyntaxException {
        this.includePattern = Pattern.compile(value);
        this.include = value;
    }

    public String getInclude() {
        return this.include;
    }

    public Pattern getIncludePattern() {
        return this.includePattern;
    }

    public void setPermissions(String value) throws IllegalArgumentException {
        this.permissionsSet = PosixFilePermissions.fromString(value);
        this.permissions = value;
    }

    public String getPermissions() {
        return this.permissions;
    }

    public Set<PosixFilePermission> getPermissionsSet() {
        return this.permissionsSet;
    }

    public boolean isValid() {
        return this.includePattern != null && this.permissionsSet != null;
    }

    public boolean appliesTo(File file) {
        return this.isValid() && this.includePattern.matcher(file.getAbsolutePath()).matches();
    }

    public boolean applyTo(File file) throws IOException {
        if (this.appliesTo(file)) {
            Files.setPosixFilePermissions(file.toPath(), this.permissionsSet);
            return true;
        }
        return false;
    }

    public String toString() {
        return "include=" + (this.include == null ? "???" : this.include) + ", permissions=" + (this.permissions == null ? "???" : this.permissions);
    }
}

