/*
 * Decompiled with CFR 0.152.
 */
package net.sf.debianmaven.utils;

import edu.emory.mathcs.backport.java.util.Arrays;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.util.List;
import org.apache.maven.plugin.logging.Log;

public class BeanUtils {
    public static PropertyDescriptor[] extractProperties(Log log, Object obj) {
        if (obj == null) {
            log.warn((CharSequence)"Null object provided, can't extract bean properties!");
            return new PropertyDescriptor[0];
        }
        try {
            BeanInfo bi = Introspector.getBeanInfo(obj.getClass());
            return bi.getPropertyDescriptors();
        }
        catch (Exception e) {
            log.error((CharSequence)("Failed to extract properties from: " + obj.getClass()), (Throwable)e);
            return new PropertyDescriptor[0];
        }
    }

    protected static Object extractValue(Log log, Object obj, List<String> path) {
        PropertyDescriptor[] props;
        String current = path.get(0);
        int index = -1;
        if (current.contains("[") && current.endsWith("]")) {
            index = Integer.parseInt(current.substring(current.indexOf("[") + 1, current.indexOf("]")));
            current = current.substring(0, current.indexOf("["));
        }
        for (PropertyDescriptor prop : props = BeanUtils.extractProperties(log, obj)) {
            Object value;
            if (!prop.getDisplayName().equals(current)) continue;
            try {
                value = prop.getReadMethod().invoke(obj, new Object[0]);
            }
            catch (Exception e) {
                value = null;
                log.error((CharSequence)("Failed to obtain value from path '" + path.get(0) + "!"), (Throwable)e);
            }
            if (index > -1) {
                if (value.getClass().isArray()) {
                    value = Array.get(value, index);
                } else if (value instanceof List) {
                    value = ((List)value).get(index);
                } else {
                    log.error((CharSequence)("Cannot handle type (neither array nor list): " + value.getClass()));
                }
            }
            if (path.size() == 1) {
                return value;
            }
            return BeanUtils.extractValue(log, value, path.subList(1, path.size()));
        }
        log.warn((CharSequence)("Failed to locate path: " + current));
        return null;
    }

    public static Object extractValue(Log log, Object obj, String path) {
        Object[] parts = path.contains(".") ? path.split("\\.") : new String[]{path};
        return BeanUtils.extractValue(log, obj, Arrays.asList((Object[])parts));
    }
}

