/*
 * Decompiled with CFR 0.152.
 */
package net.sf.debianmaven.utils;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.debianmaven.utils.BeanUtils;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.logging.Log;

public class FilterUtils {
    public static final String PROJECT = "project.";

    protected static List<String> extractVariables(Log log, String line) {
        String original = line;
        ArrayList<String> result = new ArrayList<String>();
        while (line.length() > 0) {
            int indexStart = line.indexOf("${");
            if (indexStart == -1) {
                line = "";
                continue;
            }
            int indexEnd = line.indexOf("}", indexStart);
            if (indexEnd == -1) {
                line = "";
                continue;
            }
            result.add(line.substring(indexStart + 2, indexEnd));
            line = line.substring(indexEnd + 1);
        }
        if (result.size() > 0) {
            log.debug((CharSequence)("Variables extracted from line '" + original + "': " + result));
        }
        return result;
    }

    protected static String variableValue(Log log, String var, Model model) {
        if (!var.startsWith(PROJECT)) {
            log.warn((CharSequence)("Variable does not start with project.: " + var));
            return null;
        }
        Object value = BeanUtils.extractValue(log, (Object)model, var.substring(PROJECT.length()));
        if (value == null) {
            log.warn((CharSequence)("Failed to extract value for variable: " + var));
            return null;
        }
        log.debug((CharSequence)("Value for variable " + var + ": " + value));
        return "" + value;
    }

    public static void filterFile(Log log, Path input, Path output, Model model, Map<String, String> additional) throws IOException {
        List<String> lines = Files.readAllLines(input);
        HashMap<String, String> cache = new HashMap<String, String>();
        boolean modified = false;
        for (int i = 0; i < lines.size(); ++i) {
            String line = lines.get(i);
            boolean updated = false;
            List<String> vars = FilterUtils.extractVariables(log, line);
            for (String var : vars) {
                String value = cache.containsKey(var) ? (String)cache.get(var) : (additional.containsKey(var) ? additional.get(var) : FilterUtils.variableValue(log, var, model));
                cache.put(var, value);
                if (value == null) continue;
                log.debug((CharSequence)("Replacing variable '" + var + "' with value '" + value + "' in: " + line));
                line = line.replace("${" + var + "}", value);
                updated = true;
            }
            if (!updated) continue;
            lines.set(i, line);
            modified = true;
        }
        if (modified) {
            log.debug((CharSequence)("Writing filtered file " + input + " to " + output));
            Files.createDirectories(output.getParent(), new FileAttribute[0]);
            Files.write(output, lines, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
        } else {
            log.debug((CharSequence)("Copying unmodified file " + input + " to " + output));
            Files.createDirectories(output.getParent(), new FileAttribute[0]);
            Files.copy(input, output, StandardCopyOption.REPLACE_EXISTING);
        }
    }
}

