/*
 * Decompiled with CFR 0.152.
 */
package net.sf.debianmaven;

import java.io.Serializable;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class FileFiltering
implements Serializable {
    public static final String DEFAULT_INCLUDE = ".*";
    public static final String DEFAULT_EXCLUDE = ".*\\.(jpg|jpeg|png|svg|zip|jar|pdf)";
    private boolean enabled = false;
    private String include = null;
    private Pattern includePattern = null;
    private String exclude = null;
    private Pattern excludePattern = null;

    public FileFiltering() {
    }

    public FileFiltering(boolean enabled, String include, String exclude) throws PatternSyntaxException {
        this();
        this.setEnabled(enabled);
        this.setInclude(include);
        this.setExclude(exclude);
    }

    public void setEnabled(boolean value) {
        this.enabled = value;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setInclude(String value) throws PatternSyntaxException {
        if (value == null || value.isEmpty()) {
            this.setInclude(DEFAULT_INCLUDE);
            return;
        }
        this.includePattern = Pattern.compile(value);
        this.include = value;
    }

    public String getInclude() {
        return this.include;
    }

    public Pattern getIncludePattern() {
        if (this.include == null || this.include.isEmpty()) {
            this.setInclude(DEFAULT_INCLUDE);
        }
        return this.includePattern;
    }

    public void setExclude(String value) throws PatternSyntaxException {
        if (value == null || value.isEmpty()) {
            this.setExclude(DEFAULT_EXCLUDE);
            return;
        }
        this.excludePattern = Pattern.compile(value);
        this.exclude = value;
    }

    public String getExclude() {
        return this.exclude;
    }

    public Pattern getExcludePattern() {
        if (this.exclude == null || this.exclude.isEmpty()) {
            this.setExclude(DEFAULT_EXCLUDE);
        }
        return this.excludePattern;
    }

    public String toString() {
        return "enabled=" + this.enabled + ", include=" + (this.include == null ? DEFAULT_INCLUDE : this.include) + ", exclude=" + (this.exclude == null ? DEFAULT_EXCLUDE : this.exclude);
    }
}

