/*
 * Decompiled with CFR 0.152.
 */
package net.sf.debianmaven.utils;

import com.github.fracpete.simplemavenfilefiltering.FilterUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.regex.Pattern;
import net.sf.debianmaven.utils.AbstractFileCopy;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.logging.Log;

public class FilteredFileCopy
extends AbstractFileCopy {
    private Model model;
    private Pattern include;
    private Pattern exclude;
    private Map<String, String> additional;

    public FilteredFileCopy(Model model, Pattern include, Pattern exclude, Map<String, String> additional) {
        this.model = model;
        this.include = include;
        this.exclude = exclude;
        this.additional = additional;
    }

    @Override
    public void copy(Path input, Path output) throws IOException {
        boolean filter;
        boolean bl = filter = this.include.matcher(input.toAbsolutePath().toString()).matches() && !this.exclude.matcher(input.toAbsolutePath().toString()).matches();
        if (filter) {
            FilterUtils.filterFile((Log)this.getLog(), (Path)input, (Path)output, (Model)this.model, this.additional);
        } else {
            this.getLog().debug((CharSequence)("Copying: " + input));
            Files.createDirectories(output.getParent(), new FileAttribute[0]);
            Files.copy(input, output, StandardCopyOption.REPLACE_EXISTING);
        }
    }
}

