/*
 * Decompiled with CFR 0.152.
 */
package net.sf.debianmaven;

import com.github.fracpete.processoutput4j.output.CollectingProcessOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import net.sf.debianmaven.AbstractDebianMojo;
import net.sf.debianmaven.CopyResource;
import net.sf.debianmaven.FileFiltering;
import net.sf.debianmaven.FixPermission;
import net.sf.debianmaven.utils.AbstractFileCopy;
import net.sf.debianmaven.utils.DefaultFileCopy;
import net.sf.debianmaven.utils.FilteredFileCopy;
import net.sf.debianmaven.utils.IOUtils;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections15.multimap.MultiHashMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.License;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public class PackageMojo
extends AbstractDebianMojo {
    protected String packagePriority;
    protected String packageSection;
    protected String packageTitle;
    protected String packageDescription;
    protected String[] packageDependencies;
    protected String projectUrl;
    protected String projectOrganization;
    @Deprecated
    protected String includeJar;
    @Deprecated
    protected String[] includeJars;
    @Deprecated
    protected String excludeAllJars;
    protected Set<String> includeArtifacts;
    protected Set<String> excludeArtifacts;
    protected Set<String> excludeArtifactsRegExp;
    protected Set<Pattern> excludeArtifactsPattern;
    protected boolean excludeAllArtifacts;
    protected boolean excludeAllDependencies;
    protected boolean includeAttachedArtifacts;
    protected String libDirectory;
    protected String docDirectory;
    protected String manDirectory;
    protected boolean createSymLinks;
    protected boolean createIncludeFiles;
    protected boolean useDefaultFixPermissions;
    protected List<FixPermission> fixPermissions;
    protected List<FixPermission> activeFixPermissions;
    protected boolean useDefaultCopyResources;
    protected List<CopyResource> copyResources;
    protected List<CopyResource> activeCopyResources;
    protected FileFiltering fileFiltering;
    protected String includeScope;
    protected Set<String> includedScopes;
    protected String excludeScope;
    protected Set<String> excludedScopes;
    private MavenProject project;

    private String stripPath(String path) {
        StringBuilder result = new StringBuilder();
        boolean start = true;
        for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (start) {
                if (c == '/' || c == '.') continue;
                start = false;
            }
            result.append(c);
        }
        path = result.toString();
        result = new StringBuilder();
        boolean end = true;
        for (int i = path.length() - 1; i >= 0; --i) {
            char c = path.charAt(i);
            if (end) {
                if (c == '/' || c == '.') continue;
                end = false;
            }
            result.insert(0, c);
        }
        return result.toString();
    }

    private String getLibDirectory() {
        String result = this.libDirectory == null || this.libDirectory.isEmpty() ? "/usr/lib/{PGKNAME}" : this.libDirectory;
        result = result.replace("{PKGNAME}", this.packageName);
        return result;
    }

    private String getDocDirectory() {
        String result = this.docDirectory == null || this.docDirectory.isEmpty() ? "/usr/share/doc/{PGKNAME}" : this.docDirectory;
        result = result.replace("{PKGNAME}", this.packageName);
        return result;
    }

    private String getManDirectory() {
        String result = this.manDirectory == null || this.manDirectory.isEmpty() ? "/usr/share/man" : this.manDirectory;
        result = result.replace("{PKGNAME}", this.packageName);
        return result;
    }

    private List<FixPermission> getActiveFixPermissions() {
        if (this.activeFixPermissions == null) {
            this.activeFixPermissions = new ArrayList<FixPermission>();
            if (this.useDefaultFixPermissions) {
                try {
                    this.activeFixPermissions.add(new FixPermission(".*\\/bin\\/.*", "rwxr-xr-x"));
                    this.activeFixPermissions.add(new FixPermission(".*\\/sbin\\/.*", "rwxr-xr-x"));
                    this.activeFixPermissions.add(new FixPermission(".*\\/DEBIAN\\/post.*", "rwxr-xr-x"));
                    this.activeFixPermissions.add(new FixPermission(".*\\/DEBIAN\\/pre.*", "rwxr-xr-x"));
                }
                catch (Exception e) {
                    this.getLog().error((CharSequence)"Failed to setup default fix permissions!", (Throwable)e);
                }
            }
            if (this.fixPermissions != null) {
                for (FixPermission fp : this.fixPermissions) {
                    if (fp.isValid()) {
                        this.activeFixPermissions.add(fp);
                        continue;
                    }
                    this.getLog().warn((CharSequence)("Fix permission is not valid, skipping: " + fp));
                }
            }
        }
        return this.activeFixPermissions;
    }

    private List<CopyResource> getActiveCopyResources() {
        if (this.activeCopyResources == null) {
            this.activeCopyResources = new ArrayList<CopyResource>();
            if (this.useDefaultCopyResources) {
                if (this.sourceDir != null && this.sourceDir.exists() && new File(this.sourceDir, "resources").exists()) {
                    File resourcesDir = new File(this.sourceDir, "resources");
                    this.activeCopyResources.add(new CopyResource(resourcesDir.getAbsolutePath(), this.stageDir.getAbsolutePath(), ".*"));
                    this.getLog().info((CharSequence)("using default copy resources: " + resourcesDir + " -> " + this.stageDir));
                } else {
                    this.getLog().warn((CharSequence)("'useDefaultCopyResources' is enabled, but '" + this.sourceDir + "/resources' does not exist. Skipping!"));
                }
            }
            if (this.copyResources != null) {
                this.activeCopyResources.addAll(this.copyResources);
            }
        }
        return this.activeCopyResources;
    }

    private File createTargetLibDir() throws IOException {
        File targetLibDir = new File(this.stageDir, this.stripPath(this.getLibDirectory()));
        if (!targetLibDir.mkdirs() && !targetLibDir.exists()) {
            throw new IOException("Failed to create lib directory: " + targetLibDir);
        }
        return targetLibDir;
    }

    private void createSymlink(File symlink, String target) throws MojoExecutionException, IOException {
        if (symlink.exists()) {
            symlink.delete();
        }
        this.runProcess(new String[]{"ln", "-s", target, symlink.toString()}, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeIncludeFile(File targetLibDir, String artifactId, String version, Collection<String> dependencies) throws IOException, MojoExecutionException {
        if (dependencies == null) {
            dependencies = Collections.emptySet();
        }
        File deplist = new File(targetLibDir, String.format("%s-%s.inc", artifactId, version));
        try (FileWriter out = new FileWriter(deplist);){
            out.write(String.format("artifacts=%s\n", StringUtils.join(new HashSet<String>(dependencies), (String)":")));
        }
        if (this.createSymLinks) {
            this.createSymlink(new File(targetLibDir, String.format("%s.inc", artifactId)), deplist.getName());
        }
    }

    private Set<Pattern> getExcludeArtifactsPattern() {
        if (this.excludeArtifactsPattern == null) {
            this.excludeArtifactsPattern = new HashSet<Pattern>();
            if (this.excludeArtifactsRegExp != null) {
                for (String regexp : this.excludeArtifactsRegExp) {
                    try {
                        Pattern p = Pattern.compile(regexp);
                        this.excludeArtifactsPattern.add(p);
                    }
                    catch (Exception e) {
                        this.getLog().error((CharSequence)("Failed to parse excludeArtifactsPattern '" + regexp + "'!"), (Throwable)e);
                    }
                }
            }
        }
        return this.excludeArtifactsPattern;
    }

    private Set<String> getIncludedScopes() {
        if (this.includedScopes == null) {
            this.includedScopes = new HashSet<String>();
            if (this.includeScope != null && !this.includeScope.isEmpty()) {
                if (this.includeScope.contains(",")) {
                    this.includedScopes.addAll(Arrays.asList(this.includeScope.split(",")));
                } else {
                    this.includedScopes.add(this.includeScope);
                }
            }
        }
        return this.includedScopes;
    }

    private Set<String> getExcludedScopes() {
        if (this.excludedScopes == null) {
            this.excludedScopes = new HashSet<String>();
            if (this.excludeScope != null && !this.excludeScope.isEmpty()) {
                if (this.excludeScope.contains(",")) {
                    this.excludedScopes.addAll(Arrays.asList(this.excludeScope.split(",")));
                } else {
                    this.excludedScopes.add(this.excludeScope);
                }
            }
        }
        return this.excludedScopes;
    }

    private boolean includeArtifact(Artifact a) {
        boolean doExclude;
        String aStr = a.getGroupId() + ":" + a.getArtifactId() + ":" + (a.hasClassifier() ? a.getClassifier() : "");
        boolean bl = doExclude = this.excludeArtifacts != null && (a.getDependencyTrail() == null || Collections.disjoint(a.getDependencyTrail(), this.excludeArtifacts));
        if (!doExclude && this.getExcludeArtifactsPattern().size() > 0) {
            for (Pattern p : this.getExcludeArtifactsPattern()) {
                if (!p.matcher(aStr).matches()) continue;
                this.getLog().debug((CharSequence)(aStr + " excluded using pattern: " + p.pattern()));
                doExclude = true;
                break;
            }
        }
        if (a.getScope() != null) {
            if (!this.getIncludedScopes().isEmpty() && !this.getIncludedScopes().contains(a.getScope())) {
                this.getLog().debug((CharSequence)(aStr + " (" + a.getScope() + ") not part of included scopes: " + this.getIncludedScopes()));
                doExclude = true;
            }
            if (!this.getExcludedScopes().isEmpty() && this.getExcludedScopes().contains(a.getScope())) {
                this.getLog().debug((CharSequence)(aStr + " (" + a.getScope() + ") part of excluded scopes: " + this.getExcludedScopes()));
                doExclude = true;
            }
        }
        if (doExclude) {
            return false;
        }
        if (this.includeArtifacts == null) {
            return true;
        }
        if (a.getDependencyTrail() == null) {
            return true;
        }
        return Collections.disjoint(a.getDependencyTrail(), this.includeArtifacts);
    }

    private File copyArtifact(Artifact a, File targetLibDir) throws IOException, MojoExecutionException {
        if (a.getFile() == null) {
            throw new MojoExecutionException(String.format("No file was built for required artifact: %s:%s:%s", a.getGroupId(), a.getArtifactId(), a.getVersion()));
        }
        this.getLog().info((CharSequence)String.format("Artifact: %s", a.getFile().getPath()));
        File src = a.getFile();
        File trg = new File(targetLibDir, src.getName());
        FileUtils.copyFile((File)src, (File)trg);
        String linkname = src.getName().replaceFirst("-" + a.getBaseVersion(), "");
        if (linkname.equals(src.getName())) {
            linkname = linkname.replaceFirst("-" + a.getVersion(), "");
        }
        if (this.createSymLinks && !linkname.equals(src.getName())) {
            this.createSymlink(new File(targetLibDir, linkname), a.getFile().getName());
        }
        return trg;
    }

    private void copyAttachedArtifacts() throws FileNotFoundException, IOException, MojoExecutionException {
        if (!this.includeAttachedArtifacts) {
            this.getLog().info((CharSequence)"Skipping attached project artifacts.");
            return;
        }
        this.getLog().info((CharSequence)"Copying attached project artifacts.");
        File targetLibDir = this.createTargetLibDir();
        for (Artifact a : this.project.getAttachedArtifacts()) {
            if (!this.includeArtifact(a)) continue;
            this.copyArtifact(a, targetLibDir);
        }
    }

    private void copyArtifacts() throws FileNotFoundException, IOException, MojoExecutionException {
        if (this.excludeAllArtifacts) {
            this.getLog().info((CharSequence)"Skipping regular project artifacts and dependencies.");
            return;
        }
        File targetLibDir = this.createTargetLibDir();
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        if (this.project.getArtifact().getFile() != null) {
            artifacts.add(this.project.getArtifact());
        }
        if (this.excludeAllDependencies) {
            this.getLog().info((CharSequence)"Copying regular project artifacts but not dependencies.");
        } else {
            this.getLog().info((CharSequence)"Copying regular project artifacts and dependencies.");
            for (Artifact a : this.project.getArtifacts()) {
                if (!a.getScope().equals("runtime") && !a.getScope().equals("compile")) continue;
                artifacts.add(a);
            }
        }
        HashMap<String, Artifact> ids = new HashMap<String, Artifact>();
        for (Artifact a : artifacts) {
            ids.put(a.getId(), a);
        }
        MultiHashMap deps = new MultiHashMap();
        for (Artifact a : artifacts) {
            if (!this.includeArtifact(a)) continue;
            File trg = this.copyArtifact(a, targetLibDir);
            if (a.getDependencyTrail() == null) continue;
            for (String id : a.getDependencyTrail()) {
                Artifact depending = (Artifact)ids.get(id);
                if (depending == null) continue;
                deps.put((Object)depending, (Object)trg.getPath().substring(this.stageDir.getPath().length()));
            }
        }
        for (Artifact a : artifacts) {
            if (!this.includeArtifact(a) || !this.createIncludeFiles) continue;
            this.writeIncludeFile(targetLibDir, a.getArtifactId(), a.getVersion(), deps.get((Object)a));
        }
    }

    private void generateCopyright() throws IOException {
        File targetDocDir = new File(this.stageDir, this.stripPath(this.getDocDirectory()));
        if (!targetDocDir.mkdirs() && !targetDocDir.exists()) {
            throw new IOException("Failed to created doc directory: " + targetDocDir);
        }
        PrintWriter out = new PrintWriter(new FileWriter(new File(targetDocDir, "copyright")));
        out.println("Package: " + this.packageName);
        out.println("URL: " + this.projectUrl);
        out.println();
        out.printf("Copyright %d %s\n", Calendar.getInstance().get(1), this.projectOrganization);
        out.println();
        for (Object o : this.project.getLicenses()) {
            License l = (License)o;
            out.println(l.getName());
            if (l.getUrl() != null && !l.getUrl().isEmpty()) {
                out.println(l.getUrl());
            }
            if (l.getComments() != null && !l.getComments().isEmpty()) {
                out.println(l.getComments());
            }
            out.println();
        }
        out.close();
    }

    private void copyResources() throws IOException {
        AbstractFileCopy fileCopy;
        if (this.fileFiltering == null) {
            this.getLog().debug((CharSequence)"File filter is null, instantiating default");
            this.fileFiltering = new FileFiltering();
        }
        this.getLog().info((CharSequence)("File filtering: " + this.fileFiltering));
        if (!this.fileFiltering.getEnabled()) {
            fileCopy = new DefaultFileCopy();
        } else {
            HashMap<String, String> additional = new HashMap<String, String>();
            additional.put("packageName", this.packageName);
            additional.put("packageTitle", this.packageTitle);
            additional.put("packagePriority", this.packagePriority);
            additional.put("packageSection", this.packageSection);
            additional.put("packageDescription", this.packageDescription);
            additional.put("packageArchitecture", this.packageArchitecture);
            additional.put("packageRevision", this.packageRevision);
            fileCopy = new FilteredFileCopy(this.project.getModel(), this.fileFiltering.getIncludePattern(), this.fileFiltering.getExcludePattern(), additional);
        }
        fileCopy.setLog(this.getLog());
        for (CopyResource copyResource : this.getActiveCopyResources()) {
            this.getLog().info((CharSequence)("Copy resources using: " + copyResource));
            IOUtils.copy(this.getLog(), new File(copyResource.getSource()), new File(copyResource.getTarget()), copyResource.getIncludePattern(), fileCopy);
        }
    }

    private void applyFixPermissions() throws IOException {
        List<FixPermission> active = this.getActiveFixPermissions();
        if (active.size() != 0) {
            IOUtils.applyFixPermissions(this.getLog(), this.stageDir, active);
        }
    }

    private void generateControl(File target) throws IOException {
        this.getLog().info((CharSequence)("Generating control file: " + target));
        PrintWriter out = new PrintWriter(new FileWriter(target));
        out.println("Package: " + this.packageName);
        out.println("Version: " + this.getPackageVersion());
        if (this.packageSection != null) {
            out.println("Section: " + this.packageSection);
        }
        if (this.packagePriority != null) {
            out.println("Priority: " + this.packagePriority);
        }
        out.println("Architecture: " + this.packageArchitecture);
        if (this.packageDependencies != null && this.packageDependencies.length > 0) {
            out.println("Depends: " + StringUtils.join((Object[])this.processVersion(this.packageDependencies), (String)", "));
        }
        out.printf("Installed-Size: %d\n", 1L + FileUtils.sizeOfDirectory((File)this.stageDir) / 1024L);
        if (this.maintainerName != null || this.maintainerEmail != null) {
            out.print("Maintainer:");
            if (this.maintainerName != null) {
                out.print(" " + this.maintainerName);
            }
            if (this.maintainerEmail != null) {
                out.printf(" <%s>", this.maintainerEmail);
            }
            out.println();
        }
        if (this.projectUrl != null) {
            out.println("Homepage: " + this.projectUrl);
        }
        if (this.packageTitle != null) {
            if (this.packageTitle.length() > 60) {
                this.getLog().warn((CharSequence)"Package title will be truncated to the upper limit of 60 characters.");
                out.println("Description: " + this.packageTitle.substring(0, 60));
            } else {
                out.println("Description: " + this.packageTitle);
            }
            out.println(this.getFormattedDescription());
        }
        out.close();
    }

    private String getFormattedDescription() {
        String desc = this.packageDescription.trim();
        desc.replaceAll("\\s+", " ");
        return " " + desc;
    }

    private void generateConffiles(File target) throws IOException {
        ArrayList<String> conffiles = new ArrayList<String>();
        File configDir = new File(this.stageDir, "etc");
        if (configDir.exists()) {
            Collection files = FileUtils.listFiles((File)configDir, null, (boolean)true);
            for (File f : files) {
                if (!f.isFile()) continue;
                conffiles.add(f.toString().substring(this.stageDir.toString().length()));
            }
        }
        if (conffiles.size() > 0) {
            PrintWriter out = new PrintWriter(new FileWriter(target));
            for (String fname : conffiles) {
                out.println(fname);
            }
            out.close();
        }
    }

    private void generateMd5Sums(File target) throws IOException {
        PrintWriter out = new PrintWriter(new FileWriter(target));
        Collection files = FileUtils.listFiles((File)this.stageDir, null, (boolean)true);
        for (File f : files) {
            String fname;
            if (!f.isFile() || !f.getAbsolutePath().equals(f.getCanonicalPath()) || (fname = f.toString().substring(this.stageDir.toString().length() + 1)).startsWith("DEBIAN")) continue;
            FileInputStream fis = new FileInputStream(f);
            String md5 = DigestUtils.md5Hex((InputStream)fis);
            fis.close();
            out.printf("%s  %s\n", md5, fname);
        }
        out.close();
    }

    private void generateManPages() throws MojoExecutionException, IOException {
        File source = new File(this.sourceDir, "man");
        if (!source.exists()) {
            this.getLog().info((CharSequence)("No manual page directory found: " + source));
            return;
        }
        int npages = 0;
        Collection files = FileUtils.listFiles((File)source, null, (boolean)true);
        for (File f : files) {
            block11: {
                if (!f.isFile() || !f.getName().matches(".*[.][1-9]$")) continue;
                char section = f.getName().charAt(f.getName().length() - 1);
                File target = new File(this.stageDir, String.format(this.stripPath(this.getManDirectory()) + "/man%c/%s.gz", Character.valueOf(section), f.getName()));
                if (!target.getParentFile().mkdirs() && !target.exists()) {
                    throw new IOException("Failed to create man pages directory: " + target);
                }
                String[] cmd = new String[]{"groff", "-man", "-Tascii", f.getPath()};
                ProcessBuilder builder = new ProcessBuilder(new String[0]);
                builder.command(cmd);
                builder.directory(f.getParentFile());
                this.getLog().info((CharSequence)("Start process: " + Arrays.asList(cmd)));
                try (GZIPOutputStream os = new GZIPOutputStream(new FileOutputStream(target));){
                    CollectingProcessOutput output = new CollectingProcessOutput();
                    output.monitor(builder);
                    int exitval = output.getExitCode();
                    if (exitval == 0) {
                        this.getLog().info((CharSequence)("Manual page generated: " + target.getPath()));
                        break block11;
                    }
                    this.getLog().warn((CharSequence)("Exit code: " + exitval));
                    this.getLog().warn((CharSequence)("stderr:\n" + output.getStdErr()));
                    this.getLog().warn((CharSequence)("stdout:\n" + output.getStdOut()));
                    throw new MojoExecutionException("Process returned non-zero exit code: " + Arrays.asList(cmd));
                }
            }
            ++npages;
        }
        if (npages == 0) {
            this.getLog().info((CharSequence)("No manual pages found in directory: " + source));
        }
    }

    private void generatePackage() throws IOException, MojoExecutionException {
        this.runProcess(new String[]{"fakeroot", "--", "dpkg-deb", "--build", this.stageDir.toString(), this.getPackageFile().toString()}, true);
    }

    private void checkDeprecated(boolean haveParameter, String paramName) throws MojoExecutionException {
        if (haveParameter) {
            throw new MojoExecutionException("Deprecated parameter used: " + paramName);
        }
    }

    @Override
    protected void executeDebMojo() throws MojoExecutionException {
        this.checkDeprecated(this.includeJar != null, "includeJar");
        this.checkDeprecated(this.includeJars != null && this.includeJars.length > 0, "includeJars");
        this.checkDeprecated(this.excludeAllJars != null, "excludeAllJars");
        File targetDebDir = new File(this.stageDir, "DEBIAN");
        if (!targetDebDir.exists() && !targetDebDir.mkdirs()) {
            throw new MojoExecutionException("Unable to create directory: " + targetDebDir);
        }
        try {
            this.generateManPages();
            this.copyAttachedArtifacts();
            this.copyArtifacts();
            this.generateCopyright();
            this.copyResources();
            this.applyFixPermissions();
            this.generateConffiles(new File(targetDebDir, "conffiles"));
            this.generateControl(new File(targetDebDir, "control"));
            this.generateMd5Sums(new File(targetDebDir, "md5sums"));
            this.generatePackage();
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)e.toString());
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }
}

