/*
 * Decompiled with CFR 0.152.
 */
package net.sf.debianmaven;

import java.io.Serializable;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class CopyResource
implements Serializable {
    private String source = null;
    private String target = null;
    private String include = null;
    private Pattern includePattern = null;

    public CopyResource() {
    }

    public CopyResource(String source, String target, String include) throws PatternSyntaxException {
        this();
        this.setSource(source);
        this.setTarget(target);
        this.setInclude(include);
    }

    public void setSource(String value) {
        this.source = value;
    }

    public String getSource() {
        return this.source;
    }

    public void setTarget(String value) {
        this.target = value;
    }

    public String getTarget() {
        return this.target;
    }

    public void setInclude(String value) throws PatternSyntaxException {
        if (value == null || value.isEmpty()) {
            this.setInclude(".*");
            return;
        }
        this.includePattern = Pattern.compile(value);
        this.include = value;
    }

    public String getInclude() {
        return this.include;
    }

    public Pattern getIncludePattern() {
        if (this.include == null || this.include.isEmpty()) {
            this.setInclude(".*");
        }
        return this.includePattern;
    }

    public String toString() {
        return "source=" + (this.source == null ? "???" : this.source) + ", target=" + (this.target == null ? "???" : this.target) + ", include=" + (this.include == null ? ".*" : this.include);
    }
}

