/*
 * Decompiled with CFR 0.152.
 */
package net.sf.debianmaven;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import net.sf.debianmaven.LogOutputStream;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public abstract class AbstractDebianMojo
extends AbstractMojo {
    private static final String SKIP_DEB_PROPERTY = "skipDeb";
    private static final String RUN_DEB_PROPERTY = "runDeb";
    protected String packageName;
    private String packageVersion;
    protected String packageRevision;
    protected String packageArchitecture;
    protected String maintainerName;
    protected String maintainerEmail;
    protected File sourceDir;
    protected File targetDir;
    protected File stageDir;
    private File snapshotRevisionFile = null;
    private static final DateFormat datefmt = new SimpleDateFormat("yyyyMMddHHmm");
    private String snapshotRevision = null;

    protected String processVersion(String version) {
        if (this.snapshotRevision == null) {
            Date revtime = this.snapshotRevisionFile != null ? new Date(this.snapshotRevisionFile.lastModified()) : new Date();
            this.snapshotRevision = "+" + datefmt.format(revtime);
        }
        return version.replaceAll("-SNAPSHOT", this.snapshotRevision);
    }

    protected String[] processVersion(String[] versions) {
        String[] result = new String[versions.length];
        for (int i = 0; i < versions.length; ++i) {
            result[i] = this.processVersion(versions[i]);
        }
        return result;
    }

    protected String getPackageVersion() {
        return this.processVersion(this.packageVersion);
    }

    protected File getPackageFile() {
        return new File(this.targetDir, String.format("%s_%s-%s_all.deb", this.packageName, this.getPackageVersion(), this.packageRevision));
    }

    protected void runProcess(String[] cmd, boolean throw_on_failure) throws ExecuteException, IOException, MojoExecutionException {
        CommandLine cmdline = new CommandLine(cmd[0]);
        cmdline.addArguments(Arrays.copyOfRange(cmd, 1, cmd.length));
        this.getLog().info((CharSequence)("Start process: " + cmdline));
        PumpStreamHandler streamHandler = new PumpStreamHandler((OutputStream)new LogOutputStream(this.getLog()));
        DefaultExecutor exec = new DefaultExecutor();
        exec.setStreamHandler((ExecuteStreamHandler)streamHandler);
        int exitval = exec.execute(cmdline);
        if (exitval != 0) {
            this.getLog().warn((CharSequence)("Exit code " + exitval));
            if (throw_on_failure) {
                throw new MojoExecutionException("Process returned non-zero exit code: " + cmdline);
            }
        }
    }

    protected abstract void executeDebMojo() throws MojoExecutionException;

    public final void execute() throws MojoExecutionException {
        if (System.getProperties().containsKey(RUN_DEB_PROPERTY)) {
            this.getLog().info((CharSequence)"debian-maven execution forced (-DrunDeb)");
            this.executeDebMojo();
        } else if (System.getProperties().containsKey(SKIP_DEB_PROPERTY)) {
            this.getLog().info((CharSequence)"debian-maven execution skipped (-DskipDeb)");
        } else if (!System.getProperty("os.name").equals("Linux")) {
            this.getLog().warn((CharSequence)"debian-maven execution skipped (non-linux OS)");
        } else {
            this.executeDebMojo();
        }
    }
}

