/*
 * Decompiled with CFR 0.152.
 */
package com.github.fracpete.deps4j;

import com.github.fracpete.processoutput4j.output.CollectingProcessOutput;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.ArgumentType;
import net.sourceforge.argparse4j.inf.Namespace;

public class MinDeps {
    protected File m_JavaHome = System.getenv("JAVA_HOME") != null ? new File(System.getenv("JAVA_HOME")) : null;
    protected File m_Jdeps;
    protected String m_ClassPath = null;
    protected File m_ClassesFile = null;
    protected File m_AdditionalFile = null;
    protected List<String> m_Packages = new ArrayList<String>();
    protected File m_OutputFile = null;
    protected List<String> m_Classes = new ArrayList<String>();
    protected List<String> m_Resources = new ArrayList<String>();
    protected Set<String> m_DependentClasses = new HashSet<String>();
    protected List<String> m_Dependencies = new ArrayList<String>();

    public void setJavaHome(File value) {
        this.m_JavaHome = value;
    }

    public File getJavaHome() {
        return this.m_JavaHome;
    }

    public void setClassPath(String value) {
        this.m_ClassPath = value;
    }

    public String getClassPath() {
        return this.m_ClassPath;
    }

    public void setClassesFile(File value) {
        this.m_ClassesFile = value;
    }

    public File getClassesFile() {
        return this.m_ClassesFile;
    }

    public void setAdditionalFile(File value) {
        this.m_AdditionalFile = value;
    }

    public File getAdditionalFile() {
        return this.m_AdditionalFile;
    }

    public void setPackages(List<String> value) {
        this.m_Packages.addAll(value);
    }

    public List<String> getPackages() {
        return this.m_Packages;
    }

    public void setOutputFile(File value) {
        this.m_OutputFile = value;
    }

    public File getOutputFile() {
        return this.m_OutputFile;
    }

    public boolean setOptions(String[] options) throws Exception {
        Namespace ns;
        ArgumentParser parser = ArgumentParsers.newArgumentParser((String)MinDeps.class.getName());
        parser.addArgument(new String[]{"--java-home"}).type((ArgumentType)Arguments.fileType().verifyExists().verifyIsDirectory()).dest("javahome").required(true).help("The java home directory of the JDK that includes the jdeps binary, default is taken from JAVA_HOME environment variable.");
        parser.addArgument(new String[]{"--class-path"}).dest("classpath").required(true).help("The CLASSPATH to use for jdeps.");
        parser.addArgument(new String[]{"--classes"}).type((ArgumentType)Arguments.fileType().verifyExists().verifyIsFile().verifyCanRead()).dest("classes").required(true).help("The file containing the classes to determine the dependencies for. Empty lines and lines starting with # get ignored.");
        parser.addArgument(new String[]{"--additional"}).type((ArgumentType)Arguments.fileType()).setDefault((Object)new File(".")).required(false).dest("additional").help("The file with additional class names to just include.");
        parser.addArgument(new String[]{"--output"}).type((ArgumentType)Arguments.fileType()).setDefault((Object)new File(".")).required(false).dest("output").help("The file for storing the determined class names in.");
        parser.addArgument(new String[]{"package"}).dest("packages").required(true).nargs("+").help("The packages to keep, eg 'weka'.");
        try {
            ns = parser.parseArgs(options);
        }
        catch (ArgumentParserException e) {
            parser.handleError(e);
            return false;
        }
        this.setJavaHome((File)ns.get("javahome"));
        this.setClassPath(ns.getString("classpath"));
        this.setClassesFile((File)ns.get("classes"));
        this.setAdditionalFile((File)ns.get("additional"));
        this.setPackages(ns.getList("packages"));
        this.setOutputFile((File)ns.get("output"));
        return true;
    }

    protected void initialize() {
        this.m_DependentClasses.clear();
        this.m_Resources.clear();
        this.m_Classes.clear();
        this.m_Dependencies.clear();
    }

    protected String readFile(File file, List<String> lines) {
        try {
            lines.addAll(Files.readAllLines(file.toPath()));
            int i = 0;
            while (i < lines.size()) {
                if (lines.get(i).trim().isEmpty()) {
                    lines.remove(i);
                    continue;
                }
                if (lines.get(i).startsWith("#")) {
                    lines.remove(i);
                    continue;
                }
                ++i;
            }
        }
        catch (Exception e) {
            return "Failed to read file: " + file + "\n" + e;
        }
        return null;
    }

    protected String check() {
        if (!this.m_JavaHome.exists()) {
            return "Java home directory does not exist: " + this.m_JavaHome;
        }
        if (!this.m_JavaHome.isDirectory()) {
            return "Java home does not point to a directory: " + this.m_JavaHome;
        }
        this.m_Jdeps = System.getProperty("os.name").toLowerCase().contains("windows") ? new File(this.m_JavaHome.getAbsolutePath() + File.separator + "bin" + File.separator + "jdeps.exe") : new File(this.m_JavaHome.getAbsolutePath() + File.separator + "bin" + File.separator + "jdeps");
        if (!this.m_Jdeps.exists()) {
            return "jdeps binary does not exist: " + this.m_Jdeps;
        }
        if (!this.m_ClassesFile.exists()) {
            return "File with class names does not exist: " + this.m_ClassesFile;
        }
        if (this.m_ClassesFile.isDirectory()) {
            return "File with class names points to directory: " + this.m_ClassesFile;
        }
        String error = this.readFile(this.m_ClassesFile, this.m_Classes);
        if (error != null) {
            return error;
        }
        if (this.m_AdditionalFile != null && this.m_AdditionalFile.exists() && !this.m_AdditionalFile.isDirectory() && (error = this.readFile(this.m_AdditionalFile, this.m_Resources)) != null) {
            return error;
        }
        return null;
    }

    protected List<String> filter(List<String> lines, String regexp, boolean invert) {
        ArrayList<String> result = new ArrayList<String>();
        Pattern pattern = Pattern.compile(regexp);
        for (String line : lines) {
            if (invert) {
                if (pattern.matcher(line).matches()) continue;
                result.add(line);
                continue;
            }
            if (!pattern.matcher(line).matches()) continue;
            result.add(line);
        }
        return result;
    }

    protected String packagesRegExp() {
        StringBuilder result = new StringBuilder();
        result.append(".* (");
        for (int i = 0; i < this.m_Packages.size(); ++i) {
            String pkg;
            if (i > 0) {
                result.append("|");
            }
            if (!(pkg = this.m_Packages.get(i)).endsWith(".")) {
                pkg = pkg + ".";
            }
            pkg = pkg.replace(".", "\\.");
            result.append(pkg);
        }
        result.append(").*$");
        return result.toString();
    }

    protected String determine() {
        for (String cls : this.m_Classes) {
            System.err.println(cls);
            String[] cmd = new String[]{this.m_Jdeps.getAbsolutePath(), "-cp", this.m_ClassPath, "-recursive", "-verbose:class", cls};
            ProcessBuilder builder = new ProcessBuilder(new String[0]);
            builder.command(cmd);
            CollectingProcessOutput output = new CollectingProcessOutput();
            try {
                output.monitor(builder);
            }
            catch (Exception e) {
                return "Failed to execute: " + builder.toString() + "\n" + e;
            }
            List<String> lines = new ArrayList<String>(Arrays.asList(output.getStdOut().replace("\r", "").split("\n")));
            lines = this.filter(lines, this.packagesRegExp(), false);
            lines = this.filter(lines, ".*\\$.*", true);
            lines = this.filter(lines, ".*\\.jar\\)", true);
            for (int i = 0; i < lines.size(); ++i) {
                String line = lines.get(i);
                line = line.replaceFirst(".* -> ", "");
                line = line.replaceFirst(" .*$", "");
                line = line.trim();
                lines.set(i, line);
            }
            this.m_DependentClasses.addAll(lines);
            System.err.println("--> " + this.m_DependentClasses.size());
        }
        return null;
    }

    public String execute() {
        this.initialize();
        String result = this.check();
        if (result == null) {
            result = this.determine();
        }
        if (result == null) {
            this.m_Dependencies = new ArrayList<String>();
            this.m_Dependencies.addAll(this.m_Classes);
            for (String cls : this.m_DependentClasses) {
                if (this.m_Dependencies.contains(cls)) continue;
                this.m_Dependencies.add(cls);
            }
            for (String cls : this.m_Resources) {
                if (this.m_Dependencies.contains(cls)) continue;
                this.m_Dependencies.add(cls);
            }
            Collections.sort(this.m_Dependencies);
        }
        return result;
    }

    public void output() {
        if (this.m_OutputFile == null || this.m_OutputFile.isDirectory()) {
            for (String dep : this.m_Dependencies) {
                System.out.println(dep);
            }
        } else {
            try {
                Files.write(this.m_OutputFile.toPath(), this.m_Dependencies, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            }
            catch (Exception e) {
                System.err.println("Failed to write dependencies to: " + this.m_OutputFile);
                e.printStackTrace();
            }
        }
    }

    public List<String> getDependencies() {
        return this.m_Dependencies;
    }

    public static void main(String[] args) throws Exception {
        MinDeps mindeps = new MinDeps();
        if (mindeps.setOptions(args)) {
            String error = mindeps.execute();
            if (error != null) {
                System.err.println(error);
                System.exit(2);
            } else {
                mindeps.output();
            }
        } else {
            System.exit(1);
        }
    }
}

