/*
 * Decompiled with CFR 0.152.
 */
package com.github.fracpete.gpsformats4j;

import com.github.fracpete.gpsformats4j.core.BaseObject;
import com.github.fracpete.gpsformats4j.core.OptionHandler;
import com.github.fracpete.gpsformats4j.core.OptionUtils;
import com.github.fracpete.gpsformats4j.formats.Format;
import com.github.fracpete.gpsformats4j.formats.FormatWithOptionHandling;
import com.github.fracpete.gpsformats4j.formats.Formats;
import java.io.File;
import java.util.List;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.internal.HelpScreenException;
import org.apache.commons.csv.CSVRecord;

public class Convert
extends BaseObject
implements OptionHandler {
    public static final String INPUT_FILE = "in_file";
    public static final String INPUT_FORMAT = "in_format";
    public static final String INPUT_OPTIONS = "in_options";
    public static final String OUTPUT_FILE = "out_file";
    public static final String OUTPUT_FORMAT = "out_format";
    public static final String OUTPUT_OPTIONS = "out_options";
    protected ArgumentParser m_Parser;
    protected File m_InputFile;
    protected Class m_InputFormat;
    protected String m_InputOptions;
    protected File m_OutputFile;
    protected Class m_OutputFormat;
    protected String m_OutputOptions;
    protected boolean m_HelpRequested;

    @Override
    protected void initialize() {
        super.initialize();
        Object[] formats = new String[Formats.allFormats().length];
        for (int i = 0; i < Formats.allFormats().length; ++i) {
            formats[i] = Formats.allFormats()[i].getSimpleName();
        }
        this.m_Parser = ArgumentParsers.newArgumentParser((String)this.getClass().getSimpleName());
        this.m_Parser.description("Converts GPS formats.");
        this.m_Parser.defaultHelp(true);
        this.m_Parser.addArgument(new String[]{"--in_file"}).metavar(new String[]{"<file>"}).dest(INPUT_FILE).required(true).type(String.class).help("The input file to convert.");
        this.m_Parser.addArgument(new String[]{"--in_format"}).dest(INPUT_FORMAT).required(true).type(String.class).choices(formats).help("The input format.");
        this.m_Parser.addArgument(new String[]{"--in_options"}).metavar(new String[]{"<options>"}).dest(INPUT_OPTIONS).required(false).type(String.class).setDefault((Object)"").help("The options for the input format, if supported. Blank-separated list of key=value pairs.");
        this.m_Parser.addArgument(new String[]{"--out_file"}).metavar(new String[]{"<file>"}).dest(OUTPUT_FILE).required(true).type(String.class).help("The output file to generate.");
        this.m_Parser.addArgument(new String[]{"--out_format"}).dest(OUTPUT_FORMAT).required(true).type(String.class).choices(formats).help("The output format.");
        this.m_Parser.addArgument(new String[]{"--out_options"}).metavar(new String[]{"<options>"}).dest(OUTPUT_OPTIONS).required(false).type(String.class).setDefault((Object)"").help("The options for the output format, if supported. Blank-separated list of key=value pairs.");
    }

    public void setInputFile(File value) {
        this.m_InputFile = value;
    }

    public File getInputFile() {
        return this.m_InputFile;
    }

    public void setInputFormat(Class value) {
        this.m_InputFormat = value;
    }

    public Class getInputFormat() {
        return this.m_InputFormat;
    }

    public void setInputOptions(String value) {
        this.m_InputOptions = value;
    }

    public String getInputOptions() {
        return this.m_InputOptions;
    }

    public void setOutputFile(File value) {
        this.m_OutputFile = value;
    }

    public File getOutputFile() {
        return this.m_OutputFile;
    }

    public void setOutputFormat(Class value) {
        this.m_OutputFormat = value;
    }

    public Class getOutputFormat() {
        return this.m_OutputFormat;
    }

    public void setOutputOptions(String value) {
        this.m_OutputOptions = value;
    }

    public String getOutputOptions() {
        return this.m_OutputOptions;
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        Namespace ns;
        try {
            ns = this.m_Parser.parseArgs(options);
        }
        catch (HelpScreenException e) {
            this.m_HelpRequested = true;
            return;
        }
        catch (Exception e) {
            this.m_Parser.printHelp();
            this.m_HelpRequested = false;
            throw e;
        }
        this.setInputFile(new File(ns.getString(INPUT_FILE)));
        this.setInputFormat(Class.forName(Format.class.getPackage().getName() + "." + ns.getString(INPUT_FORMAT)));
        this.setInputOptions(ns.getString(INPUT_OPTIONS));
        this.setOutputFile(new File(ns.getString(OUTPUT_FILE)));
        this.setOutputFormat(Class.forName(Format.class.getPackage().getName() + "." + ns.getString(OUTPUT_FORMAT)));
        this.setOutputOptions(ns.getString(OUTPUT_OPTIONS));
    }

    @Override
    public String toHelp() {
        return this.m_Parser.formatHelp();
    }

    protected String doExecute() {
        List<CSVRecord> data;
        Format formatOut;
        Format formatIn;
        if (!this.m_InputFile.exists()) {
            return "Input file does not exist: " + this.m_InputFile;
        }
        if (this.m_InputFile.isDirectory()) {
            return "Input file points to a directory: " + this.m_InputFile;
        }
        try {
            formatIn = (Format)this.m_InputFormat.newInstance();
            this.m_Logger.info("Input format: " + formatIn.getClass().getName());
            formatOut = (Format)this.m_OutputFormat.newInstance();
            this.m_Logger.info("Output format: " + formatOut.getClass().getName());
        }
        catch (Exception e) {
            return "Error configuring formats: " + e.toString();
        }
        if (!formatIn.canRead()) {
            return "Input format does not support reading!";
        }
        if (!formatOut.canWrite()) {
            return "Output format does not support writing!";
        }
        if (formatIn instanceof FormatWithOptionHandling && !this.m_InputOptions.isEmpty()) {
            try {
                this.m_Logger.info("Input options: " + this.m_InputOptions);
                ((FormatWithOptionHandling)formatIn).setOptions(OptionUtils.split(this.m_InputOptions));
            }
            catch (Exception e) {
                return "Failed to set options for input format: " + this.m_InputOptions + "\n" + e;
            }
        }
        if (formatOut instanceof FormatWithOptionHandling && !this.m_OutputOptions.isEmpty()) {
            try {
                this.m_Logger.info("Output options: " + this.m_OutputOptions);
                ((FormatWithOptionHandling)formatOut).setOptions(OptionUtils.split(this.m_OutputOptions));
            }
            catch (Exception e) {
                return "Failed to set options for output format: " + this.m_OutputOptions + "\n" + e;
            }
        }
        if ((data = formatIn.read(this.m_InputFile)) == null) {
            return "Failed to read data from: " + this.m_InputFile;
        }
        return formatOut.write(data, this.m_OutputFile);
    }

    public String execute() {
        if (this.m_HelpRequested) {
            return null;
        }
        String result = this.doExecute();
        if (result != null) {
            this.m_Logger.error(result);
        } else {
            this.m_Logger.info("Successfully converted!");
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        Convert convert = new Convert();
        convert.setOptions(args);
        convert.execute();
    }
}

