/*
 * Decompiled with CFR 0.152.
 */
package com.github.fracpete.gpsformats4j.formats;

import com.github.fracpete.gpsformats4j.formats.AbstractFormat;
import java.io.File;
import java.io.FileWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.IOUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AbstractXMLFormat
extends AbstractFormat {
    protected Document readXML(File input) {
        try {
            this.m_Logger.info("Reading: " + input);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            factory.setNamespaceAware(true);
            factory.setIgnoringComments(true);
            factory.setIgnoringElementContentWhitespace(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.parse(input);
        }
        catch (Exception e) {
            this.m_Logger.error("Failed to read: " + input, (Throwable)e);
            return null;
        }
    }

    protected Document newDocument() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.newDocument();
        }
        catch (Exception e) {
            this.m_Logger.error("Failed to create new XML document!", (Throwable)e);
            return null;
        }
    }

    protected Element newDocument(String root) {
        Document doc = this.newDocument();
        if (doc == null) {
            return null;
        }
        Element result = doc.createElement(root);
        doc.appendChild(result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String writeXML(Document doc, File output) {
        FileWriter fwriter = null;
        try {
            this.m_Logger.info("Writing: " + output);
            TransformerFactory tfactory = TransformerFactory.newInstance();
            tfactory.setAttribute("indent-number", 2);
            Transformer transformer = tfactory.newTransformer();
            transformer.setOutputProperty("encoding", Charset.defaultCharset().toString());
            transformer.setOutputProperty("indent", "yes");
            StringWriter swriter = new StringWriter();
            transformer.transform(new DOMSource(doc), new StreamResult(swriter));
            fwriter = new FileWriter(output);
            IOUtils.write((String)swriter.toString(), (Writer)fwriter);
            IOUtils.closeQuietly((Writer)fwriter);
        }
        catch (Exception e) {
            this.m_Logger.error("Failed to write: " + output, (Throwable)e);
            String string = "Failed to write: " + output + "\n" + e;
            return string;
        }
        finally {
            IOUtils.closeQuietly(fwriter);
        }
        return null;
    }
}

