/*
 * Decompiled with CFR 0.152.
 */
package com.github.fracpete.gpsformats4j.formats;

import com.github.fracpete.gpsformats4j.formats.AbstractFormat;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.csv.CSVRecordFactory;
import org.apache.commons.io.IOUtils;

public class CSV
extends AbstractFormat {
    @Override
    public boolean canRead() {
        return true;
    }

    @Override
    public List<CSVRecord> read(File input) {
        ArrayList<CSVRecord> result = new ArrayList<CSVRecord>();
        try {
            this.m_Logger.info("Reading: " + input);
            CSVParser parser = CSVParser.parse((File)input, (Charset)Charset.defaultCharset(), (CSVFormat)CSVFormat.DEFAULT);
            for (CSVRecord rec : parser) {
                result.add(rec);
            }
        }
        catch (Exception e) {
            this.m_Logger.error("Failed to read: " + input, (Throwable)e);
            return null;
        }
        return result;
    }

    @Override
    public boolean canWrite() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String write(List<CSVRecord> data, File output) {
        FileWriter writer = null;
        CSVPrinter printer = null;
        try {
            this.m_Logger.info("Writing: " + output);
            writer = new FileWriter(output);
            printer = new CSVPrinter((Appendable)writer, CSVFormat.DEFAULT);
            boolean first = true;
            for (CSVRecord rec : data) {
                if (first) {
                    HashMap<String, Integer> map = new HashMap<String, Integer>();
                    map.put("Track", 0);
                    map.put("Time", 1);
                    map.put("Latitude", 2);
                    map.put("Longitude", 3);
                    map.put("Elevation", 4);
                    ArrayList<String> values = new ArrayList<String>();
                    values.add("Track");
                    values.add("Time");
                    values.add("Latitude");
                    values.add("Longitude");
                    values.add("Elevation");
                    CSVRecord header = CSVRecordFactory.newRecord(values.toArray(new String[values.size()]), map);
                    printer.printRecord((Iterable)header);
                }
                printer.printRecord((Iterable)rec);
                first = false;
            }
            printer.flush();
            printer.close();
        }
        catch (Exception e) {
            String string;
            try {
                this.m_Logger.error("Failed to write: " + output, (Throwable)e);
                string = "Failed to write: " + output + "\n" + e;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                IOUtils.closeQuietly(printer);
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)writer);
            IOUtils.closeQuietly((Closeable)printer);
            return string;
        }
        IOUtils.closeQuietly((Writer)writer);
        IOUtils.closeQuietly((Closeable)printer);
        return null;
    }
}

