/*
 * Decompiled with CFR 0.152.
 */
package com.github.fracpete.gpsformats4j.formats;

import com.github.fracpete.gpsformats4j.formats.AbstractXMLFormat;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.csv.CSVRecordFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GPX
extends AbstractXMLFormat {
    @Override
    public boolean canRead() {
        return true;
    }

    @Override
    public List<CSVRecord> read(File input) {
        ArrayList<CSVRecord> result = new ArrayList<CSVRecord>();
        try {
            Document doc = this.readXML(input);
            NodeList segs = doc.getElementsByTagName("trkseg");
            int count = 0;
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            map.put("Track", 0);
            map.put("Time", 1);
            map.put("Latitude", 2);
            map.put("Longitude", 3);
            map.put("Elevation", 4);
            for (int t = 0; t < segs.getLength(); ++t) {
                segs = ((Element)segs.item(t)).getElementsByTagName("trkpt");
                for (int p = 0; p < segs.getLength(); ++p) {
                    ++count;
                    ArrayList<String> values = new ArrayList<String>();
                    Element seg = (Element)segs.item(p);
                    values.add("" + t);
                    NodeList children = seg.getElementsByTagName("time");
                    values.add(children.item(0).getTextContent().trim());
                    values.add(seg.getAttribute("lat").trim());
                    values.add(seg.getAttribute("lon").trim());
                    children = seg.getElementsByTagName("ele");
                    values.add(children.item(0).getTextContent().trim());
                    CSVRecord rec = CSVRecordFactory.newRecord(values.toArray(new String[values.size()]), map, null, count, -1L);
                    result.add(rec);
                }
            }
        }
        catch (Exception e) {
            this.m_Logger.error("Failed to read: " + input, (Throwable)e);
            return null;
        }
        return result;
    }

    @Override
    public boolean canWrite() {
        return true;
    }

    @Override
    public String write(List<CSVRecord> data, File output) {
        try {
            Element gpx = this.newDocument("gpx");
            Document doc = gpx.getOwnerDocument();
            gpx.setAttribute("xmlns", "http://www.topografix.com/GPX/1/1");
            gpx.setAttribute("xmlns:gpxx", "http://www.garmin.com/xmlschemas/GpxExtensions/v3");
            gpx.setAttribute("xmlns:gpxtpx", "\"http://www.garmin.com/xmlschemas/TrackPointExtension/v1");
            gpx.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            gpx.setAttribute("xsi:schemaLocation", "http://www.topografix.com/GPX/1/1 http://www.topografix.com/GPX/1/1/gpx.xsd http://www.garmin.com/xmlschemas/GpxExtensions/v3 http://www.garmin.com/xmlschemas/GpxExtensionsv3.xsd http://www.garmin.com/xmlschemas/TrackPointExtension/v1 http://www.garmin.com/xmlschemas/TrackPointExtensionv1.xsd");
            gpx.setAttribute("creator", "gpsformats4j");
            String oldTrack = "";
            Node seg = null;
            for (CSVRecord rec : data) {
                Element child;
                if (!oldTrack.equals(rec.get("Track"))) {
                    oldTrack = rec.get("Track");
                    Element track = doc.createElement("trk");
                    gpx.appendChild(track);
                    child = doc.createElement("name");
                    child.setTextContent(rec.get("Track"));
                    track.appendChild(child);
                    seg = doc.createElement("trkseg");
                    track.appendChild(seg);
                }
                Element point = doc.createElement("trkpt");
                point.setAttribute("lat", rec.get("Latitude"));
                point.setAttribute("lon", rec.get("Longitude"));
                seg.appendChild(point);
                child = doc.createElement("ele");
                child.setTextContent(rec.get("Elevation"));
                point.appendChild(child);
                child = doc.createElement("time");
                child.setTextContent(rec.get("Time"));
                point.appendChild(child);
            }
            return this.writeXML(doc, output);
        }
        catch (Exception e) {
            this.m_Logger.error("Failed to write: " + output, (Throwable)e);
            return "Failed to write: " + output + "\n" + e;
        }
    }
}

