/*
 * Decompiled with CFR 0.152.
 */
package com.github.fracpete.gpsformats4j.formats;

import com.github.fracpete.gpsformats4j.formats.AbstractXMLFormat;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.csv.CSVRecordFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class KML
extends AbstractXMLFormat {
    @Override
    public boolean canRead() {
        return true;
    }

    @Override
    public List<CSVRecord> read(File input) {
        ArrayList<CSVRecord> result = new ArrayList<CSVRecord>();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        int count = 0;
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("Track", 0);
        map.put("Time", 1);
        map.put("Latitude", 2);
        map.put("Longitude", 3);
        map.put("Elevation", 4);
        try {
            Document doc = this.readXML(input);
            NodeList pms = doc.getElementsByTagName("Placemark");
            for (int i = 0; i < pms.getLength(); ++i) {
                Element pm = (Element)pms.item(i);
                NodeList list = pm.getElementsByTagName("name");
                String track = list.getLength() == 1 ? list.item(0).getTextContent().trim() : "" + i;
                GregorianCalendar cal = new GregorianCalendar();
                cal.set(1, 2000);
                cal.set(2, 0);
                cal.set(5, 1);
                cal.set(11, 0);
                cal.set(12, 0);
                cal.set(13, 0);
                list = pm.getElementsByTagName("coordinates");
                for (int c = 0; c < list.getLength(); ++c) {
                    String[] coords;
                    Element coordinates = (Element)list.item(c);
                    for (String coord : coords = coordinates.getTextContent().split(" ")) {
                        String[] parts;
                        if (coord.trim().isEmpty() || (parts = coord.trim().split(",")).length != 3) continue;
                        ++count;
                        ((Calendar)cal).add(13, 1);
                        ArrayList<String> values = new ArrayList<String>();
                        values.add(track);
                        values.add(df.format(cal.getTime()));
                        values.addAll(Arrays.asList(parts));
                        CSVRecord rec = CSVRecordFactory.newRecord(values.toArray(new String[values.size()]), map, null, count, -1L);
                        result.add(rec);
                    }
                }
            }
        }
        catch (Exception e) {
            this.m_Logger.error("Failed to read: " + input, (Throwable)e);
            return null;
        }
        return result;
    }

    @Override
    public boolean canWrite() {
        return true;
    }

    @Override
    public String write(List<CSVRecord> data, File output) {
        try {
            Element kml = this.newDocument("kml");
            kml.setAttribute("xmlns", "http://www.opengis.net/kml/2.2");
            Document doc = kml.getOwnerDocument();
            Element root = doc.createElement("Document");
            kml.appendChild(root);
            String oldTrack = "";
            Element pm = null;
            Node coordinates = null;
            StringBuilder coords = new StringBuilder();
            for (CSVRecord rec : data) {
                if (!oldTrack.equals(rec.get("Track"))) {
                    if (coordinates != null) {
                        coordinates.setTextContent(coords.toString());
                    }
                    coords = new StringBuilder();
                    oldTrack = rec.get("Track");
                    pm = doc.createElement("Placemark");
                    root.appendChild(pm);
                    Element child = doc.createElement("name");
                    child.setTextContent(rec.get("Track"));
                    pm.appendChild(child);
                    child = doc.createElement("extrude");
                    child.setTextContent("1");
                    pm.appendChild(child);
                    child = doc.createElement("tessellate");
                    child.setTextContent("1");
                    pm.appendChild(child);
                    child = doc.createElement("altitudeMode");
                    child.setTextContent("absolute");
                    pm.appendChild(child);
                    coordinates = doc.createElement("coordinates");
                    pm.appendChild(coordinates);
                }
                if (coords.length() > 0) {
                    coords.append(" ");
                }
                coords.append(rec.get("Latitude"));
                coords.append(",");
                coords.append(rec.get("Longitude"));
                coords.append(",");
                coords.append(rec.get("Elevation"));
            }
            if (coordinates != null && coords.length() > 0) {
                coordinates.setTextContent(coords.toString());
            }
            return this.writeXML(doc, output);
        }
        catch (Exception e) {
            this.m_Logger.error("Failed to write: " + output, (Throwable)e);
            return "Failed to write: " + output + "\n" + e;
        }
    }
}

