/*
 * Decompiled with CFR 0.152.
 */
package com.github.fracpete.gpsformats4j.formats;

import com.github.fracpete.gpsformats4j.formats.AbstractXMLFormat;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.csv.CSVRecordFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TCX
extends AbstractXMLFormat {
    @Override
    public boolean canRead() {
        return true;
    }

    @Override
    public List<CSVRecord> read(File input) {
        ArrayList<CSVRecord> result = new ArrayList<CSVRecord>();
        try {
            Document doc = this.readXML(input);
            NodeList tracks = doc.getElementsByTagName("Track");
            int count = 0;
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            map.put("Track", 0);
            map.put("Time", 1);
            map.put("Latitude", 2);
            map.put("Longitude", 3);
            map.put("Elevation", 4);
            for (int t = 0; t < tracks.getLength(); ++t) {
                NodeList points = ((Element)tracks.item(t)).getElementsByTagName("Trackpoint");
                for (int p = 0; p < points.getLength(); ++p) {
                    ++count;
                    ArrayList<String> values = new ArrayList<String>();
                    Element point = (Element)points.item(p);
                    values.add("" + t);
                    NodeList children = point.getElementsByTagName("Time");
                    values.add(children.item(0).getTextContent().trim());
                    children = point.getElementsByTagName("LatitudeDegrees");
                    values.add(children.item(0).getTextContent().trim());
                    children = point.getElementsByTagName("LongitudeDegrees");
                    values.add(children.item(0).getTextContent().trim());
                    children = point.getElementsByTagName("AltitudeMeters");
                    values.add(children.item(0).getTextContent().trim());
                    CSVRecord rec = CSVRecordFactory.newRecord(values.toArray(new String[values.size()]), map, null, count, -1L);
                    result.add(rec);
                }
            }
        }
        catch (Exception e) {
            this.m_Logger.error("Failed to read: " + input, (Throwable)e);
            return null;
        }
        return result;
    }

    @Override
    public boolean canWrite() {
        return true;
    }

    @Override
    public String write(List<CSVRecord> data, File output) {
        try {
            Element tcx = this.newDocument("TrainingCenterDatabase");
            Document doc = tcx.getOwnerDocument();
            tcx.setAttribute("xmlns", "http://www.garmin.com/xmlschemas/TrainingCenterDatabase/v2");
            tcx.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            tcx.setAttribute("xsi:schemaLocation", "http://www.garmin.com/xmlschemas/TrainingCenterDatabase/v2 http://www.garmin.com/xmlschemas/TrainingCenterDatabasev2.xsd");
            Element acts = doc.createElement("Activities");
            tcx.appendChild(acts);
            String oldTrack = "";
            Node track = null;
            for (CSVRecord rec : data) {
                Element child;
                if (!oldTrack.equals(rec.get("Track"))) {
                    oldTrack = rec.get("Track");
                    Element act = doc.createElement("Activity");
                    act.setAttribute("Sport", "Other");
                    acts.appendChild(act);
                    child = doc.createElement("Id");
                    child.setTextContent(rec.get("Track"));
                    act.appendChild(child);
                    Element lap = doc.createElement("Lap");
                    lap.setAttribute("StartTime", rec.get("Time"));
                    act.appendChild(lap);
                    child = doc.createElement("TotalTimeSeconds");
                    child.setTextContent("0");
                    lap.appendChild(child);
                    child = doc.createElement("DistanceMeters");
                    child.setTextContent("0");
                    lap.appendChild(child);
                    child = doc.createElement("Calories");
                    child.setTextContent("0");
                    lap.appendChild(child);
                    track = doc.createElement("Track");
                    lap.appendChild(track);
                }
                Element point = doc.createElement("Trackpoint");
                track.appendChild(point);
                child = doc.createElement("Time");
                child.setTextContent(rec.get("Time"));
                point.appendChild(child);
                Element pos = doc.createElement("Position");
                point.appendChild(pos);
                child = doc.createElement("LatitudeDegrees");
                child.setTextContent(rec.get("Latitude"));
                pos.appendChild(child);
                child = doc.createElement("LongitudeDegrees");
                child.setTextContent(rec.get("Longitude"));
                pos.appendChild(child);
                child = doc.createElement("AltitudeMeters");
                child.setTextContent(rec.get("Elevation"));
                point.appendChild(child);
                child = doc.createElement("DistanceMeters");
                child.setTextContent("0.0");
                point.appendChild(child);
            }
            return this.writeXML(doc, output);
        }
        catch (Exception e) {
            this.m_Logger.error("Failed to write: " + output, (Throwable)e);
            return "Failed to write: " + output + "\n" + e;
        }
    }
}

