/*
 * Decompiled with CFR 0.152.
 */
package org.jcamp.math;

import java.io.Serializable;
import org.jcamp.math.Array;
import org.jcamp.math.IArray1D;
import org.jcamp.math.Range;
import org.jcamp.math.Range1D;

public class Array1D
extends Array
implements IArray1D,
Serializable,
Cloneable {
    private static final long serialVersionUID = -6417743545609949837L;
    private double[] array;
    private Range1D.Double range;

    public Array1D() {
        super(0);
        this.array = new double[0];
        this.range = new Range1D.Double();
    }

    public Array1D(double[] values) {
        this(values, true);
    }

    public Array1D(double[] values, boolean copy) {
        super(values.length);
        this.array = copy ? (double[])values.clone() : values;
        this.calcRange();
    }

    public Array1D(IArray1D from) {
        super(from.getLength());
        this.array = new double[from.getLength()];
        for (int i = 0; i < this.array.length; ++i) {
            this.array[i] = from.pointAt(i);
        }
        this.range = from.getRange1D();
    }

    private void calcRange() {
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        for (int i = 0; i < this.getLength(); ++i) {
            if (this.array[i] < min) {
                min = this.array[i];
            }
            if (!(this.array[i] > max)) continue;
            max = this.array[i];
        }
        this.range = new Range1D.Double(min, max);
    }

    @Override
    public Object clone() {
        Array1D array = null;
        array = (Array1D)super.clone();
        array.range = (Range1D.Double)this.range.clone();
        array.array = (double[])this.array.clone();
        return array;
    }

    @Override
    public double[] elementAt(int index) {
        return new double[]{this.array[index]};
    }

    @Override
    public double[][] elementsAt(int[] index) {
        double[][] values = new double[1][index.length];
        for (int i = 0; i < index.length; ++i) {
            int index_i = index[i];
            values[0][i] = this.array[index_i];
        }
        return values;
    }

    @Override
    public IArray1D getArray(int index) throws ArrayIndexOutOfBoundsException {
        if (index != 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this;
    }

    @Override
    public final int getDimension() {
        return 1;
    }

    @Override
    public Range.Double getRange() {
        return this.range;
    }

    @Override
    public Range1D.Double getRange1D() {
        return this.range;
    }

    @Override
    public double pointAt(int index) {
        return this.array[index];
    }

    @Override
    public void scale(double amount) {
        int i = 0;
        while (i < this.array.length) {
            int n = i++;
            this.array[n] = this.array[n] * amount;
        }
        this.range = new Range1D.Double(this.range.getXMin() * amount, this.range.getXMax() * amount);
    }

    @Override
    public double[] toArray() {
        double[] a = new double[this.array.length];
        System.arraycopy(this.array, 0, a, 0, this.array.length);
        return a;
    }

    @Override
    public void translate(double amount) {
        int i = 0;
        while (i < this.array.length) {
            int n = i++;
            this.array[n] = this.array[n] + amount;
        }
        this.range.translate(amount);
    }
}

