/*
 * Decompiled with CFR 0.152.
 */
package org.jcamp.math;

import java.io.Serializable;
import org.jcamp.math.Array;
import org.jcamp.math.Array1D;
import org.jcamp.math.IArray1D;
import org.jcamp.math.IArray2D;
import org.jcamp.math.Point2D;
import org.jcamp.math.Range;
import org.jcamp.math.Range2D;

public class Array2D
extends Array
implements IArray2D,
Serializable,
Cloneable {
    private static final long serialVersionUID = -3660969957159289155L;
    private Array1D arrayX;
    private Array1D arrayY;
    private Range2D.Double range;

    public Array2D() {
        super(0);
        this.arrayX = new Array1D();
        this.arrayY = new Array1D();
        this.range = new Range2D.Double();
    }

    public Array2D(double[][] values) {
        this(values, true);
    }

    public Array2D(double[][] values, boolean copy) {
        super(values[0].length);
        this.arrayX = new Array1D(values[0], copy);
        this.arrayY = new Array1D(values[1], copy);
        this.calcRange();
    }

    public Array2D(Array1D x, Array1D y) {
        this(x, y, true);
    }

    public Array2D(Array1D x, Array1D y, boolean copy) {
        super(x.getLength());
        if (x.getLength() != y.getLength()) {
            throw new IllegalArgumentException("x and y coordinate arrays have different dimensions");
        }
        if (copy) {
            this.arrayX = (Array1D)x.clone();
            this.arrayY = (Array1D)y.clone();
        } else {
            this.arrayX = x;
            this.arrayY = y;
        }
        this.calcRange();
    }

    private void calcRange() {
        double left = Double.MAX_VALUE;
        double right = Double.MIN_VALUE;
        double bottom = Double.MAX_VALUE;
        double top = Double.MIN_VALUE;
        int length = this.getLength();
        for (int i = 0; i < length; ++i) {
            double y;
            double x = this.arrayX.pointAt(i);
            if (x < left) {
                left = x;
            }
            if (x > right) {
                right = x;
            }
            if ((y = this.arrayY.pointAt(i)) < bottom) {
                bottom = y;
            }
            if (!(y > top)) continue;
            top = y;
        }
        this.range = new Range2D.Double(left, right, bottom, top);
    }

    @Override
    public Object clone() {
        Array2D array = null;
        array = (Array2D)super.clone();
        array.arrayX = (Array1D)this.arrayX.clone();
        array.arrayY = (Array1D)this.arrayY.clone();
        return array;
    }

    @Override
    public double[] elementAt(int index) {
        return new double[]{this.arrayX.pointAt(index), this.arrayY.pointAt(index)};
    }

    @Override
    public double[][] elementsAt(int[] index) {
        double[][] values = new double[2][index.length];
        for (int i = 0; i < index.length; ++i) {
            int index_i = index[i];
            values[0][i] = this.arrayX.pointAt(index_i);
            values[1][i] = this.arrayY.pointAt(index_i);
        }
        return values;
    }

    @Override
    public IArray1D getArray(int index) throws ArrayIndexOutOfBoundsException {
        switch (index) {
            case 0: {
                return this.arrayX;
            }
            case 1: {
                return this.arrayY;
            }
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public final int getDimension() {
        return 2;
    }

    @Override
    public Range.Double getRange() {
        return this.range;
    }

    @Override
    public Range2D.Double getRange2D() {
        return this.range;
    }

    @Override
    public IArray1D getXArray() {
        return this.arrayX;
    }

    public int getXLength() {
        return this.arrayX.getLength();
    }

    @Override
    public IArray1D getYArray() {
        return this.arrayY;
    }

    public int getYLength() {
        return this.arrayY.getLength();
    }

    @Override
    public Point2D pointAt(int index) {
        return new Point2D(this.arrayX.pointAt(index), this.arrayY.pointAt(index));
    }
}

