/*
 * Decompiled with CFR 0.152.
 */
package org.jcamp.math;

import java.io.Serializable;
import org.jcamp.math.Array;
import org.jcamp.math.Array1D;
import org.jcamp.math.IArray1D;

public class ArrayND
extends Array
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 6575500697734808219L;
    private Array1D[] arrays;

    public ArrayND() {
        super(0);
        this.arrays = new Array1D[0];
    }

    public ArrayND(double[][] values) {
        this(values, true);
    }

    public ArrayND(double[][] values, boolean copy) {
        super(values[0].length);
        this.arrays = new Array1D[values.length];
        for (int i = 0; i < this.arrays.length; ++i) {
            this.arrays[i] = new Array1D(values[i], copy);
        }
    }

    public ArrayND(Array1D[] values) {
        this(values, true);
    }

    public ArrayND(Array1D[] values, boolean copy) {
        super(values[0].getLength());
        this.arrays = new Array1D[values.length];
        for (int i = 0; i < this.arrays.length; ++i) {
            this.arrays[i] = values[i];
            if (values[i].getLength() == this.getLength()) continue;
            throw new IllegalArgumentException("dimensions of coordinate array different");
        }
    }

    @Override
    public Object clone() {
        ArrayND array = null;
        array = (ArrayND)super.clone();
        for (int i = 0; i < this.arrays.length; ++i) {
            array.arrays[i] = (Array1D)this.arrays[i].clone();
        }
        return array;
    }

    @Override
    public double[] elementAt(int index) {
        double[] values = new double[this.getDimension()];
        for (int i = 0; i < this.getDimension(); ++i) {
            values[i] = this.arrays[i].pointAt(index);
        }
        return values;
    }

    @Override
    public double[][] elementsAt(int[] index) {
        int n = this.arrays.length;
        double[][] values = new double[n][index.length];
        for (int i = 0; i < index.length; ++i) {
            int index_i = index[i];
            for (int j = 0; j < n; ++j) {
                values[j][i] = this.arrays[j].pointAt(index_i);
            }
        }
        return values;
    }

    @Override
    public IArray1D getArray(int index) throws ArrayIndexOutOfBoundsException {
        if (index < 0 || index >= this.arrays.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.arrays[index];
    }

    @Override
    public int getDimension() {
        return this.arrays.length;
    }
}

