/*
 * Decompiled with CFR 0.152.
 */
package org.jcamp.math;

import org.jcamp.math.DataMap;
import org.jcamp.math.Grid1D;
import org.jcamp.math.IInterval1D;
import org.jcamp.math.IrregularGrid1D;
import org.jcamp.math.Range1D;

public abstract class AxisMap
extends DataMap {
    protected IInterval1D data = null;
    protected Grid1D grid;
    protected Range1D.Double dataRange = new Range1D.Double(0.0, 1.0);
    protected Range1D.Double realZoomRange = new Range1D.Double(0.0, 1.0);
    protected Range1D.Double fullViewRange = new Range1D.Double(0.0, 1.0);
    protected Range1D.Double gridZoomRange = new Range1D.Double(0.0, 1.0);
    protected static final double ZOOM_EPS = 1.0E-10;

    AxisMap() {
    }

    public AxisMap(IInterval1D data) {
        this.data = data;
        if (data != null) {
            if (data.getRange1D().getXWidth() > 0.0) {
                this.setDataRange(data.getRange1D());
                this.setFullViewRange(data.getRange1D());
            } else {
                this.setDataRange(data.getRange1D());
                double x = data.getRange1D().getXMax();
                this.setFullViewRange(new Range1D.Double(x - 0.5 * x, x + 0.5 * x));
            }
        }
    }

    public static double alignTickStep(double s) {
        double fac = 1.0;
        if (s < 1.0E-10 || Double.isNaN(s) || Double.isInfinite(s)) {
            return 1.0E-10;
        }
        while (s > 100.0) {
            s *= 0.1;
            fac *= 10.0;
        }
        while (s < 10.0) {
            s *= 10.0;
            fac *= 0.1;
        }
        if (s > 50.0) {
            s = Math.abs(s - 100.0) > Math.abs(s - 50.0) ? 50.0 : 100.0;
        } else if (s > 25.0) {
            s = Math.abs(s - 50.0) > Math.abs(s - 25.0) ? 25.0 : 50.0;
        } else if (s > 20.0) {
            s = Math.abs(s - 25.0) > Math.abs(s - 20.0) ? 25.0 : 20.0;
        } else if (s > 10.0) {
            s = Math.abs(s - 20.0) > Math.abs(s - 10.0) ? 20.0 : 10.0;
        }
        return s * fac;
    }

    protected abstract void calcGrid();

    public IInterval1D getData() {
        return this.data;
    }

    public Range1D getDataRange() {
        return this.dataRange;
    }

    public Range1D.Double getFullViewRange() {
        return this.fullViewRange;
    }

    public Grid1D getGrid() {
        return this.grid;
    }

    @Override
    public final Range1D.Double getMapRange() {
        return new Range1D.Double(0.0, 1.0);
    }

    public Range1D getZoomRange() {
        return this.realZoomRange;
    }

    public boolean isAscending() {
        return this.getGrid().isAscending();
    }

    @Override
    public double[] map(double[] world) {
        double[] gridvalues = this.grid.coordinatesAt(world);
        double scale = 1.0 / this.gridZoomRange.getXWidth();
        int i = 0;
        while (i < gridvalues.length) {
            int n = i;
            gridvalues[n] = gridvalues[n] - this.gridZoomRange.getXMin();
            int n2 = i++;
            gridvalues[n2] = gridvalues[n2] * scale;
        }
        return gridvalues;
    }

    @Override
    public double map(double world) {
        double value = (this.grid.coordinateAt(world) - this.gridZoomRange.getXMin()) / this.gridZoomRange.getXWidth();
        return value;
    }

    public Grid1D map(Grid1D grid) {
        double[] g = grid.asArray();
        double[] h = this.map(g);
        return new IrregularGrid1D(h);
    }

    public Range1D.Double map(Range1D.Double world) {
        return new Range1D.Double(this.map(world.getXMin()), this.map(world.getXMax()));
    }

    public void resetZoom() {
        this.realZoomRange.set(this.fullViewRange);
        this.calcGrid();
    }

    @Override
    public double[] reverseMap(double[] v) {
        double[] gridv = new double[v.length];
        double scale = this.gridZoomRange.getXWidth();
        for (int i = 0; i < v.length; ++i) {
            gridv[i] = scale * v[i] + this.gridZoomRange.getXMin();
        }
        double[] values = this.grid.valuesAt(gridv);
        return values;
    }

    @Override
    public double reverseMap(double v) {
        double gridv = v * this.gridZoomRange.getXWidth() + this.gridZoomRange.getXMin();
        double value = this.grid.valueAt(gridv);
        return value;
    }

    public Grid1D reverseMap(Grid1D grid) {
        double[] g = grid.asArray();
        double[] h = this.reverseMap(g);
        return new IrregularGrid1D(h);
    }

    public Range1D.Double reverseMap(Range1D.Double v) {
        return new Range1D.Double(this.reverseMap(v.getXMin()), this.reverseMap(v.getXMax()));
    }

    private void setDataRange(Range1D newDataRange) {
        if (newDataRange != null) {
            this.dataRange.set(newDataRange);
            if (this.dataRange.getXWidth() > 0.0) {
                this.fullViewRange.set(this.dataRange);
                this.realZoomRange.set(this.dataRange);
            } else {
                this.fullViewRange.set(this.dataRange.getXMin() - 0.1, this.dataRange.getXMax() + 0.1);
                this.realZoomRange.set(this.dataRange.getXMin() - 0.1, this.dataRange.getXMax() + 0.1);
            }
            this.calcGrid();
        }
    }

    public void setFullViewRange(Range1D newFullViewRange) {
        this.fullViewRange.set(newFullViewRange);
        this.setZoomRange(newFullViewRange);
    }

    public void setZoomRange(double x0, double x1) {
        this.realZoomRange.set(x0, x1);
        this.calcGrid();
    }

    public void setZoomRange(Range1D zoom) {
        this.realZoomRange.set(zoom);
        this.calcGrid();
    }
}

