/*
 * Decompiled with CFR 0.152.
 */
package org.jcamp.math;

import java.awt.Color;
import org.jcamp.math.ColorMap;
import org.jcamp.math.Grid1D;
import org.jcamp.math.IInterval1D;
import org.jcamp.math.LinearGrid1D;
import org.jcamp.math.Range;
import org.jcamp.math.Range1D;

public class ColorTable
extends ColorMap {
    private static final Color[] WFCOLORS = new Color[16];
    private static final Color[] TWCOLORS;
    private Color[] colorTable = WFCOLORS;

    ColorTable() {
    }

    public ColorTable(Grid1D data) {
        super(data);
    }

    public ColorTable(IInterval1D data) {
        this(ColorTable.makeGrid(data.getRange1D()));
    }

    public ColorTable(Range1D data) {
        this(ColorTable.makeGrid(new Range1D.Double(data)));
    }

    public Color[] getColorTable() {
        return this.colorTable;
    }

    @Override
    public Range1D.Double[] getLegend() {
        int n = this.getColorGrid().getLength();
        Range1D.Double[] legend = new Range1D.Double[n];
        for (int i = 0; i < n; ++i) {
            legend[i] = new Range1D.Double(this.getColorGrid().pointAt(i), this.getColorGrid().pointAt(i + 1));
        }
        return legend;
    }

    private static LinearGrid1D makeGrid(Range1D.Double range) {
        double step = ColorTable.alignGridStep(range.getXWidth() / (double)WFCOLORS.length);
        double left = Math.floor(range.getXMin() / step) * step;
        double right = Math.ceil(range.getXMax() / step) * step;
        return new LinearGrid1D(left, right, step);
    }

    @Override
    public Color map(double value) {
        double grid = this.getColorGrid().coordinateAt(value);
        int colorIndex = Math.max(0, Math.min(this.colorTable.length - 1, (int)grid));
        return this.colorTable[colorIndex];
    }

    public void setColorTable(Color[] newColorTable) {
        if (this.colorTable.length != newColorTable.length) {
            Range.Double gridRange = this.getColorGrid().getRange();
            this.setColorGrid(new LinearGrid1D(gridRange.getMin(0), gridRange.getMax(0), newColorTable.length));
        }
        this.colorTable = newColorTable;
    }

    static {
        ColorTable.WFCOLORS[0] = new Color(0, 0, 80);
        ColorTable.WFCOLORS[1] = new Color(0, 0, 140);
        ColorTable.WFCOLORS[2] = new Color(0, 120, 160);
        ColorTable.WFCOLORS[3] = new Color(0, 180, 180);
        ColorTable.WFCOLORS[4] = new Color(0, 255, 180);
        ColorTable.WFCOLORS[5] = new Color(0, 220, 100);
        ColorTable.WFCOLORS[6] = new Color(0, 255, 0);
        ColorTable.WFCOLORS[7] = new Color(0, 210, 0);
        ColorTable.WFCOLORS[8] = new Color(140, 230, 0);
        ColorTable.WFCOLORS[9] = new Color(230, 230, 0);
        ColorTable.WFCOLORS[10] = new Color(255, 255, 0);
        ColorTable.WFCOLORS[11] = new Color(255, 180, 0);
        ColorTable.WFCOLORS[12] = new Color(220, 100, 0);
        ColorTable.WFCOLORS[13] = new Color(220, 0, 0);
        ColorTable.WFCOLORS[14] = new Color(255, 0, 0);
        ColorTable.WFCOLORS[15] = new Color(255, 120, 120);
        TWCOLORS = new Color[256];
        for (int i = 0; i < 256; ++i) {
            ColorTable.TWCOLORS[i] = new Color(i / 16 * 16, i, 255 - i);
        }
    }
}

