/*
 * Decompiled with CFR 0.152.
 */
package org.jcamp.math;

import java.io.Serializable;
import org.jcamp.math.Grid;
import org.jcamp.math.IOrderedArray1D;
import org.jcamp.math.Range;
import org.jcamp.math.Range1D;

public abstract class Grid1D
extends Grid
implements IOrderedArray1D,
Cloneable,
Serializable {
    private static final long serialVersionUID = 6773857584138997622L;

    public Grid1D() {
    }

    public Grid1D(int length) {
        super(length);
    }

    public double[] asArray() {
        double[] g = new double[this.getLengthX()];
        for (int i = 0; i < this.getLengthX(); ++i) {
            g[i] = this.pointAt(i);
        }
        return g;
    }

    @Override
    public Object clone() {
        Grid1D grid = null;
        grid = (Grid1D)super.clone();
        return grid;
    }

    @Override
    public double[] coordinateAt(double[] value) {
        double grid = this.coordinateAt(value[0]);
        return new double[]{grid};
    }

    public abstract double coordinateAt(double var1);

    @Override
    public double[][] coordinatesAt(double[][] values) {
        double[][] grid = new double[][]{this.coordinatesAt(values[0])};
        return grid;
    }

    public double[] coordinatesAt(double[] values) {
        int n = values.length;
        double[] grid = new double[n];
        for (int i = 0; i < n; ++i) {
            grid[i] = this.coordinateAt(values[i]);
        }
        return grid;
    }

    @Override
    public final int getDimension() {
        return 1;
    }

    public int getLengthX() {
        return this.getLength();
    }

    @Override
    public abstract Range.Double getRange();

    @Override
    public abstract Range1D.Double getRange1D();

    @Override
    public double[] gridPointAt(int index) {
        return new double[]{this.pointAt(index)};
    }

    @Override
    public double[][] gridPointsAt(int[] indices) {
        double[] grid = this.pointsAt(indices);
        return new double[][]{grid};
    }

    @Override
    public int indexAt(double[] value) {
        return (int)(this.coordinateAt(value[0]) + 0.5);
    }

    @Override
    public int indexAt(double value) {
        return (int)(this.coordinateAt(value) + 0.5);
    }

    @Override
    public int[] indicesAt(double[][] values) {
        int[] indices = new int[values[0].length];
        for (int i = 0; i < values[0].length; ++i) {
            indices[i] = this.indexAt(values[0][i]);
        }
        return indices;
    }

    public abstract boolean isAscending();

    @Override
    public abstract double pointAt(int var1);

    public double[] pointsAt(int[] indices) {
        int n = indices.length;
        double[] grid = new double[n];
        for (int i = 0; i < n; ++i) {
            grid[i] = this.pointAt(indices[i]);
        }
        return grid;
    }

    @Override
    public double[] valueAt(double[] grid) {
        double value = this.valueAt(grid[0]);
        return new double[]{value};
    }

    public abstract double valueAt(double var1);

    @Override
    public double[][] valuesAt(double[][] grid) {
        double[] value = this.valuesAt(grid[0]);
        return new double[][]{value};
    }

    public double[] valuesAt(double[] grid) {
        int n = grid.length;
        double[] values = new double[n];
        for (int i = 0; i < n; ++i) {
            values[i] = this.valueAt(grid[i]);
        }
        return values;
    }
}

