/*
 * Decompiled with CFR 0.152.
 */
package org.jcamp.math;

import java.io.Serializable;
import org.jcamp.math.Grid;
import org.jcamp.math.IOrderedArray2D;
import org.jcamp.math.Point2D;
import org.jcamp.math.Range;
import org.jcamp.math.Range2D;

public abstract class Grid2D
extends Grid
implements IOrderedArray2D,
Cloneable,
Serializable {
    private static final long serialVersionUID = -5585688358617134086L;
    private int lengthY;
    private int lengthX;

    public Grid2D() {
        this.lengthY = 0;
        this.lengthX = 0;
    }

    public Grid2D(int lengthX, int lengthY) {
        super(lengthX * lengthY);
        this.lengthX = lengthX;
        this.lengthY = lengthY;
    }

    @Override
    public Object clone() {
        Grid2D grid = null;
        grid = (Grid2D)super.clone();
        return grid;
    }

    @Override
    public double[] coordinateAt(double[] value) {
        return this.coordinateAt(value[0], value[1]);
    }

    public abstract double[] coordinateAt(double var1, double var3);

    @Override
    public double[][] coordinatesAt(double[][] value) {
        return this.coordinatesAt(value[0], value[1]);
    }

    public abstract double[][] coordinatesAt(double[] var1, double[] var2);

    @Override
    public final int getDimension() {
        return 2;
    }

    @Override
    public abstract Range.Double getRange();

    @Override
    public abstract Range2D.Double getRange2D();

    public int getXLength() {
        return this.lengthX;
    }

    public int getYLength() {
        return this.lengthY;
    }

    @Override
    public abstract double[] gridPointAt(int var1);

    @Override
    public abstract double[][] gridPointsAt(int[] var1);

    @Override
    public int indexAt(double[] position) {
        double[] g = this.coordinateAt(position);
        int ix = (int)(g[0] + 0.5);
        int iy = (int)(g[1] + 0.5);
        return iy * this.lengthX + ix;
    }

    @Override
    public int indexAt(double x, double y) {
        double[] g = this.coordinateAt(x, y);
        int ix = (int)(g[0] + 0.5);
        int iy = (int)(g[1] + 0.5);
        return iy * this.lengthX + ix;
    }

    @Override
    public int indexAt(Point2D p) {
        double[] g = this.coordinateAt(p.x, p.y);
        int ix = (int)(g[0] + 0.5);
        int iy = (int)(g[1] + 0.5);
        return iy * this.lengthX + ix;
    }

    @Override
    public int[] indicesAt(double[][] values) {
        int[] indices = new int[values[0].length];
        for (int i = 0; i < values[0].length; ++i) {
            indices[i] = this.indexAt(values[0][i], values[1][i]);
        }
        return indices;
    }

    @Override
    public Point2D pointAt(int index) {
        double[] c = this.gridPointAt(index);
        return new Point2D(c[0], c[1]);
    }

    protected void setXLength(int newLengthX) {
        this.lengthX = newLengthX;
    }

    protected void setYLength(int newLengthY) {
        this.lengthY = newLengthY;
    }

    @Override
    public double[] valueAt(double[] grid) {
        return this.valueAt(grid[0], grid[1]);
    }

    public abstract double[] valueAt(double var1, double var3);

    @Override
    public double[][] valuesAt(double[][] grid) {
        return this.valuesAt(grid[0], grid[1]);
    }

    public abstract double[][] valuesAt(double[] var1, double[] var2);
}

